/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.codehaus.plexus.archiver.AbstractArchiveFinalizer;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public class DotDirectiveArchiveFinalizer
extends AbstractArchiveFinalizer {
    private static final String DEFAULT_DOT_FILE_PREFIX = ".plxarc";
    private final File dotFileDirectory;
    private final String dotFilePrefix;

    public DotDirectiveArchiveFinalizer(File dotFileDirectory) {
        this(dotFileDirectory, DEFAULT_DOT_FILE_PREFIX);
    }

    public DotDirectiveArchiveFinalizer(File dotFileDirectory, String dotFilePrefix) {
        this.dotFileDirectory = dotFileDirectory;
        this.dotFilePrefix = dotFilePrefix;
    }

    @Override
    public void finalizeArchiveCreation(Archiver archiver) throws ArchiverException {
        BufferedReader in = null;
        try {
            List<File> dotFiles = FileUtils.getFiles(this.dotFileDirectory, this.dotFilePrefix + "*", null);
            Iterator<File> iterator = dotFiles.iterator();
            while (iterator.hasNext()) {
                File dotFile1;
                File dotFile = dotFile1 = iterator.next();
                in = new BufferedReader(new FileReader(dotFile));
                String line = in.readLine();
                while (line != null) {
                    File directory;
                    String[] s = StringUtils.split(line, ":");
                    if (s.length == 1) {
                        directory = new File(this.dotFileDirectory, s[0]);
                        System.out.println("adding directory = " + directory);
                        archiver.addDirectory(directory);
                    } else {
                        directory = new File(this.dotFileDirectory, s[0]);
                        System.out.println("adding directory = " + directory + " to: " + s[1]);
                        if (s[1].endsWith("/")) {
                            archiver.addDirectory(directory, s[1]);
                        } else {
                            archiver.addDirectory(directory, s[1] + "/");
                        }
                    }
                    line = in.readLine();
                }
                in.close();
                in = null;
            }
        }
        catch (IOException e) {
            throw new ArchiverException("Error processing dot files.", e);
        }
        finally {
            IOUtil.close(in);
        }
    }

    @Override
    public List getVirtualFiles() {
        return Collections.EMPTY_LIST;
    }
}

