/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.util;

import com.salesforce.dataloader.config.Messages;
import java.util.Date;

public class LoadRateCalculator {
    private Date startTime = null;
    private int totalRecords;

    public void start() {
        this.startTime = new Date();
    }

    public void setNumRecords(int numRecords) {
        this.totalRecords = numRecords;
    }

    public String calculateSubTask(int numProcessed, int numErrors) {
        Date currentLoadTime = new Date();
        int numSuccess = numProcessed - numErrors;
        long currentPerMin = numSuccess * 60 * 60;
        long totalElapsed = currentLoadTime.getTime() - this.startTime.getTime();
        long rate = totalElapsed == 0L ? 0L : currentPerMin / totalElapsed * 1000L;
        long remainingSeconds = 0L;
        if (this.totalRecords > 0) {
            remainingSeconds = (long)(((double)this.totalRecords / (double)numSuccess - 1.0) * (double)totalElapsed) / 1000L;
        }
        long mins = remainingSeconds / 60L;
        long seconds = remainingSeconds - mins * 60L;
        return Messages.getMessage(this.getClass(), "processed", numProcessed, this.totalRecords, rate, mins, seconds, numSuccess, numErrors);
    }
}

