/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.util;

import com.salesforce.dataloader.action.progress.ILoaderProgress;
import com.salesforce.dataloader.action.visitor.DAOSizeVisitor;
import com.salesforce.dataloader.config.Config;
import com.salesforce.dataloader.config.Messages;
import com.salesforce.dataloader.dao.DataAccessObject;
import com.salesforce.dataloader.dao.DataReader;
import com.salesforce.dataloader.exception.DataAccessObjectException;
import com.salesforce.dataloader.exception.LoadException;
import com.salesforce.dataloader.exception.ParameterLoadException;
import com.salesforce.dataloader.model.Row;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class DAORowUtil {
    private static final DAORowUtil INSTANCE = new DAORowUtil();
    static Logger logger = Logger.getLogger(DAORowUtil.class);

    private DAORowUtil() {
    }

    public static DAORowUtil get() {
        return INSTANCE;
    }

    public static int calculateTotalRows(DataReader dataReader) throws DataAccessObjectException {
        try {
            DAOSizeVisitor visitor = new DAOSizeVisitor();
            Row row = dataReader.readRow();
            while (DAORowUtil.isValidRow(row)) {
                visitor.visit(row);
                row = dataReader.readRow();
            }
            int n = visitor.getNumberOfRows();
            return n;
        }
        catch (DataAccessObjectException daoe) {
            logger.error(Messages.getString("RowUtil.error", new Object[0]), daoe);
            throw daoe;
        }
        finally {
            dataReader.close();
            dataReader.open();
        }
    }

    public static boolean isValidRow(Row row) {
        return row != null;
    }

    public static boolean isValidRow(List<?> row) {
        if (row == null) {
            return false;
        }
        return row.size() != 1 || !"".equals(row.get(0));
    }

    public static String validateColumns(DataAccessObject dao) {
        HashSet<String> uniqueHeaders = new HashSet<String>();
        String warning = null;
        for (String header : dao.getColumnNames()) {
            if (header == null || header.length() == 0) {
                warning = Messages.getString("RowUtil.warningEmptyColumn", new Object[0]);
                break;
            }
            if (uniqueHeaders.contains(header)) {
                warning = Messages.getFormattedString("RowUtil.warningDuplicateColumn", header);
                break;
            }
            uniqueHeaders.add(header);
        }
        if (warning != null) {
            logger.warn(warning);
        }
        return warning;
    }

    public void skipRowToStartOffset(Config cfg, DataReader rdr, ILoaderProgress mon, boolean updateProgress) throws LoadException {
        try {
            cfg.setValue("process.lastLoadBatchRow", 0);
            this.rowToStart(cfg, rdr);
            if (updateProgress) {
                int currentRow = rdr.getCurrentRowNumber();
                if (mon != null && currentRow > 0) {
                    mon.worked(currentRow);
                }
                cfg.setValue("process.lastLoadBatchRow", currentRow);
                cfg.saveLastRun();
            }
        }
        catch (DataAccessObjectException e) {
            this.handleError(e, "errorDaoStartRow");
        }
        catch (IOException e) {
            this.handleError(e, "errorLastRun");
        }
    }

    private void handleError(Exception e, String msgKey) throws LoadException {
        String errMsg = Messages.getMessage(this.getClass(), msgKey, new Object[0]);
        logger.error(errMsg, e);
        throw new LoadException(errMsg, e);
    }

    private void rowToStart(Config cfg, DataReader daoReader) throws DataAccessObjectException {
        block3: {
            int rowToStart;
            try {
                rowToStart = cfg.getInt("process.loadRowToStartAt");
            }
            catch (ParameterLoadException e) {
                return;
            }
            if (rowToStart <= 0) break block3;
            while (daoReader.getCurrentRowNumber() < rowToStart && DAORowUtil.isValidRow(daoReader.readRow())) {
            }
        }
    }
}

