/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.ui.mapping;

import com.salesforce.dataloader.ui.MappingDialog;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.TextTransfer;

public class SforceDragListener
extends DragSourceAdapter {
    private final StructuredViewer viewer;
    private final MappingDialog dlg;

    public SforceDragListener(StructuredViewer viewer, MappingDialog dialog) {
        this.viewer = viewer;
        this.dlg = dialog;
    }

    @Override
    public void dragFinished(DragSourceEvent event) {
        if (!event.doit) {
            return;
        }
        try {
            if (event.detail == 2) {
                IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
                Iterator it = selection.iterator();
                while (it.hasNext()) {
                    Map.Entry eventElem = (Map.Entry)it.next();
                    eventElem.setValue("");
                    this.dlg.getMapper().removeMapping((String)eventElem.getKey());
                }
                this.viewer.refresh();
                this.dlg.packMappingColumns();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void dragSetData(DragSourceEvent event) {
        try {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            Map.Entry elem = (Map.Entry)selection.getFirstElement();
            if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                event.data = elem.getValue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void dragStart(DragSourceEvent event) {
        event.doit = !this.viewer.getSelection().isEmpty();
    }
}

