/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.ui.mapping;

import com.salesforce.dataloader.ui.MappingDialog;
import com.sforce.soap.partner.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.TextTransfer;

public class MappingDragListener
extends DragSourceAdapter {
    private StructuredViewer viewer;
    private MappingDialog dlg;

    public MappingDragListener(StructuredViewer viewer, MappingDialog dialog) {
        this.viewer = viewer;
        this.dlg = dialog;
    }

    @Override
    public void dragFinished(DragSourceEvent event) {
        if (!event.doit) {
            return;
        }
        try {
            if (event.detail == 2) {
                IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
                Field[] fields = (Field[])this.viewer.getInput();
                ArrayList<Field> fieldList = new ArrayList<Field>(Arrays.asList(fields));
                Iterator it = selection.iterator();
                while (it.hasNext()) {
                    Field eventField = (Field)it.next();
                    fieldList.remove(eventField);
                }
                Field[] newFields = fieldList.toArray(new Field[fieldList.size()]);
                this.dlg.setFields(newFields);
                this.viewer.setInput(newFields);
                this.viewer.refresh();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void dragSetData(DragSourceEvent event) {
        try {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            Field field = (Field)selection.getFirstElement();
            if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                event.data = field.getName();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void dragStart(DragSourceEvent event) {
        event.doit = !this.viewer.getSelection().isEmpty();
    }
}

