/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.ui.extraction;

import com.salesforce.dataloader.action.OperationInfo;
import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.ui.BaseWizard;
import com.salesforce.dataloader.ui.Labels;
import com.salesforce.dataloader.ui.SWTLoadRunable;
import com.salesforce.dataloader.ui.SettingsPage;
import com.salesforce.dataloader.ui.UIUtils;
import com.salesforce.dataloader.ui.extraction.ExtractionDataSelectionPage;
import com.salesforce.dataloader.ui.extraction.ExtractionFinishPage;
import com.salesforce.dataloader.ui.extraction.ExtractionPage;
import com.salesforce.dataloader.ui.extraction.ExtractionSOQLPage;
import com.salesforce.dataloader.ui.extraction.ExtractionSettingsPage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;

public class ExtractionWizard
extends BaseWizard {
    private static final Logger logger = Logger.getLogger(ExtractionWizard.class);

    public ExtractionWizard(Controller controller) {
        this(controller, OperationInfo.extract);
    }

    protected ExtractionWizard(Controller controller, OperationInfo opInfo) {
        super(controller, opInfo);
    }

    @Override
    protected ExtractionPage setPages() {
        Controller controller = this.getController();
        this.addPage(new ExtractionDataSelectionPage(controller));
        ExtractionSOQLPage soqlPage = new ExtractionSOQLPage(controller);
        this.addPage(soqlPage);
        ExtractionPage finishPage = soqlPage;
        if (this.getConfig().getBoolean("process.enableExtractStatusOutput")) {
            finishPage = new ExtractionFinishPage(controller);
            this.addPage(finishPage);
        }
        return finishPage;
    }

    @Override
    protected ExtractionPage getFinishPage() {
        return (ExtractionPage)super.getFinishPage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateExtractionPath(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    UIUtils.errorMessageBox(this.getShell(), Labels.getString("LoadWizard.errorFileCreate") + filePath);
                    return false;
                }
            }
            catch (IOException iox) {
                UIUtils.errorMessageBox(this.getShell(), Labels.getString("LoadWizard.errorFileCreate") + filePath);
                return false;
            }
            return true;
        }
        if (!file.canWrite()) {
            UIUtils.errorMessageBox(this.getShell(), Labels.getString("LoadWizard.errorFileWrite") + filePath);
            return false;
        }
        FileWriter fileOut = null;
        try {
            fileOut = new FileWriter(filePath);
        }
        catch (IOException e) {
            UIUtils.errorMessageBox(this.getShell(), Labels.getString("LoadWizard.errorFileWrite") + filePath);
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileOut != null) {
                try {
                    fileOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    @Override
    public boolean performFinish() {
        if (!this.validateExtractionPath(this.getConfig().getString("dataAccess.name"))) {
            return false;
        }
        if (!this.getFinishPage().finishPage()) {
            return false;
        }
        try {
            int val = UIUtils.warningConfMessageBox(this.getShell(), this.getLabel("confFirstLine") + System.getProperty("line.separator") + this.getLabel("confSecondLine"));
            if (val != 64) {
                return false;
            }
            ProgressMonitorDialog dlg = new ProgressMonitorDialog(this.getShell());
            dlg.run(true, true, new SWTLoadRunable(this.getController()));
        }
        catch (InvocationTargetException e) {
            logger.error(Labels.getString("LoadWizard.errorAction"), e);
            UIUtils.errorMessageBox(this.getContainer().getShell(), e.getCause() != null ? e.getCause() : e);
            return false;
        }
        catch (InterruptedException e) {
            logger.error(Labels.getString("LoadWizard.errorAction"), e);
            UIUtils.errorMessageBox(this.getShell(), e.getCause() != null ? e.getCause() : e);
            return false;
        }
        return true;
    }

    @Override
    protected SettingsPage createSettingsPage() {
        return new ExtractionSettingsPage(this.getController());
    }
}

