/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.ui.extraction;

import com.salesforce.dataloader.config.Config;
import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.ui.Labels;
import com.salesforce.dataloader.ui.UIUtils;
import com.salesforce.dataloader.ui.extraction.ExtrFieldContentProvider;
import com.salesforce.dataloader.ui.extraction.ExtrFieldLabelProvider;
import com.salesforce.dataloader.ui.extraction.ExtrPopupList;
import com.salesforce.dataloader.ui.extraction.ExtractionFinishPage;
import com.salesforce.dataloader.ui.extraction.ExtractionPage;
import com.sforce.soap.partner.DescribeSObjectResult;
import com.sforce.soap.partner.Field;
import com.sforce.soap.partner.FieldType;
import com.sforce.soap.partner.PicklistEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExtractionSOQLPage
extends ExtractionPage {
    private final Controller controller;
    private final Logger logger = Logger.getLogger(ExtractionSOQLPage.class);
    private Text soqlText;
    private Field[] fields;
    private CheckboxTableViewer fieldViewer;
    private final String[] operationsDisplayNormal = new String[]{"equals", "not equals", "less than", "greater than", "less than or equals", "greater than or equals"};
    private final String[] operationsDisplayString = new String[]{"equals", "not equals", "like", "starts with", "ends with", "contains", "less than", "greater than", "less than or equals", "greater than or equals"};
    private final String[] operationsDisplayMulti = new String[]{"equals", "not equals", "includes", "excludes"};
    private HashMap<String, String> operationMap;
    private Combo fieldCombo;
    private Composite whereComp;
    private Composite builderComp;
    private boolean isPickListField;
    private boolean isFocusDialogWanted = true;
    private int lastFieldType;
    private Text valueText;
    private PicklistEntry[] picklistValues;
    private static final String SPACE = " ";
    private static final String BEGIN_SINGLEQUOTE = " '";
    private static final String END_SINGLEQUOTE = "' ";
    private static final String WILD_CARD = "%";
    private static final String OPEN_BRACKET = "(";
    private static final String CLOSE_BRACKET = ")";
    private static final int FIELD_STRING = 0;
    private static final int FIELD_MULTI = 1;
    private static final int FIELD_NORMAL = 2;
    private StringBuffer fromPart;
    private final String SELECT = "Select ";
    private StringBuffer fieldPart = new StringBuffer();
    private StringBuffer wherePart = new StringBuffer();
    private Combo operCombo;

    public ExtractionSOQLPage(Controller controller) {
        super(Labels.getString("ExtractionSOQLPage.title"), Labels.getString("ExtractionSOQLPage.titleMessage"), UIUtils.getImageRegistry().getDescriptor("splashscreens"));
        this.controller = controller;
        this.setDescription(Labels.getString("ExtractionSOQLPage.description"));
        this.initOperMap();
        this.setPageComplete(false);
        this.lastFieldType = 2;
        this.isPickListField = false;
    }

    private void initOperMap() {
        this.operationMap = new HashMap();
        this.operationMap.put("equals", "=");
        this.operationMap.put("not equals", "!=");
        this.operationMap.put("like", "like");
        this.operationMap.put("less than", "<");
        this.operationMap.put("greater than", ">");
        this.operationMap.put("less than or equals", "<=");
        this.operationMap.put("greater than or equals", ">=");
        this.operationMap.put("includes", "includes");
        this.operationMap.put("excludes", "excludes");
        this.operationMap.put("starts with", "like");
        this.operationMap.put("ends with", "like");
        this.operationMap.put("contains", "like");
    }

    private void setLastFieldType(int type) {
        this.lastFieldType = type;
    }

    @Override
    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 10;
        gridLayout.marginHeight = 20;
        comp.setLayout(gridLayout);
        this.builderComp = new Composite(comp, 0);
        GridData data = new GridData(1808);
        data.heightHint = 170;
        data.widthHint = 650;
        this.builderComp.setLayoutData(data);
        gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 25;
        this.builderComp.setLayout(gridLayout);
        Label fieldLable = new Label(this.builderComp, 16384);
        fieldLable.setText(Labels.getString("ExtractionSOQLPage.chooseFields"));
        Label fieldWhere = new Label(this.builderComp, 16384);
        fieldWhere.setText(Labels.getString("ExtractionSOQLPage.createClauses"));
        this.fieldViewer = CheckboxTableViewer.newCheckList(this.builderComp, 2048);
        this.fieldViewer.setLabelProvider(new ExtrFieldLabelProvider());
        this.fieldViewer.setContentProvider(new ExtrFieldContentProvider());
        data = new GridData(1040);
        data.widthHint = 135;
        this.fieldViewer.getTable().setLayoutData(data);
        this.fieldViewer.addCheckStateListener(new ICheckStateListener(){

            @Override
            public void checkStateChanged(CheckStateChangedEvent event) {
                ExtractionSOQLPage.this.generateFieldPart();
                ExtractionSOQLPage.this.generateSOQLText();
            }
        });
        this.whereComp = new Composite(this.builderComp, 0);
        data = new GridData(1808);
        this.whereComp.setLayoutData(data);
        gridLayout = new GridLayout(3, false);
        this.whereComp.setLayout(gridLayout);
        Label fLabel = new Label(this.whereComp, 16384);
        fLabel.setText(Labels.getString("ExtractionSOQLPage.fields"));
        Label opLabel = new Label(this.whereComp, 0x1000000);
        opLabel.setText(Labels.getString("ExtractionSOQLPage.operation"));
        Label valLabel = new Label(this.whereComp, 0x1000000);
        valLabel.setText(Labels.getString("ExtractionSOQLPage.value"));
        this.fieldCombo = new Combo(this.whereComp, 4);
        this.operCombo = new Combo(this.whereComp, 4);
        this.operCombo.setItems(this.operationsDisplayNormal);
        this.fieldCombo.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent event) {
            }

            @Override
            public void widgetSelected(SelectionEvent event) {
                String name = ExtractionSOQLPage.this.fieldCombo.getText();
                if (name != null && name.length() > 0) {
                    for (int i = 0; i < ExtractionSOQLPage.this.fields.length; ++i) {
                        Field field = ExtractionSOQLPage.this.fields[i];
                        if (!name.equals(field.getName())) continue;
                        if (field.getType() == FieldType.picklist || field.getType() == FieldType.multipicklist) {
                            ExtractionSOQLPage.this.picklistValues = field.getPicklistValues();
                            ExtractionSOQLPage.this.isPickListField = true;
                        } else {
                            ExtractionSOQLPage.this.isPickListField = false;
                        }
                        if (field.getType() == FieldType.string && ExtractionSOQLPage.this.lastFieldType != 0) {
                            ExtractionSOQLPage.this.operCombo.setItems(ExtractionSOQLPage.this.operationsDisplayString);
                            ExtractionSOQLPage.this.setLastFieldType(0);
                            break;
                        }
                        if (field.getType() == FieldType.multipicklist && ExtractionSOQLPage.this.lastFieldType != 1) {
                            ExtractionSOQLPage.this.operCombo.setItems(ExtractionSOQLPage.this.operationsDisplayMulti);
                            ExtractionSOQLPage.this.setLastFieldType(1);
                            break;
                        }
                        if (ExtractionSOQLPage.this.lastFieldType == 2 || field.getType() == FieldType.multipicklist || field.getType().toString().equals("string")) break;
                        ExtractionSOQLPage.this.operCombo.setItems(ExtractionSOQLPage.this.operationsDisplayNormal);
                        ExtractionSOQLPage.this.setLastFieldType(2);
                        break;
                    }
                }
            }
        });
        this.valueText = new Text(this.whereComp, 2048);
        data = new GridData();
        data.widthHint = 85;
        this.valueText.setLayoutData(data);
        this.valueText.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (ExtractionSOQLPage.this.isPickListField && ExtractionSOQLPage.this.isFocusDialogWanted) {
                    ExtrPopupList popUp = new ExtrPopupList(ExtractionSOQLPage.this.valueText.getShell());
                    String[] values = new String[ExtractionSOQLPage.this.picklistValues.length];
                    int end = ExtractionSOQLPage.this.picklistValues.length;
                    for (int x = 0; x < end; ++x) {
                        values[x] = ExtractionSOQLPage.this.picklistValues[x].getValue();
                    }
                    popUp.setItems(values);
                    Rectangle rect = ExtractionSOQLPage.this.valueText.getBounds();
                    for (Composite sizer = ExtractionSOQLPage.this.valueText.getParent(); sizer != null; sizer = sizer.getParent()) {
                        Rectangle sizerRect = sizer.getBounds();
                        rect.x += sizerRect.x;
                        rect.y += sizerRect.y;
                        if (sizer instanceof Shell) break;
                    }
                    ExtractionSOQLPage.this.isFocusDialogWanted = false;
                    String selection = popUp.open(rect);
                    if (selection != null) {
                        ExtractionSOQLPage.this.valueText.setText(selection);
                    } else {
                        ExtractionSOQLPage.this.isFocusDialogWanted = true;
                    }
                } else {
                    ExtractionSOQLPage.this.isFocusDialogWanted = true;
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        Button addWhere = new Button(this.whereComp, 0x800008);
        addWhere.setText(Labels.getString("ExtractionSOQLPage.addCondition"));
        addWhere.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                String whereField = ExtractionSOQLPage.this.fieldCombo.getText();
                String whereOper = ExtractionSOQLPage.this.operCombo.getText();
                String whereValue = ExtractionSOQLPage.this.valueText.getText();
                if (ExtractionSOQLPage.this.validateStr(whereField) && ExtractionSOQLPage.this.validateStr(whereOper)) {
                    if (ExtractionSOQLPage.this.wherePart.length() == 0) {
                        ExtractionSOQLPage.this.wherePart.append("WHERE ");
                    } else {
                        ExtractionSOQLPage.this.wherePart.append("AND ");
                    }
                    boolean isSingleQuoteValue = ExtractionSOQLPage.this.isSingleQuoteValue(whereField);
                    ExtractionSOQLPage.this.wherePart.append(whereField);
                    ExtractionSOQLPage.this.wherePart.append(ExtractionSOQLPage.SPACE);
                    ExtractionSOQLPage.this.wherePart.append(ExtractionSOQLPage.this.getOperValue(whereOper));
                    boolean isMultiPickList = ExtractionSOQLPage.this.isMultiPicklistOper(whereOper);
                    if (isMultiPickList) {
                        ExtractionSOQLPage.this.wherePart.append(ExtractionSOQLPage.SPACE);
                        ExtractionSOQLPage.this.wherePart.append(ExtractionSOQLPage.OPEN_BRACKET);
                    }
                    if (isSingleQuoteValue) {
                        ExtractionSOQLPage.this.wherePart.append(ExtractionSOQLPage.BEGIN_SINGLEQUOTE);
                    } else {
                        ExtractionSOQLPage.this.wherePart.append(ExtractionSOQLPage.SPACE);
                    }
                    if (whereOper.equals("ends with") || whereOper.equals("contains")) {
                        ExtractionSOQLPage.this.wherePart.append(ExtractionSOQLPage.WILD_CARD);
                    }
                    ExtractionSOQLPage.this.wherePart.append(whereValue);
                    if (whereOper.equals("starts with") || whereOper.equals("contains")) {
                        ExtractionSOQLPage.this.wherePart.append(ExtractionSOQLPage.WILD_CARD);
                    }
                    if (isSingleQuoteValue) {
                        ExtractionSOQLPage.this.wherePart.append(ExtractionSOQLPage.END_SINGLEQUOTE);
                    } else {
                        ExtractionSOQLPage.this.wherePart.append(ExtractionSOQLPage.SPACE);
                    }
                    if (isMultiPickList) {
                        ExtractionSOQLPage.this.wherePart.append(ExtractionSOQLPage.CLOSE_BRACKET);
                    }
                }
                ExtractionSOQLPage.this.generateSOQLText();
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button clearWhere = new Button(this.whereComp, 0x800008);
        clearWhere.setText(Labels.getString("ExtractionSOQLPage.clearAllConditions"));
        data = new GridData();
        data.horizontalSpan = 2;
        clearWhere.setLayoutData(data);
        clearWhere.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ExtractionSOQLPage.this.wherePart = new StringBuffer();
                ExtractionSOQLPage.this.generateSOQLText();
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite fieldButtonComp = new Composite(this.builderComp, 0);
        gridLayout = new GridLayout(2, false);
        fieldButtonComp.setLayout(gridLayout);
        Button selectAll = new Button(fieldButtonComp, 0x800008);
        selectAll.setText(Labels.getString("ExtractionSOQLPage.selectAllFields"));
        selectAll.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ExtractionSOQLPage.this.fieldViewer.setAllChecked(true);
                ExtractionSOQLPage.this.generateFieldPart();
                ExtractionSOQLPage.this.generateSOQLText();
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button clearAll = new Button(fieldButtonComp, 0x800008);
        clearAll.setText(Labels.getString("ExtractionSOQLPage.clearAllFields"));
        clearAll.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ExtractionSOQLPage.this.fieldViewer.setAllChecked(false);
                ExtractionSOQLPage.this.generateFieldPart();
                ExtractionSOQLPage.this.generateSOQLText();
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new Label(this.builderComp, 0);
        Label labelSeparatorBottom = new Label(comp, 258);
        data = new GridData(768);
        labelSeparatorBottom.setLayoutData(data);
        Label messageLabel = new Label(comp, 0);
        messageLabel.setText(Labels.getString("ExtractionSOQLPage.queryBelowMsg"));
        this.soqlText = new Text(comp, 2626);
        data = new GridData(1808);
        data.heightHint = 80;
        data.widthHint = 250;
        this.soqlText.setLayoutData(data);
        this.setControl(comp);
    }

    private String getOperValue(String operation) {
        return this.operationMap.get(operation);
    }

    private boolean isSingleQuoteValue(String fieldName) {
        for (int i = 0; i < this.fields.length; ++i) {
            Field field = this.fields[i];
            if (!field.getName().equals(fieldName)) continue;
            switch (field.getType()) {
                case _boolean: 
                case _double: 
                case _int: 
                case currency: 
                case date: 
                case datetime: 
                case percent: {
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    private boolean isMultiPicklistOper(String value) {
        return value.equals("includes") || value.equals("excludes");
    }

    private void generateFieldPart() {
        Object[] fields = this.fieldViewer.getCheckedElements();
        this.fieldPart = new StringBuffer();
        for (int i = 0; i < fields.length; ++i) {
            Field field = (Field)fields[i];
            this.fieldPart.append(field.getName());
            if (i + 1 >= fields.length) continue;
            this.fieldPart.append(", ");
        }
        this.fieldPart.append(SPACE);
    }

    private boolean validateStr(String str) {
        return str != null && str.length() > 0;
    }

    public void initializeSOQLText() {
        this.logger.debug(Labels.getString("ExtractionSOQLPage.initializeMsg"));
        Config config = this.controller.getConfig();
        DescribeSObjectResult result = this.controller.getFieldTypes();
        this.fields = result.getFields();
        this.fieldViewer.setInput(this.fields);
        this.fieldCombo.removeAll();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (int i = 0; i < this.fields.length; ++i) {
            if (FieldType.encryptedstring == this.fields[i].getType()) continue;
            fieldNames.add(this.fields[i].getName());
        }
        Object[] fieldNamesArray = fieldNames.toArray(new String[fieldNames.size()]);
        Arrays.sort(fieldNamesArray);
        this.fieldCombo.setItems((String[])fieldNamesArray);
        this.builderComp.layout();
        this.whereComp.layout();
        this.fromPart = new StringBuffer("FROM ").append(config.getString("sfdc.entity")).append(SPACE);
    }

    private void generateSOQLText() {
        StringBuffer soql = new StringBuffer("Select ");
        soql.append(this.fieldPart);
        soql.append(this.fromPart);
        soql.append(this.wherePart);
        this.soqlText.setText(soql.toString());
    }

    public String getSOQL() {
        return this.soqlText.getText();
    }

    @Override
    public IWizardPage getNextPage() {
        this.finishPage();
        ExtractionFinishPage finishPage = (ExtractionFinishPage)this.getWizard().getPage(Labels.getString("FinishPage.title"));
        if (finishPage != null) {
            this.getWizard().getPage(Labels.getString("FinishPage.title"));
            finishPage.setPageComplete(true);
            return finishPage;
        }
        return super.getNextPage();
    }

    @Override
    public boolean finishPage() {
        this.controller.getConfig().setValue("sfdc.extractionSOQL", this.getSOQL());
        return this.controller.saveConfig();
    }
}

