/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.ui.extraction;

import com.salesforce.dataloader.config.Config;
import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.ui.Labels;
import com.salesforce.dataloader.ui.UIUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExtractionInputDialog
extends Dialog {
    private String message;
    private String input;
    private Controller controller;
    private Text textBatch;
    private Text textEndpoint;
    private Text textTimeout;
    private Button buttonCompression;
    private Text textProxyHost;
    private Text textProxyPort;
    private Text textProxyUsername;
    private Text textProxyPassword;

    public ExtractionInputDialog(Shell parent, Controller controller) {
        this(parent, 67696);
        this.controller = controller;
    }

    public ExtractionInputDialog(Shell parent, int style) {
        super(parent, style);
        this.setText(Labels.getString("ExtractionInputDialog.title"));
        this.setMessage(Labels.getString("ExtractionInputDialog.message"));
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public String open() {
        Shell shell = new Shell(this.getParent(), this.getStyle());
        shell.setText(this.getText());
        shell.setImage(UIUtils.getImageRegistry().get("sfdc_icon"));
        this.createContents(shell);
        shell.pack();
        shell.open();
        Display display = this.getParent().getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.input;
    }

    private void createContents(Shell shell) {
        Config config = this.controller.getConfig();
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 10;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        shell.setLayout(layout);
        GridData data = new GridData(768);
        data.heightHint = 50;
        data.widthHint = 400;
        Composite topComp = new Composite(shell, 0);
        layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        topComp.setLayout(layout);
        topComp.setLayoutData(data);
        Label blank = new Label(topComp, 0);
        data = new GridData(768);
        data.heightHint = 10;
        blank.setLayoutData(data);
        blank.setBackground(Display.getCurrent().getSystemColor(1));
        Label label = new Label(topComp, 0);
        label.setText(this.message);
        data = new GridData(768);
        data.heightHint = 30;
        data.widthHint = 370;
        Font f = label.getFont();
        FontData[] farr = f.getFontData();
        FontData fd = farr[0];
        fd.setStyle(1);
        label.setFont(new Font((Device)Display.getCurrent(), fd));
        label.setLayoutData(data);
        label.setBackground(Display.getCurrent().getSystemColor(1));
        Label labelSeparator = new Label(topComp, 258);
        data = new GridData(768);
        labelSeparator.setLayoutData(data);
        Composite restComp = new Composite(shell, 0);
        data = new GridData(1808);
        restComp.setLayoutData(data);
        layout = new GridLayout(2, false);
        layout.verticalSpacing = 10;
        restComp.setLayout(layout);
        Label labelBatch = new Label(restComp, 131072);
        labelBatch.setText(Labels.getString("ExtractionInputDialog.querySize"));
        data = new GridData(128);
        labelBatch.setLayoutData(data);
        this.textBatch = new Text(restComp, 2048);
        this.textBatch.setText(config.getString("sfdc.extractionRequestSize"));
        this.textBatch.setTextLimit(4);
        this.textBatch.addVerifyListener(new VerifyListener(){

            @Override
            public void verifyText(VerifyEvent event) {
                event.doit = Character.isISOControl(event.character) || Character.isDigit(event.character);
            }
        });
        Label labelEndpoint = new Label(restComp, 131072);
        labelEndpoint.setText(Labels.getString("ExtractionInputDialog.serverURL"));
        this.textEndpoint = new Text(restComp, 2048);
        data = new GridData();
        data.widthHint = 250;
        this.textEndpoint.setLayoutData(data);
        String endpoint = config.getString("sfdc.endpoint");
        if ("".equals(endpoint)) {
            endpoint = "http://rpolk-ltm3.internal.salesforce.com:6109/services/Soap/u/45.0";
        }
        this.textEndpoint.setText(endpoint);
        Label labelCompression = new Label(restComp, 131072);
        labelCompression.setText(Labels.getString("ExtractionInputDialog.compression"));
        data = new GridData(128);
        labelCompression.setLayoutData(data);
        this.buttonCompression = new Button(restComp, 32);
        this.buttonCompression.setSelection(config.getBoolean("sfdc.noCompression"));
        Label labelTimeout = new Label(restComp, 131072);
        labelTimeout.setText(Labels.getString("ExtractionInputDialog.timeout"));
        data = new GridData(128);
        labelTimeout.setLayoutData(data);
        this.textTimeout = new Text(restComp, 2048);
        this.textTimeout.setTextLimit(4);
        this.textTimeout.setText(config.getString("sfdc.timeoutSecs"));
        this.textTimeout.addVerifyListener(new VerifyListener(){

            @Override
            public void verifyText(VerifyEvent event) {
                event.doit = Character.isISOControl(event.character) || Character.isDigit(event.character);
            }
        });
        Label labelProxyHost = new Label(restComp, 131072);
        labelProxyHost.setText(Labels.getString("ExtractionInputDialog.proxyHost"));
        data = new GridData(128);
        labelProxyHost.setLayoutData(data);
        this.textProxyHost = new Text(restComp, 2048);
        this.textProxyHost.setText(config.getString("sfdc.proxyHost"));
        data = new GridData();
        data.widthHint = 250;
        this.textProxyHost.setLayoutData(data);
        Label labelProxyPort = new Label(restComp, 131072);
        labelProxyPort.setText(Labels.getString("ExtractionInputDialog.proxyPort"));
        data = new GridData(128);
        labelProxyPort.setLayoutData(data);
        this.textProxyPort = new Text(restComp, 2048);
        this.textProxyPort.setText(config.getString("sfdc.proxyPort"));
        this.textProxyPort.setTextLimit(4);
        this.textProxyPort.addVerifyListener(new VerifyListener(){

            @Override
            public void verifyText(VerifyEvent event) {
                event.doit = Character.isISOControl(event.character) || Character.isDigit(event.character);
            }
        });
        data = new GridData();
        data.widthHint = 25;
        this.textProxyPort.setLayoutData(data);
        Label labelProxyUsername = new Label(restComp, 131072);
        labelProxyUsername.setText(Labels.getString("ExtractionInputDialog.proxyUsername"));
        data = new GridData(128);
        labelProxyUsername.setLayoutData(data);
        this.textProxyUsername = new Text(restComp, 2048);
        this.textProxyUsername.setText(config.getString("sfdc.proxyUsername"));
        data = new GridData();
        data.widthHint = 120;
        this.textProxyUsername.setLayoutData(data);
        Label labelProxyPassword = new Label(restComp, 131072);
        labelProxyPassword.setText(Labels.getString("ExtractionInputDialog.proxyPassword"));
        data = new GridData(128);
        labelProxyPassword.setLayoutData(data);
        this.textProxyPassword = new Text(restComp, 0x400800);
        this.textProxyPassword.setText(config.getString("sfdc.proxyPassword"));
        data = new GridData();
        data.widthHint = 120;
        this.textProxyPassword.setLayoutData(data);
        Label blankAgain = new Label(restComp, 0);
        data = new GridData();
        data.horizontalSpan = 2;
        blankAgain.setLayoutData(data);
        Label labelSeparatorBottom = new Label(restComp, 258);
        data = new GridData(768);
        data.horizontalSpan = 2;
        labelSeparatorBottom.setLayoutData(data);
        new Label(restComp, 0);
        Composite buttonComp = new Composite(restComp, 0);
        data = new GridData(128);
        buttonComp.setLayoutData(data);
        buttonComp.setLayout(new GridLayout(2, false));
        Button ok = new Button(buttonComp, 0x800008);
        ok.setText(Labels.getString("UI.ok"));
        ok.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                Config config = ExtractionInputDialog.this.controller.getConfig();
                config.setValue("sfdc.extractionRequestSize", ExtractionInputDialog.this.textBatch.getText());
                config.setValue("sfdc.endpoint", ExtractionInputDialog.this.textEndpoint.getText());
                config.setValue("sfdc.timeoutSecs", ExtractionInputDialog.this.textTimeout.getText());
                config.setValue("sfdc.noCompression", ExtractionInputDialog.this.buttonCompression.getSelection());
                config.setValue("sfdc.proxyHost", ExtractionInputDialog.this.textProxyHost.getText());
                config.setValue("sfdc.proxyPassword", ExtractionInputDialog.this.textProxyPassword.getText());
                config.setValue("sfdc.proxyPort", ExtractionInputDialog.this.textProxyPort.getText());
                config.setValue("sfdc.proxyUsername", ExtractionInputDialog.this.textProxyUsername.getText());
                ExtractionInputDialog.this.controller.saveConfig();
                ExtractionInputDialog.this.input = "OK";
                shell.close();
            }
        });
        data = new GridData();
        data.widthHint = 75;
        ok.setLayoutData(data);
        Button cancel = new Button(buttonComp, 0x800008);
        cancel.setText(Labels.getString("UI.cancel"));
        cancel.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                ExtractionInputDialog.this.input = null;
                shell.close();
            }
        });
        data = new GridData();
        data.widthHint = 75;
        cancel.setLayoutData(data);
        shell.setDefaultButton(ok);
    }
}

