/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.ui.extraction;

import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.exception.ProcessInitializationException;
import com.salesforce.dataloader.ui.Labels;
import com.salesforce.dataloader.ui.UIUtils;
import com.salesforce.dataloader.ui.extraction.ExtractionPage;
import java.io.File;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class ExtractionFinishPage
extends ExtractionPage {
    private final Controller controller;
    private DirectoryFieldEditor dirFE;

    public ExtractionFinishPage(Controller controller) {
        super(Labels.getString("FinishPage.title"), Labels.getString("FinishPage.finishMsg"), UIUtils.getImageRegistry().getDescriptor("splashscreens"));
        this.controller = controller;
        this.setPageComplete(false);
        this.setDescription(Labels.getString("FinishPage.selectDir"));
    }

    @Override
    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 10;
        gridLayout.marginHeight = 20;
        comp.setLayout(gridLayout);
        Label label = new Label(comp, 0x1000000);
        label.setText(Labels.getString("FinishPage.overwritten"));
        Composite dirComp = new Composite(comp, 0);
        GridData data = new GridData();
        data.widthHint = 400;
        dirComp.setLayoutData(data);
        this.dirFE = new DirectoryFieldEditor(Labels.getString("FinishPage.output"), Labels.getString("FinishPage.chooseDir"), dirComp);
        this.dirFE.setStringValue(this.controller.getConfig().getString("process.statusOutputDirectory"));
        this.setControl(comp);
    }

    public String getOutputDir() {
        return this.dirFE.getStringValue();
    }

    @Override
    public boolean canFlipToNextPage() {
        return false;
    }

    @Override
    public boolean finishPage() {
        String outputDirName = this.getOutputDir();
        File statusDir = new File(outputDirName);
        if (!statusDir.exists() || !statusDir.isDirectory()) {
            UIUtils.errorMessageBox(this.getShell(), Labels.getString("LoadWizard.errorValidDirectory"));
            return false;
        }
        try {
            this.controller.setStatusFiles(outputDirName, false, true);
            this.controller.saveConfig();
        }
        catch (ProcessInitializationException e) {
            UIUtils.errorMessageBox(this.getShell(), e);
            return false;
        }
        return true;
    }
}

