/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.ui.extraction;

import com.salesforce.dataloader.config.Config;
import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.exception.DataAccessObjectInitializationException;
import com.salesforce.dataloader.exception.MappingInitializationException;
import com.salesforce.dataloader.ui.Labels;
import com.salesforce.dataloader.ui.UIUtils;
import com.salesforce.dataloader.ui.entitySelection.EntityContentProvider;
import com.salesforce.dataloader.ui.entitySelection.EntityFilter;
import com.salesforce.dataloader.ui.entitySelection.EntityLabelProvider;
import com.salesforce.dataloader.ui.entitySelection.EntityViewerSorter;
import com.salesforce.dataloader.ui.extraction.ExtractionSOQLPage;
import com.sforce.soap.partner.DescribeGlobalSObjectResult;
import com.sforce.ws.ConnectionException;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;

public class ExtractionDataSelectionPage
extends WizardPage {
    private final Controller controller;
    private final EntityFilter filter = new EntityFilter();
    private ListViewer lv;
    private Text fileText;
    public Composite comp;
    private boolean success;

    public ExtractionDataSelectionPage(Controller controller) {
        super(Labels.getString("ExtractionDataSelectionPage.title"), Labels.getString("ExtractionDataSelectionPage.titleMsg"), UIUtils.getImageRegistry().getDescriptor("splashscreens"));
        this.controller = controller;
        this.setDescription(Labels.getString("ExtractionDataSelectionPage.description"));
        this.setPageComplete(false);
    }

    @Override
    public void createControl(Composite parent) {
        this.getShell().setImage(UIUtils.getImageRegistry().get("sfdc_icon"));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 10;
        gridLayout.marginHeight = 15;
        gridLayout.verticalSpacing = 5;
        gridLayout.marginRight = 5;
        this.comp = new Composite(parent, 0);
        this.comp.setLayout(gridLayout);
        Label label = new Label(this.comp, 131072);
        label.setText(Labels.getString("ExtractionDataSelectionPage.selectSforce"));
        GridData data = new GridData();
        label.setLayoutData(data);
        Button filterAll = new Button(this.comp, 32);
        filterAll.setText(Labels.getString("ExtractionDataSelectionPage.showAll"));
        data = new GridData();
        filterAll.setLayoutData(data);
        this.lv = new ListViewer(this.comp, 2816);
        this.lv.setContentProvider(new EntityContentProvider());
        this.lv.setLabelProvider(new EntityLabelProvider());
        this.lv.setInput(null);
        data = new GridData(4, 4, true, true);
        data.heightHint = 140;
        data.widthHint = 140;
        this.lv.getControl().setLayoutData(data);
        this.lv.addFilter(this.filter);
        this.lv.setSorter(new EntityViewerSorter());
        this.lv.addSelectionChangedListener(new ISelectionChangedListener(){

            @Override
            public void selectionChanged(SelectionChangedEvent event) {
                ExtractionDataSelectionPage.this.checkPageComplete();
            }
        });
        if (this.controller.isLoggedIn()) {
            this.setInput(this.controller.getEntityDescribes());
        }
        filterAll.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                if (((Button)event.widget).getSelection()) {
                    ExtractionDataSelectionPage.this.lv.removeFilter(ExtractionDataSelectionPage.this.filter);
                } else {
                    ExtractionDataSelectionPage.this.lv.addFilter(ExtractionDataSelectionPage.this.filter);
                }
            }
        });
        Label clearLabel = new Label(this.comp, 0);
        data = new GridData(8);
        data.heightHint = 20;
        clearLabel.setLayoutData(data);
        Composite compChooser = new Composite(this.comp, 0);
        data = new GridData(776);
        compChooser.setLayoutData(data);
        GridLayout gLayout = new GridLayout(3, false);
        compChooser.setLayout(gLayout);
        Label fileLabel = new Label(compChooser, 0);
        fileLabel.setText(Labels.getString("ExtractionDataSelectionPage.chooseTarget"));
        this.fileText = new Text(compChooser, 2048);
        this.fileText.setText(Labels.getString("ExtractionDataSelectionPage.defaultFileName"));
        data = new GridData(768);
        data.widthHint = 350;
        this.fileText.setLayoutData(data);
        this.fileText.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent e) {
                ExtractionDataSelectionPage.this.checkPageComplete();
            }
        });
        Button fileButton = new Button(compChooser, 0x800008);
        fileButton.setText(Labels.getString("ExtractionDataSelectionPage.chooseFile"));
        fileButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                FileDialog dlg = new FileDialog(ExtractionDataSelectionPage.this.getShell(), 8192);
                String initialFile = ExtractionDataSelectionPage.this.fileText.getText();
                if (initialFile.length() == 0) {
                    initialFile = Labels.getString("ExtractionDataSelectionPage.defaultFileName");
                }
                dlg.setFileName(initialFile);
                String filename = dlg.open();
                if (filename != null && !"".equals(filename)) {
                    ExtractionDataSelectionPage.this.fileText.setText(filename);
                    ExtractionDataSelectionPage.this.checkPageComplete();
                }
            }
        });
        this.setControl(this.comp);
    }

    public void setInput(Map<String, DescribeGlobalSObjectResult> entityDescribes) {
        HashMap<String, DescribeGlobalSObjectResult> inputDescribes = new HashMap<String, DescribeGlobalSObjectResult>();
        if (entityDescribes != null) {
            for (Map.Entry<String, DescribeGlobalSObjectResult> entry : entityDescribes.entrySet()) {
                if (!entry.getValue().isQueryable()) continue;
                inputDescribes.put(entry.getKey(), entry.getValue());
            }
        }
        this.lv.setInput(inputDescribes);
        this.lv.refresh();
        this.lv.getControl().getParent().pack();
    }

    private boolean checkEntityStatus() {
        IStructuredSelection selection = (IStructuredSelection)this.lv.getSelection();
        DescribeGlobalSObjectResult entity = (DescribeGlobalSObjectResult)selection.getFirstElement();
        return entity != null;
    }

    private void checkPageComplete() {
        if (!this.fileText.getText().equals("") && this.checkEntityStatus()) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    @Override
    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    @Override
    public IWizardPage getNextPage() {
        int button;
        if (new File(this.fileText.getText()).exists() && (button = UIUtils.warningConfMessageBox(this.getShell(), Labels.getString("UI.fileAlreadyExists"))) == 128) {
            return this;
        }
        Config config = this.controller.getConfig();
        IStructuredSelection selection = (IStructuredSelection)this.lv.getSelection();
        DescribeGlobalSObjectResult entity = (DescribeGlobalSObjectResult)selection.getFirstElement();
        config.setValue("sfdc.entity", entity.getName());
        config.setValue("dataAccess.name", this.fileText.getText());
        config.setValue("dataAccess.type", "csvWrite");
        this.controller.saveConfig();
        try {
            this.controller.createDao();
            config.setValue("process.mappingFile", "");
            this.controller.createMapper();
        }
        catch (DataAccessObjectInitializationException e) {
            MessageBox msgBox = new MessageBox(this.getShell(), 33);
            msgBox.setMessage(Labels.getString("ExtractionDataSelectionPage.extractOutputError"));
            msgBox.open();
            return this;
        }
        catch (MappingInitializationException e) {
            UIUtils.errorMessageBox(this.getShell(), e);
            return this;
        }
        BusyIndicator.showWhile(Display.getDefault(), new Thread(){

            @Override
            public void run() {
                try {
                    ExtractionDataSelectionPage.this.controller.setFieldTypes();
                    ExtractionDataSelectionPage.this.controller.setReferenceDescribes();
                    ExtractionDataSelectionPage.this.success = true;
                }
                catch (ConnectionException e) {
                    ExtractionDataSelectionPage.this.success = false;
                }
            }
        });
        if (this.success) {
            ExtractionSOQLPage soql = (ExtractionSOQLPage)this.getWizard().getPage("SOQL");
            soql.initializeSOQLText();
            soql.setPageComplete(true);
            return super.getNextPage();
        }
        MessageBox msgBox = new MessageBox(this.getShell(), 33);
        msgBox.setMessage(Labels.getString("ExtractionDataSelectionPage.initError"));
        msgBox.open();
        return this;
    }
}

