/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.ui.extraction;

import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.ui.Labels;
import com.salesforce.dataloader.ui.UIUtils;
import com.sforce.ws.ConnectionException;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class ExtractionDataSelectionDialog
extends Dialog {
    private String message;
    private boolean success;
    private Controller controller;
    private Button ok;
    private Label label;

    public ExtractionDataSelectionDialog(Shell parent, Controller controller) {
        this(parent, 67696);
        this.controller = controller;
    }

    public ExtractionDataSelectionDialog(Shell parent, int style) {
        super(parent, style);
        this.setText(Labels.getString("ExtractionDataSelectionDialog.title"));
        this.setMessage(Labels.getString("ExtractionDataSelectionDialog.verifyingEntity"));
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean open() {
        Shell shell = new Shell(this.getParent(), this.getStyle());
        shell.setText(this.getText());
        shell.setImage(UIUtils.getImageRegistry().get("sfdc_icon"));
        this.createContents(shell);
        shell.pack();
        shell.open();
        Display display = this.getParent().getDisplay();
        BusyIndicator.showWhile(display, new Thread(){

            @Override
            public void run() {
                try {
                    ExtractionDataSelectionDialog.this.controller.setFieldTypes();
                    ExtractionDataSelectionDialog.this.controller.setReferenceDescribes();
                    ExtractionDataSelectionDialog.this.success = true;
                    ExtractionDataSelectionDialog.this.ok.setEnabled(true);
                    ExtractionDataSelectionDialog.this.label.setText(Labels.getString("ExtractionDataSelectionDialog.success"));
                    ExtractionDataSelectionDialog.this.label.getParent().pack();
                }
                catch (ConnectionException ex) {
                    ExtractionDataSelectionDialog.this.success = false;
                    ExtractionDataSelectionDialog.this.ok.setEnabled(true);
                    ExtractionDataSelectionDialog.this.label.setText(Labels.getString("ExtractionDataSelectionDialog.errorValidating"));
                }
            }
        });
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.success;
    }

    private void createContents(Shell shell) {
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 10;
        shell.setLayout(layout);
        this.label = new Label(shell, 0);
        this.label.setText(this.message);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.widthHint = 250;
        this.label.setLayoutData(data);
        Label labelSeparatorBottom = new Label(shell, 258);
        data = new GridData(768);
        data.horizontalSpan = 2;
        labelSeparatorBottom.setLayoutData(data);
        new Label(shell, 0);
        this.ok = new Button(shell, 0x800008);
        this.ok.setText(Labels.getString("UI.ok"));
        this.ok.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                shell.close();
            }
        });
        data = new GridData(128);
        data.widthHint = 75;
        this.ok.setLayoutData(data);
        this.ok.setEnabled(false);
        shell.setDefaultButton(this.ok);
    }
}

