/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.ui;

import com.salesforce.dataloader.action.OperationInfo;
import com.salesforce.dataloader.ui.Labels;
import com.salesforce.dataloader.ui.LoaderWindow;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class UIUtils {
    private static ImageRegistry image_registry;

    public static boolean isValidHttpsUrl(String url) {
        try {
            URI uri = new URL(url).toURI();
            return "https".equalsIgnoreCase(uri.getScheme());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void validateHttpsUrlAndThrow(String url) {
        if (!UIUtils.isValidHttpsUrl(url)) {
            throw new RuntimeException("Dataloader only supports server URL that uses https protocol:" + url);
        }
    }

    public static synchronized ImageRegistry getImageRegistry() {
        if (image_registry == null) {
            image_registry = new ImageRegistry();
            Class<LoaderWindow> baseClass = LoaderWindow.class;
            image_registry.put("sfdc_icon", ImageDescriptor.createFromURL(baseClass.getClassLoader().getResource("img/icons/icon_32x32.png")));
            image_registry.put("logo", ImageDescriptor.createFromURL(baseClass.getClassLoader().getResource("img/icons/icon_128x128.png")));
            image_registry.put("title_logo", ImageDescriptor.createFromURL(baseClass.getClassLoader().getResource("img/dataloader-title-logo.png")));
            image_registry.put("splashscreens", ImageDescriptor.createFromURL(baseClass.getClassLoader().getResource("img/icons/icon_256x256.png")));
            for (OperationInfo info : OperationInfo.values()) {
                if (image_registry.get(info.getIconName()) != null) continue;
                image_registry.put(info.getIconName(), ImageDescriptor.createFromURL(baseClass.getClassLoader().getResource(info.getIconLocation())));
            }
            image_registry.put("downArrow", ImageDescriptor.createFromURL(baseClass.getClassLoader().getResource("img/downArrow.gif")));
        }
        return image_registry;
    }

    public static Color getDefaultTitleBackGround() {
        return Display.getDefault().getSystemColor(31);
    }

    public static int warningConfMessageBox(Shell shell, String message) {
        return UIUtils.messageBox(shell, Labels.getString("UI.warning"), 200, String.valueOf(message));
    }

    public static int errorMessageBox(Shell shell, Throwable e) {
        return UIUtils.errorMessageBox(shell, e.getMessage());
    }

    public static int errorMessageBox(Shell shell, String message) {
        return UIUtils.messageBox(shell, Labels.getString("UI.error"), 33, String.valueOf(message));
    }

    public static int infoMessageBox(Shell shell, String message) {
        return UIUtils.messageBox(shell, Labels.getString("UI.message"), 34, message);
    }

    private static int messageBox(Shell shell, String title, int uiProps, String message) {
        MessageBox mb = new MessageBox(shell, uiProps);
        if (title != null && title.length() > 0) {
            mb.setText(title);
        }
        mb.setMessage(String.valueOf(message));
        return mb.open();
    }

    public static String[] setComboItems(Combo combo, List<String> itemList, String defaultItemText) {
        Object[] itemArray = itemList.toArray(new String[itemList.size()]);
        Arrays.sort(itemArray);
        combo.setItems((String[])itemArray);
        if (defaultItemText != null && defaultItemText.length() > 0) {
            combo.setText(defaultItemText);
        }
        return itemArray;
    }
}

