/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.ui;

import com.salesforce.dataloader.config.Config;
import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.ui.AuthenticationRunner;
import com.salesforce.dataloader.ui.DataSelectionPage;
import com.salesforce.dataloader.ui.Grid12;
import com.salesforce.dataloader.ui.Labels;
import com.salesforce.dataloader.ui.LoginAdvancedControl;
import com.salesforce.dataloader.ui.LoginDefaultControl;
import com.salesforce.dataloader.ui.LoginStandardControl;
import com.salesforce.dataloader.ui.UIUtils;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;

public class SettingsPage
extends WizardPage {
    private final Controller controller;
    private AuthenticationRunner authenticator;
    private LoginDefaultControl defaultControl;
    private LoginStandardControl standardControl;
    private LoginAdvancedControl advancedControl;
    private Grid12 grid;
    private Composite control;

    public SettingsPage(Controller controller) {
        super(Labels.getString("SettingsPage.title"), Labels.getString("SettingsPage.titleMsg"), UIUtils.getImageRegistry().getDescriptor("splashscreens"));
        this.controller = controller;
        this.setPageComplete(false);
        this.setDescription(Labels.getString("SettingsPage.enterUsernamePassword"));
    }

    @Override
    public void createControl(Composite parent) {
        this.getShell().setImage(UIUtils.getImageRegistry().get("sfdc_icon"));
        Config config = this.controller.getConfig();
        this.control = new Composite(parent, 4);
        this.grid = new Grid12(this.control, 40);
        this.authenticator = new AuthenticationRunner(this.getShell(), config, this.controller, this::authenticationCompleted);
        Button[] layouts = new Button[3];
        this.grid.createPadding(2);
        layouts[0] = this.grid.createButton(2, 16, Labels.getString("SettingsPage.loginDefault"));
        layouts[1] = this.grid.createButton(4, 16, Labels.getString("SettingsPage.loginStandard"));
        layouts[2] = this.grid.createButton(2, 16, Labels.getString("SettingsPage.loginAdvanced"));
        this.grid.createPadding(2);
        this.defaultControl = new LoginDefaultControl(this.control, 4, this.authenticator);
        this.defaultControl.setLayoutData(this.grid.createCell(12));
        this.standardControl = new LoginStandardControl(this.control, 4, this.authenticator);
        this.standardControl.setLayoutData(this.grid.createCell(12));
        this.advancedControl = new LoginAdvancedControl(this.control, 4, this.authenticator);
        this.advancedControl.setLayoutData(this.grid.createCell(12));
        this.setControl(this.control);
        layouts[0].addListener(13, this::selectDefault);
        layouts[1].addListener(13, this::selectStandard);
        layouts[2].addListener(13, this::selectAdvanced);
        if (config.getStrings("sfdc.oauth.environments").size() > 0) {
            layouts[0].setSelection(true);
            this.selectDefault(null);
        } else {
            this.grid.hide(layouts[0]);
            layouts[1].setSelection(true);
            this.selectStandard(null);
        }
        if (!config.getBoolean("sfdcInternal")) {
            this.grid.hide(layouts[2]);
            if (!layouts[0].getVisible()) {
                this.grid.hide(layouts[1]);
            }
        }
    }

    protected void loadDataSelectionPage(Controller controller) {
        DataSelectionPage selection = (DataSelectionPage)this.getWizard().getPage(Labels.getString("DataSelectionPage.data"));
        if (selection.setupPage()) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    @Override
    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    @Override
    public IWizardPage getNextPage() {
        return super.getNextPage();
    }

    public static boolean isNeeded(Controller controller) {
        return !controller.loginIfSessionExists() || controller.getEntityDescribes() == null || controller.getEntityDescribes().isEmpty();
    }

    private void authenticationCompleted(Boolean success) {
        if (success.booleanValue()) {
            this.loadDataSelectionPage(this.controller);
        } else {
            this.setPageComplete(false);
        }
    }

    private void selectAdvanced(Event event) {
        this.show(this.advancedControl);
    }

    private void selectStandard(Event event) {
        this.show(this.standardControl);
    }

    private void selectDefault(Event event) {
        this.show(this.defaultControl);
    }

    private void show(Composite showControl) {
        this.grid.hide(this.defaultControl);
        this.grid.hide(this.standardControl);
        this.grid.hide(this.advancedControl);
        this.grid.show(showControl);
        this.control.layout(false);
    }
}

