/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.ui;

import com.salesforce.dataloader.config.Config;
import com.salesforce.dataloader.model.OAuthToken;
import com.salesforce.dataloader.ui.OAuthBrowserListener;
import com.salesforce.dataloader.ui.OAuthFlow;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Map;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.widgets.Shell;

public class OAuthTokenFlow
extends OAuthFlow {
    public OAuthTokenFlow(Shell parent, Config config) {
        super(parent, config);
    }

    @Override
    protected OAuthBrowserListener getOAuthBrowserListener(Shell shell, Browser browser, Config config) {
        return new OAuthTokenBrowserLister(shell, browser, config);
    }

    @Override
    public String getStartUrl(Config config) throws UnsupportedEncodingException {
        return OAuthTokenFlow.getStartUrlImpl(config);
    }

    public static String getStartUrlImpl(Config config) throws UnsupportedEncodingException {
        return config.getString("sfdc.oauth.server") + "/services/oauth2/authorize?response_type=token&display=popup&client_id=" + config.getString("sfdc.oauth.clientid") + "&redirect_uri=" + URLEncoder.encode(config.getString("sfdc.oauth.redirecturi"), "UTF-8");
    }

    public static class OAuthTokenBrowserLister
    extends OAuthBrowserListener {
        public OAuthTokenBrowserLister(Shell shell, Browser browser, Config config) {
            super(browser, shell, config);
        }

        @Override
        public void changed(ProgressEvent progressEvent) {
        }

        @Override
        public void completed(ProgressEvent progressEvent) {
            try {
                boolean handled = OAuthTokenBrowserLister.handleCompletedUrl(this.browser.getUrl(), this.config);
                if (handled) {
                    this.setResult(true);
                    this.shell.close();
                    this.shell.dispose();
                }
            }
            catch (URISyntaxException e) {
                this.doSimpleErrorHandling(this.browser.getUrl(), e, OAuthFlow.logger);
            }
        }

        public static boolean handleCompletedUrl(String url, Config config) throws URISyntaxException {
            Map<String, String> params = OAuthFlow.getQueryParameters(url);
            if (params.containsKey("access_token")) {
                String issued_at;
                OAuthToken token = new OAuthToken();
                token.setInstanceUrl(params.get("instance_url"));
                token.setId(params.get("id"));
                token.setAccessToken(params.get("access_token"));
                if (params.containsKey("refresh_token")) {
                    token.setRefreshToken(params.get("refresh_token"));
                }
                if (params.containsKey("scope")) {
                    token.setScope(params.get("scope"));
                }
                if (params.containsKey("signature")) {
                    token.setSignature(params.get("signature"));
                }
                if (params.containsKey("token_type")) {
                    token.setTokenType(params.get("token_type"));
                }
                if (params.containsKey("issued_at") && (issued_at = params.get("issued_at")) != null && !issued_at.equals("")) {
                    token.setIssuedAt(new Long(issued_at));
                }
                config.setValue("sfdc.oauth.accesstoken", token.getAccessToken());
                config.setValue("sfdc.oauth.refreshtoken", token.getRefreshToken());
                config.setValue("sfdc.endpoint", token.getInstanceUrl());
                return true;
            }
            return false;
        }
    }
}

