/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.ui;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.salesforce.dataloader.client.SimplePost;
import com.salesforce.dataloader.client.SimplePostFactory;
import com.salesforce.dataloader.config.Config;
import com.salesforce.dataloader.exception.ParameterLoadException;
import com.salesforce.dataloader.model.OAuthToken;
import com.salesforce.dataloader.ui.OAuthBrowserListener;
import com.salesforce.dataloader.ui.OAuthFlow;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.http.message.BasicNameValuePair;
import org.apache.log4j.Logger;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.widgets.Shell;

public class OAuthSecretFlow
extends OAuthFlow {
    protected static Logger logger = Logger.getLogger(OAuthFlow.class);

    public OAuthSecretFlow(Shell parent, Config config) {
        super(parent, config);
    }

    @Override
    protected OAuthBrowserListener getOAuthBrowserListener(Shell shell, Browser browser, Config config) {
        return new OAuthSecretBrowserListener(browser, shell, config);
    }

    @Override
    public String getStartUrl(Config config) throws UnsupportedEncodingException {
        return OAuthSecretFlow.getStartUrlImpl(config);
    }

    public static String getStartUrlImpl(Config config) throws UnsupportedEncodingException {
        return config.getString("sfdc.oauth.server") + "/services/oauth2/authorize?response_type=code&display=popup&client_id=" + config.getString("sfdc.oauth.clientid") + "&redirect_uri=" + URLEncoder.encode(config.getString("sfdc.oauth.redirecturi"), "UTF-8");
    }

    public static class OAuthSecretBrowserListener
    extends OAuthBrowserListener {
        public OAuthSecretBrowserListener(Browser browser, Shell shell, Config config) {
            super(browser, shell, config);
        }

        @Override
        public void changed(ProgressEvent progressEvent) {
        }

        @Override
        public void completed(ProgressEvent progressEvent) {
            String url = this.browser.getUrl();
            try {
                String code = OAuthSecretBrowserListener.handleInitialUrl(url);
                if (code != null) {
                    SimplePost client = OAuthSecretBrowserListener.handleSecondPost(code, this.config);
                    this.setReasonPhrase(client.getReasonPhrase());
                    this.setStatusCode(client.getStatusCode());
                    this.setResult(client.isSuccessful());
                    this.shell.close();
                    this.shell.dispose();
                }
            }
            catch (ParameterLoadException | IOException | URISyntaxException e) {
                this.doSimpleErrorHandling(url, e, logger);
            }
        }

        public static SimplePost handleSecondPost(String code, Config config) throws IOException, ParameterLoadException {
            String server = config.getString("sfdc.oauth.server") + "/services/oauth2/token";
            SimplePost client = SimplePostFactory.getInstance(config, server, new BasicNameValuePair("grant_type", "authorization_code"), new BasicNameValuePair("code", code), new BasicNameValuePair("client_id", config.getString("sfdc.oauth.clientid")), new BasicNameValuePair("client_secret", config.getString("sfdc.oauth.clientsecret")), new BasicNameValuePair("redirect_uri", config.getString("sfdc.oauth.redirecturi")));
            client.post();
            if (client.isSuccessful()) {
                StringBuilder builder = new StringBuilder();
                BufferedReader in = new BufferedReader(new InputStreamReader(client.getInput(), "UTF-8"));
                int c = in.read();
                while (c != -1) {
                    builder.append((char)c);
                    c = in.read();
                }
                String jsonTokenResult = builder.toString();
                Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
                OAuthToken token = gson.fromJson(jsonTokenResult, OAuthToken.class);
                config.setValue("sfdc.oauth.accesstoken", token.getAccessToken());
                config.setValue("sfdc.oauth.refreshtoken", token.getRefreshToken());
                config.setValue("sfdc.endpoint", token.getInstanceUrl());
            }
            return client;
        }

        public static String handleInitialUrl(String url) throws URISyntaxException {
            Map<String, String> queryParameters = OAuthFlow.getQueryParameters(url);
            return queryParameters.get("code");
        }
    }
}

