/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.ui;

import com.salesforce.dataloader.config.Config;
import com.salesforce.dataloader.ui.Grid12;
import com.salesforce.dataloader.ui.OAuthBrowserListener;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.apache.log4j.Logger;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class OAuthFlow
extends Dialog {
    protected static Logger logger = Logger.getLogger(OAuthFlow.class);
    protected final Config config;
    private String reasonPhrase;
    private int statusCode;

    public OAuthFlow(Shell parent, Config config) {
        super(parent);
        this.config = config;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public boolean open() throws UnsupportedEncodingException {
        Display display = this.getParent().getDisplay();
        Shell shell = new Shell(this.getParent(), 67684);
        Grid12 grid = new Grid12(shell, 30, 600);
        Browser browser = new Browser(shell, 0);
        browser.setLayoutData(grid.createCell(12));
        OAuthBrowserListener listener = this.getOAuthBrowserListener(shell, browser, this.config);
        browser.addProgressListener(listener);
        browser.setUrl(this.getStartUrl(this.config));
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        this.reasonPhrase = listener.getReasonPhrase();
        this.statusCode = listener.getStatusCode();
        return listener.getResult();
    }

    protected abstract OAuthBrowserListener getOAuthBrowserListener(Shell var1, Browser var2, Config var3);

    public abstract String getStartUrl(Config var1) throws UnsupportedEncodingException;

    public static Map<String, String> getQueryParameters(String url) throws URISyntaxException {
        url = url.replace("#", "?");
        HashMap<String, String> params = new HashMap<String, String>();
        new URIBuilder(url).getQueryParams().stream().forEach(kvp -> params.put(kvp.getName(), kvp.getValue()));
        return params;
    }
}

