/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.ui;

import com.salesforce.dataloader.config.Config;
import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.dyna.ObjectField;
import com.salesforce.dataloader.exception.MappingInitializationException;
import com.salesforce.dataloader.mapping.LoadMapper;
import com.salesforce.dataloader.ui.Labels;
import com.salesforce.dataloader.ui.LoadPage;
import com.salesforce.dataloader.ui.MappingDialog;
import com.salesforce.dataloader.ui.UIUtils;
import com.salesforce.dataloader.ui.mapping.MappingContentProvider;
import com.salesforce.dataloader.ui.mapping.MappingLabelProvider;
import com.sforce.soap.partner.Field;
import com.sforce.soap.partner.FieldType;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class MappingPage
extends LoadPage {
    private final Controller controller;
    private TableViewer mappingTblViewer;
    private final Logger logger = Logger.getLogger(MappingPage.class);
    private Map<String, Field> relatedFields;

    public MappingPage(Controller controller) {
        super(Labels.getString("MappingPage.title"), Labels.getString("MappingPage.titleMsg"), UIUtils.getImageRegistry().getDescriptor("splashscreens"));
        this.setDescription(Labels.getString("MappingPage.description"));
        this.controller = controller;
    }

    @Override
    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 10;
        gridLayout.marginHeight = 15;
        comp.setLayout(gridLayout);
        Button buttonExisting = new Button(comp, 0x800008);
        buttonExisting.setText(Labels.getString("MappingPage.selectExisting"));
        buttonExisting.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                FileDialog dlg = new FileDialog(MappingPage.this.getShell(), 4096);
                String filename = dlg.open();
                if (filename != null && !"".equals(filename)) {
                    Config config = MappingPage.this.controller.getConfig();
                    config.setValue("process.mappingFile", filename);
                    LoadMapper mapper = (LoadMapper)MappingPage.this.controller.getMapper();
                    mapper.clearMap();
                    try {
                        mapper.putPropertyFileMappings(filename);
                        MappingPage.this.updateMapping();
                        MappingPage.this.packMappingColumns();
                    }
                    catch (MappingInitializationException e) {
                        MappingPage.this.logger.error(Labels.getString("MappingPage.errorLoading"), e);
                        UIUtils.errorMessageBox(MappingPage.this.getShell(), e);
                    }
                }
            }
        });
        Button buttonCreateNew = new Button(comp, 0x800008);
        buttonCreateNew.setText(Labels.getString("MappingPage.createEdit"));
        MappingPage thisPage = this;
        buttonCreateNew.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                MappingDialog dlg = new MappingDialog(MappingPage.this.getShell(), MappingPage.this.controller, thisPage);
                dlg.setMapper((LoadMapper)MappingPage.this.controller.getMapper());
                dlg.setSforceFieldInfo(MappingPage.this.getFieldTypes());
                dlg.open();
            }
        });
        Label blankLabel2 = new Label(comp, 0);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.heightHint = 15;
        blankLabel2.setLayoutData(data);
        Label sep3 = new Label(comp, 258);
        data = new GridData(768);
        data.horizontalSpan = 2;
        sep3.setLayoutData(data);
        Label mappingLabel = new Label(comp, 0);
        mappingLabel.setText(Labels.getString("MappingPage.currentBelow"));
        data = new GridData();
        data.horizontalSpan = 2;
        data.heightHint = 20;
        mappingLabel.setLayoutData(data);
        this.mappingTblViewer = new TableViewer(comp, 65536);
        this.mappingTblViewer.setContentProvider(new MappingContentProvider());
        this.mappingTblViewer.setLabelProvider(new MappingLabelProvider());
        Table mappingTable = this.mappingTblViewer.getTable();
        data = new GridData(768);
        data.heightHint = 200;
        data.horizontalSpan = 2;
        mappingTable.setLayoutData(data);
        TableColumn tc = new TableColumn(mappingTable, 16384);
        tc.setText(Labels.getString("MappingPage.fileColumn"));
        tc = new TableColumn(mappingTable, 16384);
        tc.setText(Labels.getString("MappingPage.name"));
        this.updateMapping();
        this.packMappingColumns();
        mappingTable.setHeaderVisible(true);
        mappingTable.setLinesVisible(true);
        this.setControl(comp);
    }

    public void packMappingColumns() {
        if (this.mappingTblViewer != null) {
            Table mappingTable = this.mappingTblViewer.getTable();
            int n = mappingTable.getColumnCount();
            for (int i = 0; i < n; ++i) {
                mappingTable.getColumn(i).pack();
            }
        }
    }

    public void updateMapping() {
        if (this.mappingTblViewer != null) {
            this.mappingTblViewer.setInput(this.controller.getMapper());
            Table table = this.mappingTblViewer.getTable();
            if (table.getItemCount() > 0) {
                table.showItem(table.getItem(0));
            }
        }
    }

    public void refreshMapping() {
        if (this.mappingTblViewer != null) {
            this.mappingTblViewer.refresh();
        }
    }

    public Field[] getFieldTypes() {
        Field[] result;
        if (!this.controller.getConfig().getOperationInfo().isDelete()) {
            Field[] fields = this.controller.getFieldTypes().getFields();
            result = this.relatedFields != null ? this.addRelatedFields(fields) : fields;
        } else {
            Field[] idFields = new Field[1];
            Field idField = new Field();
            idField.setName("Id");
            idField.setLabel("Id");
            idField.setType(FieldType.id);
            idFields[0] = idField;
            result = idFields;
        }
        return result;
    }

    public void setRelatedFields(Map<String, Field> fields) {
        this.relatedFields = fields;
    }

    private Field[] addRelatedFields(Field[] fields) {
        LinkedList<Field> relatedFieldList = new LinkedList<Field>();
        for (Map.Entry<String, Field> relatedFieldInfo : this.relatedFields.entrySet()) {
            String relationshipName = relatedFieldInfo.getKey();
            Field relatedField = relatedFieldInfo.getValue();
            String mapFieldName = ObjectField.formatAsString(relationshipName, relatedField.getName());
            Field mapField = new Field();
            mapField.setName(mapFieldName);
            mapField.setLabel(relationshipName + " " + relatedField.getLabel());
            mapField.setType(FieldType.reference);
            mapField.setCreateable(relatedField.isCreateable());
            mapField.setUpdateable(relatedField.isUpdateable());
            relatedFieldList.add(mapField);
        }
        relatedFieldList.addAll(Arrays.asList(fields));
        return relatedFieldList.toArray(fields);
    }

    @Override
    boolean setupPage() {
        try {
            this.controller.getConfig().setValue("process.mappingFile", "");
            this.controller.createMapper();
            this.updateMapping();
            this.packMappingColumns();
            return true;
        }
        catch (MappingInitializationException e) {
            UIUtils.errorMessageBox(this.getShell(), e);
            this.logger.error("Could not initialize mapping page", e);
            return false;
        }
    }
}

