/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.ui;

import com.salesforce.dataloader.action.OperationInfo;
import com.salesforce.dataloader.config.Config;
import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.mapping.LoadMapper;
import com.salesforce.dataloader.ui.Labels;
import com.salesforce.dataloader.ui.MappingPage;
import com.salesforce.dataloader.ui.UIUtils;
import com.salesforce.dataloader.ui.mapping.MappingContentProvider;
import com.salesforce.dataloader.ui.mapping.MappingDragListener;
import com.salesforce.dataloader.ui.mapping.MappingDropAdapter;
import com.salesforce.dataloader.ui.mapping.MappingLabelProvider;
import com.salesforce.dataloader.ui.mapping.MappingViewerSorter;
import com.salesforce.dataloader.ui.mapping.SforceContentProvider;
import com.salesforce.dataloader.ui.mapping.SforceDragListener;
import com.salesforce.dataloader.ui.mapping.SforceDropAdapter;
import com.salesforce.dataloader.ui.mapping.SforceLabelProvider;
import com.salesforce.dataloader.ui.mapping.SforceViewerSorter;
import com.sforce.soap.partner.Field;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class MappingDialog
extends Dialog {
    private String input;
    private Controller controller;
    private final Logger logger = Logger.getLogger(MappingDialog.class);
    private TableViewer sforceTblViewer;
    private TableViewer mappingTblViewer;
    public static final int FIELD_NAME = 0;
    public static final int FIELD_LABEL = 1;
    public static final int FIELD_TYPE = 2;
    public static final int MAPPING_DAO = 0;
    public static final int MAPPING_SFORCE = 1;
    private Field[] fields;
    private Field[] allFields;
    private Properties restore;
    private LoadMapper mapper;
    private Field[] sforceFieldInfo;
    private MappingPage page;
    private HashSet<String> mappedFields;

    public void setSforceFieldInfo(Field[] sforceFieldInfo) {
        this.sforceFieldInfo = sforceFieldInfo;
    }

    public void setFields(Field[] newFields) {
        this.fields = newFields;
    }

    public void setMapper(LoadMapper mapper) {
        this.mapper = mapper;
        this.restore = new Properties();
        this.mappedFields = new HashSet();
        Map<String, String> elements = mapper.getMappingWithUnmappedColumns(true);
        for (Map.Entry<String, String> entry : elements.entrySet()) {
            String localColumn = entry.getKey();
            String sfdcColumn = entry.getValue();
            if (sfdcColumn == null) continue;
            this.restore.put(localColumn, sfdcColumn);
            this.mappedFields.add(sfdcColumn);
        }
    }

    public MappingDialog(Shell parent, Controller controller, MappingPage page) {
        this(parent, 67680);
        this.controller = controller;
        this.page = page;
    }

    public MappingDialog(Shell parent, int style) {
        super(parent, style);
        this.setText(Labels.getString("MappingDialog.title"));
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public String open() {
        Shell shell = new Shell(this.getParent(), this.getStyle() | 0x10);
        shell.setText(this.getText());
        shell.setSize(600, 600);
        this.createContents(shell);
        shell.pack();
        shell.open();
        Display display = this.getParent().getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.input;
    }

    private void createContents(Shell shell) {
        shell.setImage(UIUtils.getImageRegistry().get("sfdc_icon"));
        shell.setLayout(new GridLayout(1, false));
        Label label = new Label(shell, 0);
        label.setText(Labels.getString("MappingDialog.matchlabel"));
        Composite comp = new Composite(shell, 0);
        comp.setLayout(new GridLayout(2, false));
        Button buttonClear = new Button(comp, 0x800008);
        buttonClear.setText(Labels.getString("MappingDialog.clearMapping"));
        buttonClear.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                MappingDialog.this.updateSforce();
                MappingDialog.this.clearMapping();
                MappingDialog.this.packMappingColumns();
                MappingDialog.this.packSforceColumns();
            }
        });
        Button buttonMatch = new Button(comp, 0x800008);
        buttonMatch.setText(Labels.getString("MappingDialog.autoMatch"));
        buttonMatch.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                MappingDialog.this.autoMatchFields();
            }
        });
        this.initializeSforceViewer(shell);
        Label sep1 = new Label(shell, 258);
        sep1.setLayoutData(new GridData(768));
        Composite compMid = new Composite(shell, 0);
        compMid.setLayout(new GridLayout(2, false));
        new Label(compMid, 0).setText(Labels.getString("MappingDialog.dragFields"));
        new Label(compMid, 0).setImage(UIUtils.getImageRegistry().get("downArrow"));
        Label sep2 = new Label(shell, 258);
        sep2.setLayoutData(new GridData(768));
        this.initializeMappingViewer(shell);
        Label sep3 = new Label(shell, 258);
        sep3.setLayoutData(new GridData(768));
        Composite comp2 = new Composite(shell, 0);
        comp2.setLayout(new GridLayout(3, false));
        Button ok = new Button(comp2, 0x800008);
        ok.setText(Labels.getString("UI.ok"));
        GridData data = new GridData();
        data.widthHint = 75;
        ok.setLayoutData(data);
        ok.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                MappingDialog.this.page.updateMapping();
                MappingDialog.this.page.packMappingColumns();
                shell.close();
            }
        });
        Button buttonSave = new Button(comp2, 0x800008);
        buttonSave.setText(Labels.getString("MappingDialog.saveMapping"));
        data = new GridData();
        data.widthHint = Math.max(75, buttonSave.computeSize((int)-1, (int)-1, (boolean)true).x);
        buttonSave.setLayoutData(data);
        buttonSave.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                int selectedButton;
                FileDialog dlg = new FileDialog(shell, 8192);
                Config config = MappingDialog.this.controller.getConfig();
                dlg.setFileName(config.getString("process.mappingFile"));
                dlg.setFilterPath(config.getString("process.mappingFile"));
                dlg.setFilterExtensions(new String[]{"*.sdl"});
                String filename = dlg.open();
                boolean cancel = false;
                if (filename == null || "".equals(filename)) {
                    cancel = true;
                }
                while (!cancel && new File(filename).exists() && (selectedButton = UIUtils.warningConfMessageBox(shell, Labels.getString("UI.fileAlreadyExists"))) != 64) {
                    if (selectedButton != 128 || (filename = dlg.open()) != null && !"".equals(filename)) continue;
                    cancel = true;
                }
                if (!cancel) {
                    config.setValue("process.mappingFile", filename);
                    try {
                        MappingDialog.this.mapper.save(filename);
                    }
                    catch (IOException e1) {
                        MappingDialog.this.logger.error(Labels.getString("MappingDialog.errorSave"), e1);
                    }
                }
                MappingDialog.this.page.updateMapping();
                MappingDialog.this.page.packMappingColumns();
            }
        });
        Button cancel = new Button(comp2, 0x800008);
        cancel.setText(Labels.getString("UI.cancel"));
        data = new GridData();
        data.widthHint = 75;
        cancel.setLayoutData(data);
        cancel.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                MappingDialog.this.mapper.clearMap();
                MappingDialog.this.mapper.putPropertyFileMappings(MappingDialog.this.restore);
                shell.close();
            }
        });
        shell.setDefaultButton(ok);
    }

    private void initializeMappingViewer(Shell shell) {
        this.mappingTblViewer = new TableViewer(shell, 65536);
        this.mappingTblViewer.setContentProvider(new MappingContentProvider());
        this.mappingTblViewer.setLabelProvider(new MappingLabelProvider());
        this.mappingTblViewer.setSorter(new MappingViewerSorter());
        int ops = 2;
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance()};
        this.mappingTblViewer.addDropSupport(ops, transfers, new MappingDropAdapter(this.mappingTblViewer, this));
        this.mappingTblViewer.addDragSupport(ops, transfers, new SforceDragListener(this.mappingTblViewer, this));
        Table mappingTable = this.mappingTblViewer.getTable();
        GridData data = new GridData(1808);
        data.heightHint = 200;
        mappingTable.setLayoutData(data);
        mappingTable.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f') {
                    IStructuredSelection selection = (IStructuredSelection)MappingDialog.this.mappingTblViewer.getSelection();
                    Iterator it = selection.iterator();
                    while (it.hasNext()) {
                        Map.Entry elem = (Map.Entry)it.next();
                        String oldSforce = (String)elem.getValue();
                        if (oldSforce == null || oldSforce.length() <= 0) continue;
                        MappingDialog.this.replenishField(oldSforce);
                        elem.setValue("");
                        MappingDialog.this.mapper.removeMapping((String)elem.getKey());
                        MappingDialog.this.packMappingColumns();
                        MappingDialog.this.mappingTblViewer.refresh();
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent event) {
            }
        });
        TableColumn tc = new TableColumn(mappingTable, 16384);
        tc.setText(Labels.getString("MappingDialog.fileColumn"));
        tc.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                ((MappingViewerSorter)MappingDialog.this.mappingTblViewer.getSorter()).doSort(0);
                MappingDialog.this.mappingTblViewer.refresh();
            }
        });
        tc = new TableColumn(mappingTable, 16384);
        tc.setText(Labels.getString("MappingDialog.fileName"));
        tc.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                ((MappingViewerSorter)MappingDialog.this.mappingTblViewer.getSorter()).doSort(1);
                MappingDialog.this.mappingTblViewer.refresh();
            }
        });
        this.updateMapping();
        this.packMappingColumns();
        mappingTable.setHeaderVisible(true);
        mappingTable.setLinesVisible(true);
        if (mappingTable.getItemCount() > 0) {
            mappingTable.showItem(mappingTable.getItem(0));
        }
    }

    private void initializeSforceViewer(Shell shell) {
        this.sforceTblViewer = new TableViewer(shell, 65536);
        this.sforceTblViewer.setContentProvider(new SforceContentProvider());
        this.sforceTblViewer.setLabelProvider(new SforceLabelProvider());
        this.sforceTblViewer.setSorter(new SforceViewerSorter());
        int ops = 2;
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance()};
        this.sforceTblViewer.addDragSupport(ops, transfers, new MappingDragListener(this.sforceTblViewer, this));
        this.sforceTblViewer.addDropSupport(ops, transfers, new SforceDropAdapter(this.sforceTblViewer, this));
        Table sforceTable = this.sforceTblViewer.getTable();
        GridData data = new GridData(1808);
        data.heightHint = 150;
        sforceTable.setLayoutData(data);
        TableColumn tc = new TableColumn(sforceTable, 16384);
        tc.setText(Labels.getString("MappingDialog.sforceName"));
        tc.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                ((SforceViewerSorter)MappingDialog.this.sforceTblViewer.getSorter()).doSort(0);
                MappingDialog.this.sforceTblViewer.refresh();
            }
        });
        tc = new TableColumn(sforceTable, 16384);
        tc.setText(Labels.getString("MappingDialog.sforceLabel"));
        tc.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                ((SforceViewerSorter)MappingDialog.this.sforceTblViewer.getSorter()).doSort(1);
                MappingDialog.this.sforceTblViewer.refresh();
            }
        });
        tc = new TableColumn(sforceTable, 131072);
        tc.setText(Labels.getString("MappingDialog.sforceType"));
        tc.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                ((SforceViewerSorter)MappingDialog.this.sforceTblViewer.getSorter()).doSort(2);
                MappingDialog.this.sforceTblViewer.refresh();
            }
        });
        this.updateSforce();
        this.packSforceColumns();
        sforceTable.setHeaderVisible(true);
        sforceTable.setLinesVisible(true);
        if (sforceTable.getItemCount() > 0) {
            sforceTable.showItem(sforceTable.getItem(0));
        }
    }

    private void autoMatchFields() {
        LinkedList<Field> fieldList = new LinkedList<Field>(Arrays.asList(this.fields));
        ListIterator iterator = fieldList.listIterator();
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            String fieldName = field.getName();
            String fieldLabel = field.getLabel();
            String mappingSource = null;
            if (this.mappedFields.contains(fieldName)) continue;
            if (this.mapper.hasDaoColumn(fieldName)) {
                mappingSource = fieldName;
            } else if (this.mapper.hasDaoColumn(fieldLabel)) {
                mappingSource = fieldLabel;
            }
            if (mappingSource == null) continue;
            String oldFieldName = this.mapper.getMapping(mappingSource);
            if (oldFieldName == null || oldFieldName.length() == 0) {
                this.mapper.putMapping(mappingSource, fieldName);
            }
            iterator.remove();
        }
        this.fields = fieldList.toArray(new Field[fieldList.size()]);
        this.sforceTblViewer.setInput(this.fields);
        this.sforceTblViewer.refresh();
        this.mappingTblViewer.refresh();
        this.packMappingColumns();
        this.packSforceColumns();
    }

    public void packMappingColumns() {
        Table mappingTable = this.mappingTblViewer.getTable();
        int n = mappingTable.getColumnCount();
        for (int i = 0; i < n; ++i) {
            mappingTable.getColumn(i).pack();
        }
    }

    private void packSforceColumns() {
        Table sforceTable = this.sforceTblViewer.getTable();
        int n = sforceTable.getColumnCount();
        for (int i = 0; i < n; ++i) {
            sforceTable.getColumn(i).pack();
        }
    }

    public void replenishField(String fieldName) {
        for (int i = 0; i < this.allFields.length; ++i) {
            Field field = this.allFields[i];
            if (!field.getName().equals(fieldName)) continue;
            ArrayList<Field> fieldArray = new ArrayList<Field>(Arrays.asList(this.fields));
            fieldArray.add(field);
            this.fields = fieldArray.toArray(new Field[fieldArray.size()]);
            this.sforceTblViewer.setInput(this.fields);
            this.sforceTblViewer.refresh();
            this.packSforceColumns();
            return;
        }
    }

    private void updateSforce() {
        ArrayList<Field> mappableFieldList = new ArrayList<Field>();
        ArrayList<Field> allFieldList = new ArrayList<Field>();
        OperationInfo operation = this.controller.getConfig().getOperationInfo();
        for (int i = 0; i < this.sforceFieldInfo.length; ++i) {
            Field field = this.sforceFieldInfo[i];
            boolean isMappable = false;
            switch (operation) {
                case insert: {
                    if (!field.isCreateable()) break;
                    isMappable = true;
                    break;
                }
                case delete: 
                case hard_delete: {
                    if (!field.getType().toString().toLowerCase().equals("id")) break;
                    isMappable = true;
                    break;
                }
                case upsert: {
                    if (!field.isUpdateable() && !field.isCreateable() && !field.getType().toString().toLowerCase().equals("id")) break;
                    isMappable = true;
                    break;
                }
                case update: {
                    if (!field.isUpdateable() && !field.getType().toString().toLowerCase().equals("id")) break;
                    isMappable = true;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            if (!isMappable) continue;
            if (!this.mappedFields.contains(field.getName())) {
                mappableFieldList.add(field);
            }
            allFieldList.add(field);
        }
        this.fields = mappableFieldList.toArray(new Field[mappableFieldList.size()]);
        this.allFields = allFieldList.toArray(new Field[allFieldList.size()]);
        this.sforceTblViewer.setInput(this.fields);
    }

    private void clearMapping() {
        this.mapper.clearMap();
        for (String fieldName : this.mappedFields) {
            this.replenishField(fieldName);
        }
        this.mappedFields.clear();
        this.mappingTblViewer.refresh();
    }

    private void updateMapping() {
        this.mappingTblViewer.setInput(this.mapper);
    }

    public LoadMapper getMapper() {
        return this.mapper;
    }
}

