/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.ui;

import com.salesforce.dataloader.model.LoginCriteria;
import com.salesforce.dataloader.ui.AuthenticationRunner;
import com.salesforce.dataloader.ui.Grid12;
import com.salesforce.dataloader.ui.Labels;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class LoginStandardControl
extends Composite {
    private final Grid12 grid;
    private final Button loginButton;
    private final Text userName;
    private final Text password;
    private final Text instanceUrl;
    private final AuthenticationRunner authentication;
    private final Label loginLabel;

    public LoginStandardControl(Composite parent, int style, AuthenticationRunner authentication) {
        super(parent, style);
        this.authentication = authentication;
        this.grid = new Grid12(this, 40, 20);
        this.grid.createLabel(4, Labels.getString("SettingsPage.username"));
        this.userName = this.grid.createText(6, 2052, authentication.getConfig().getString("sfdc.username"));
        this.grid.createPadding(2);
        this.grid.createLabel(4, Labels.getString("SettingsPage.password"));
        this.password = this.grid.createText(6, 0x400800, "");
        this.grid.createPadding(2);
        this.grid.createLabel(4, Labels.getString("SettingsPage.instServerUrl"));
        this.instanceUrl = this.grid.createText(6, 2048, authentication.getConfig().getString("sfdc.endpoint"));
        this.grid.createPadding(2);
        this.loginLabel = this.grid.createLabel(8, "");
        this.loginButton = this.grid.createButton(2, 0x80000C, Labels.getString("SettingsPage.login"));
        this.loginButton.addListener(13, this::loginButton_Clicked);
        this.grid.createPadding(2);
    }

    private void loginButton_Clicked(Event event) {
        LoginCriteria criteria = new LoginCriteria(1);
        criteria.setInstanceUrl(this.instanceUrl.getText());
        criteria.setUserName(this.userName.getText());
        criteria.setPassword(this.password.getText());
        this.authentication.login(criteria, this.loginLabel::setText);
    }
}

