/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.ui;

import com.salesforce.dataloader.model.LoginCriteria;
import com.salesforce.dataloader.ui.AuthenticationRunner;
import com.salesforce.dataloader.ui.Grid12;
import com.salesforce.dataloader.ui.Labels;
import java.util.ArrayList;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;

public class LoginDefaultControl
extends Composite {
    private final Button loginButton;
    private final CCombo environment;
    private final AuthenticationRunner authenticator;
    private final Label loginLabel;

    public LoginDefaultControl(Composite parent, int style, AuthenticationRunner authenticator) {
        super(parent, style);
        this.authenticator = authenticator;
        Grid12 grid = new Grid12(this, 40, 20);
        grid.createLabel(4, Labels.getString("SettingsPage.environment"));
        ArrayList<String> environments = authenticator.getConfig().getStrings("sfdc.oauth.environments");
        this.environment = grid.createCombo(6, 2052, environments);
        String currentEnvironment = authenticator.getConfig().getString("sfdc.oauth.environment");
        if (environments.contains(currentEnvironment)) {
            this.environment.setText(currentEnvironment);
        }
        grid.createPadding(2);
        this.loginLabel = grid.createLabel(8, "");
        this.loginButton = grid.createButton(2, 0x80000C, Labels.getString("SettingsPage.login"));
        this.loginButton.addListener(13, this::loginButton_Clicked);
        grid.createPadding(2);
    }

    private void loginButton_Clicked(Event event) {
        LoginCriteria criteria = new LoginCriteria(0);
        criteria.setEnvironment(this.environment.getText());
        this.authenticator.login(criteria, this.loginLabel::setText);
    }
}

