/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.ui;

import com.salesforce.dataloader.model.LoginCriteria;
import com.salesforce.dataloader.ui.AuthenticationRunner;
import com.salesforce.dataloader.ui.Grid12;
import com.salesforce.dataloader.ui.Labels;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class LoginAdvancedControl
extends Composite {
    private final Text loginUrl;
    private final Button loginButton;
    private final Text sessionId;
    private final AuthenticationRunner authenticator;
    private final Label loginLabel;
    private final Text userName;

    public LoginAdvancedControl(Composite parent, int style, AuthenticationRunner authenticator) {
        super(parent, style);
        this.authenticator = authenticator;
        Grid12 grid = new Grid12(this, 40, 20);
        grid.createLabel(4, Labels.getString("SettingsPage.username"));
        this.userName = grid.createText(6, 2052, authenticator.getConfig().getString("sfdc.username"));
        grid.createPadding(2);
        grid.createLabel(4, Labels.getString("SettingsPage.sessionId"));
        this.sessionId = grid.createText(6, 2048, authenticator.getConfig().getString("sfdcInternal.sessionId"));
        grid.createPadding(2);
        grid.createLabel(4, Labels.getString("SettingsPage.instServerUrl"));
        this.loginUrl = grid.createText(6, 2048, authenticator.getConfig().getString("sfdc.endpoint"));
        grid.createPadding(2);
        this.loginLabel = grid.createLabel(8, "");
        this.loginButton = grid.createButton(2, 12, Labels.getString("SettingsPage.login"));
        this.loginButton.addListener(13, this::loginButton_Clicked);
        grid.createPadding(2);
    }

    private void loginButton_Clicked(Event event) {
        LoginCriteria criteria = new LoginCriteria(2);
        criteria.setInstanceUrl(this.loginUrl.getText());
        criteria.setSessionId(this.sessionId.getText());
        criteria.setUserName(this.userName.getText());
        this.authenticator.login(criteria, this.loginLabel::setText);
    }
}

