/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.ui;

import com.salesforce.dataloader.ui.LoaderTitleAreaDialog;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer2;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class LoaderWizardDialog
extends LoaderTitleAreaDialog
implements IWizardContainer2 {
    public static final String WIZ_IMG_ERROR = "dialog_title_error_image";
    private IWizard wizard;
    private ArrayList<IWizard> createdWizards = new ArrayList();
    private ArrayList<IWizard> nestedWizards = new ArrayList();
    private IWizardPage currentPage = null;
    private long activeRunningOperations = 0L;
    private String pageMessage;
    private int pageMessageType = 0;
    private String pageDescription;
    private ProgressMonitorPart progressMonitorPart;
    private Cursor waitCursor;
    private Cursor arrowCursor;
    private MessageDialog windowClosingDialog;
    private Button backButton;
    private Button nextButton;
    private Button finishButton;
    private Button cancelButton;
    private Button helpButton;
    private SelectionAdapter cancelListener;
    private boolean isMovingToPreviousPage = false;
    private Composite pageContainer;
    private PageContainerFillLayout pageContainerLayout = new PageContainerFillLayout(5, 5, 300, 225);
    private int pageWidth = -1;
    private int pageHeight = -1;
    private static final String FOCUS_CONTROL = "focusControl";
    private boolean lockedUI = false;
    private HashMap<Integer, Button> buttons = new HashMap();

    public LoaderWizardDialog(Shell parentShell, IWizard newWizard) {
        super(parentShell);
        this.setShellStyle(67696);
        this.setWizard(newWizard);
        this.cancelListener = new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                LoaderWizardDialog.this.cancelPressed();
            }
        };
    }

    private Object aboutToStart(boolean enableCancelButton) {
        Map<String, Object> savedState = null;
        if (this.getShell() != null) {
            Control focusControl = this.getShell().getDisplay().getFocusControl();
            if (focusControl != null && focusControl.getShell() != this.getShell()) {
                focusControl = null;
            }
            boolean needsProgressMonitor = this.wizard.needsProgressMonitor();
            this.cancelButton.removeSelectionListener(this.cancelListener);
            Display d = this.getShell().getDisplay();
            this.waitCursor = new Cursor(d, 1);
            this.setDisplayCursor(this.waitCursor);
            this.arrowCursor = new Cursor(d, 0);
            this.cancelButton.setCursor(this.arrowCursor);
            savedState = this.saveUIState(needsProgressMonitor && enableCancelButton);
            if (focusControl != null) {
                savedState.put(FOCUS_CONTROL, focusControl);
            }
            if (needsProgressMonitor) {
                this.progressMonitorPart.attachToCancelComponent(this.cancelButton);
                this.progressMonitorPart.setVisible(true);
            }
        }
        return savedState;
    }

    protected void backPressed() {
        IWizardPage page = this.currentPage.getPreviousPage();
        if (page == null) {
            return;
        }
        this.isMovingToPreviousPage = true;
        this.showPage(page);
    }

    @Override
    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 17: {
                this.helpPressed();
                break;
            }
            case 14: {
                this.backPressed();
                break;
            }
            case 15: {
                this.nextPressed();
                break;
            }
            case 16: {
                this.finishPressed();
            }
        }
    }

    private Point calculatePageSizeDelta(IWizardPage page) {
        Control pageControl = page.getControl();
        if (pageControl == null) {
            return new Point(0, 0);
        }
        Point contentSize = pageControl.computeSize(-1, -1, true);
        Rectangle rect = this.pageContainerLayout.getClientArea(this.pageContainer);
        Point containerSize = new Point(rect.width, rect.height);
        return new Point(Math.max(0, contentSize.x - containerSize.x), Math.max(0, contentSize.y - containerSize.y));
    }

    @Override
    protected void cancelPressed() {
        if (this.activeRunningOperations <= 0L) {
            this.setReturnCode(1);
            this.close();
        } else {
            this.cancelButton.setEnabled(false);
        }
    }

    @Override
    public boolean close() {
        if (this.okToClose()) {
            return this.hardClose();
        }
        return false;
    }

    @Override
    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.addHelpListener(new HelpListener(){

            @Override
            public void helpRequested(HelpEvent event) {
                if (LoaderWizardDialog.this.currentPage != null) {
                    LoaderWizardDialog.this.currentPage.performHelp();
                }
            }
        });
    }

    @Override
    protected Control createButtonBar(Composite parent) {
        Composite composite = (Composite)super.createButtonBar(parent);
        ((GridLayout)composite.getLayout()).makeColumnsEqualWidth = false;
        return composite;
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        if (this.wizard.isHelpAvailable()) {
            this.helpButton = this.createButton(parent, 17, IDialogConstants.HELP_LABEL, false);
        }
        if (this.wizard.needsPreviousAndNextButtons()) {
            this.createPreviousAndNextButtons(parent);
        }
        this.finishButton = this.createButton(parent, 16, IDialogConstants.FINISH_LABEL, true);
        this.cancelButton = this.createCancelButton(parent);
    }

    private Button createCancelButton(Composite parent) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 0x800008);
        button.setText(IDialogConstants.CANCEL_LABEL);
        this.setButtonLayoutData(button);
        button.setFont(parent.getFont());
        button.setData(new Integer(1));
        button.addSelectionListener(this.cancelListener);
        return button;
    }

    @Override
    protected Button getButton(int id) {
        if (id == 1) {
            return this.cancelButton;
        }
        return this.buttons.get(new Integer(id));
    }

    @Override
    protected Control createContents(Composite parent) {
        this.wizard.addPages();
        Control contents = super.createContents(parent);
        this.createPageControls();
        this.showStartingPage();
        return contents;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.pageContainer = this.createPageContainer(composite);
        GridData gd = new GridData(1808);
        gd.widthHint = this.pageWidth;
        gd.heightHint = this.pageHeight;
        this.pageContainer.setLayoutData(gd);
        this.pageContainer.setFont(parent.getFont());
        GridLayout pmlayout = new GridLayout();
        pmlayout.numColumns = 1;
        this.progressMonitorPart = this.createProgressMonitorPart(composite, pmlayout);
        this.progressMonitorPart.setLayoutData(new GridData(768));
        this.progressMonitorPart.setVisible(false);
        Label separator = new Label(composite, 258);
        separator.setLayoutData(new GridData(768));
        LoaderWizardDialog.applyDialogFont(this.progressMonitorPart);
        return composite;
    }

    protected ProgressMonitorPart createProgressMonitorPart(Composite composite, GridLayout pmlayout) {
        return new ProgressMonitorPart(composite, pmlayout, -1){
            String currentTask;
            {
                this.currentTask = null;
            }

            @Override
            public void setBlocked(IStatus reason) {
                super.setBlocked(reason);
                if (!LoaderWizardDialog.this.lockedUI) {
                    Dialog.getBlockedHandler().showBlocked(this.getShell(), this, reason, this.currentTask);
                }
            }

            @Override
            public void clearBlocked() {
                super.clearBlocked();
                if (!LoaderWizardDialog.this.lockedUI) {
                    Dialog.getBlockedHandler().clearBlocked();
                }
            }

            @Override
            public void beginTask(String name, int totalWork) {
                super.beginTask(name, totalWork);
                this.currentTask = name;
            }

            @Override
            public void setTaskName(String name) {
                super.setTaskName(name);
                this.currentTask = name;
            }

            @Override
            public void subTask(String name) {
                super.subTask(name);
                if (this.currentTask == null) {
                    this.currentTask = name;
                }
            }
        };
    }

    private Composite createPageContainer(Composite parent) {
        Composite result = new Composite(parent, 0);
        result.setLayout(this.pageContainerLayout);
        return result;
    }

    private void createPageControls() {
        this.wizard.createPageControls(this.pageContainer);
        IWizardPage[] pages = this.wizard.getPages();
        for (int i = 0; i < pages.length; ++i) {
            IWizardPage page = pages[i];
            if (page.getControl() == null) continue;
            page.getControl().setVisible(false);
        }
    }

    private Composite createPreviousAndNextButtons(Composite parent) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        composite.setLayout(layout);
        GridData data = new GridData(68);
        composite.setLayoutData(data);
        composite.setFont(parent.getFont());
        this.backButton = this.createButton(composite, 14, IDialogConstants.BACK_LABEL, false);
        this.nextButton = this.createButton(composite, 15, IDialogConstants.NEXT_LABEL, false);
        return composite;
    }

    private MessageDialog createWizardClosingDialog() {
        MessageDialog result = new MessageDialog(this.getShell(), JFaceResources.getString("WizardClosingDialog.title"), null, JFaceResources.getString("WizardClosingDialog.message"), 3, new String[]{IDialogConstants.OK_LABEL}, 0);
        return result;
    }

    protected void finishPressed() {
        if (this.wizard.performFinish()) {
            for (int i = 0; i < this.nestedWizards.size() - 1; ++i) {
                this.nestedWizards.get(i).performFinish();
            }
            this.setReturnCode(0);
            this.hardClose();
        }
    }

    @Override
    public IWizardPage getCurrentPage() {
        return this.currentPage;
    }

    protected IProgressMonitor getProgressMonitor() {
        return this.progressMonitorPart;
    }

    protected IWizard getWizard() {
        return this.wizard;
    }

    private boolean hardClose() {
        for (int i = 0; i < this.createdWizards.size(); ++i) {
            IWizard createdWizard = this.createdWizards.get(i);
            createdWizard.dispose();
            createdWizard.setContainer(null);
        }
        boolean close = super.close();
        if (close) {
            this.buttons = new HashMap();
        }
        return close;
    }

    protected void helpPressed() {
        if (this.currentPage != null) {
            this.currentPage.performHelp();
        }
    }

    protected void nextPressed() {
        IWizardPage page = this.currentPage.getNextPage();
        if (page == null) {
            return;
        }
        this.showPage(page);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean okToClose() {
        if (this.activeRunningOperations > 0L) {
            LoaderWizardDialog loaderWizardDialog = this;
            synchronized (loaderWizardDialog) {
                this.windowClosingDialog = this.createWizardClosingDialog();
            }
            this.windowClosingDialog.open();
            loaderWizardDialog = this;
            synchronized (loaderWizardDialog) {
                this.windowClosingDialog = null;
            }
            return false;
        }
        return this.wizard.performCancel();
    }

    private void restoreEnableState(Control w, Map h, String key) {
        Boolean b;
        if (w != null && (b = (Boolean)h.get(key)) != null) {
            w.setEnabled(b);
        }
    }

    private void restoreUIState(Map state) {
        this.restoreEnableState(this.backButton, state, "back");
        this.restoreEnableState(this.nextButton, state, "next");
        this.restoreEnableState(this.finishButton, state, "finish");
        this.restoreEnableState(this.cancelButton, state, "cancel");
        this.restoreEnableState(this.helpButton, state, "help");
        Object pageValue = state.get("page");
        if (pageValue != null) {
            ((ControlEnableState)pageValue).restore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        Object state = null;
        if (this.activeRunningOperations == 0L) {
            state = this.aboutToStart(fork && cancelable);
        }
        ++this.activeRunningOperations;
        try {
            if (!fork) {
                this.lockedUI = true;
            }
            ModalContext.run(runnable, fork, this.getProgressMonitor(), this.getShell().getDisplay());
            this.lockedUI = false;
        }
        finally {
            --this.activeRunningOperations;
            if (state != null) {
                this.stopped(state);
            }
        }
    }

    private void saveEnableStateAndSet(Control w, Map<String, Object> h, String key, boolean enabled) {
        if (w != null) {
            h.put(key, new Boolean(w.getEnabled()));
            w.setEnabled(enabled);
        }
    }

    private Map<String, Object> saveUIState(boolean keepCancelEnabled) {
        HashMap<String, Object> savedState = new HashMap<String, Object>(10);
        this.saveEnableStateAndSet(this.backButton, savedState, "back", false);
        this.saveEnableStateAndSet(this.nextButton, savedState, "next", false);
        this.saveEnableStateAndSet(this.finishButton, savedState, "finish", false);
        this.saveEnableStateAndSet(this.cancelButton, savedState, "cancel", keepCancelEnabled);
        this.saveEnableStateAndSet(this.helpButton, savedState, "help", false);
        if (this.currentPage != null) {
            savedState.put("page", ControlEnableState.disable(this.currentPage.getControl()));
        }
        return savedState;
    }

    private void setDisplayCursor(Cursor c) {
        Shell[] shells = this.getShell().getDisplay().getShells();
        for (int i = 0; i < shells.length; ++i) {
            shells[i].setCursor(c);
        }
    }

    public void setMinimumPageSize(int minWidth, int minHeight) {
        assert (minWidth >= 0 && minHeight >= 0);
        this.pageContainerLayout.minimumWidth = minWidth;
        this.pageContainerLayout.minimumHeight = minHeight;
    }

    public void setMinimumPageSize(Point size) {
        this.setMinimumPageSize(size.x, size.y);
    }

    public void setPageSize(int width, int height) {
        this.pageWidth = width;
        this.pageHeight = height;
    }

    public void setPageSize(Point size) {
        this.setPageSize(size.x, size.y);
    }

    protected void setWizard(IWizard newWizard) {
        this.wizard = newWizard;
        this.wizard.setContainer(this);
        if (!this.createdWizards.contains(this.wizard)) {
            this.createdWizards.add(this.wizard);
            this.nestedWizards.add(this.wizard);
            if (this.pageContainer != null) {
                this.createPageControls();
                this.updateSizeForWizard(this.wizard);
                this.pageContainer.layout(true);
            }
        } else {
            int size = this.nestedWizards.size();
            if (size >= 2 && this.nestedWizards.get(size - 2) == this.wizard) {
                this.nestedWizards.remove(size - 1);
            } else {
                this.nestedWizards.add(this.wizard);
            }
        }
    }

    @Override
    public void showPage(IWizardPage page) {
        if (page == null || page == this.currentPage) {
            return;
        }
        if (!this.isMovingToPreviousPage) {
            page.setPreviousPage(this.currentPage);
        } else {
            this.isMovingToPreviousPage = false;
        }
        if (this.getContents() == null) {
            this.updateForPage(page);
        } else {
            IWizardPage finalPage = page;
            BusyIndicator.showWhile(this.getContents().getDisplay(), new Runnable(){

                @Override
                public void run() {
                    LoaderWizardDialog.this.updateForPage(finalPage);
                }
            });
        }
    }

    private void updateForPage(IWizardPage page) {
        if (this.wizard != page.getWizard()) {
            this.setWizard(page.getWizard());
        }
        if (page.getControl() == null) {
            page.createControl(this.pageContainer);
            assert (page.getControl() != null);
            this.updateSize(page);
        }
        IWizardPage oldPage = this.currentPage;
        this.currentPage = page;
        this.currentPage.setVisible(true);
        if (oldPage != null) {
            oldPage.setVisible(false);
        }
        this.update();
    }

    private void showStartingPage() {
        this.currentPage = this.wizard.getStartingPage();
        if (this.currentPage == null) {
            return;
        }
        if (this.currentPage.getControl() == null) {
            this.currentPage.createControl(this.pageContainer);
            assert (this.currentPage.getControl() != null);
        }
        this.currentPage.setVisible(true);
        this.update();
    }

    private void stopped(Object savedState) {
        if (this.getShell() != null) {
            if (this.wizard.needsProgressMonitor()) {
                this.progressMonitorPart.setVisible(false);
                this.progressMonitorPart.removeFromCancelComponent(this.cancelButton);
            }
            Map state = (Map)savedState;
            this.restoreUIState(state);
            this.cancelButton.addSelectionListener(this.cancelListener);
            this.setDisplayCursor(null);
            this.cancelButton.setCursor(null);
            this.waitCursor.dispose();
            this.waitCursor = null;
            this.arrowCursor.dispose();
            this.arrowCursor = null;
            Control focusControl = (Control)state.get(FOCUS_CONTROL);
            if (focusControl != null) {
                focusControl.setFocus();
            }
        }
    }

    protected void update() {
        this.updateWindowTitle();
        this.updateTitleBar();
        this.updateButtons();
    }

    @Override
    public void updateButtons() {
        boolean canFlipToNextPage = false;
        boolean canFinish = this.wizard.canFinish();
        if (this.backButton != null) {
            this.backButton.setEnabled(this.currentPage.getPreviousPage() != null);
        }
        if (this.nextButton != null) {
            canFlipToNextPage = this.currentPage.canFlipToNextPage();
            this.nextButton.setEnabled(canFlipToNextPage);
        }
        this.finishButton.setEnabled(canFinish);
        if (canFlipToNextPage && !canFinish) {
            this.getShell().setDefaultButton(this.nextButton);
        } else {
            this.getShell().setDefaultButton(this.finishButton);
        }
    }

    protected void updateBannerImage() {
    }

    private void updateDescriptionMessage() {
        this.pageDescription = this.currentPage.getDescription();
        if (this.pageMessage == null) {
            this.setMessage(this.currentPage.getDescription());
        }
    }

    @Override
    public void updateMessage() {
        if (this.currentPage == null) {
            return;
        }
        this.pageMessage = this.currentPage.getMessage();
        this.pageMessageType = this.pageMessage != null && this.currentPage instanceof IMessageProvider ? ((IMessageProvider)((Object)this.currentPage)).getMessageType() : 0;
        if (this.pageMessage == null) {
            this.setMessage(this.pageDescription);
        } else {
            this.setMessage(this.pageMessage, this.pageMessageType);
        }
        this.setErrorMessage(this.currentPage.getErrorMessage());
    }

    private void setShellSize(int width, int height) {
        Rectangle size = this.getShell().getBounds();
        size.height = height;
        size.width = width;
        this.getShell().setBounds(this.getConstrainedShellBounds(size));
    }

    protected void updateSize(IWizardPage page) {
        if (page == null || page.getControl() == null) {
            return;
        }
        this.updateSizeForPage(page);
        this.pageContainerLayout.layoutPage(page.getControl());
    }

    @Override
    public void updateSize() {
        this.updateSize(this.currentPage);
    }

    private void updateSizeForPage(IWizardPage page) {
        Point delta = this.calculatePageSizeDelta(page);
        if (delta.x > 0 || delta.y > 0) {
            Shell shell = this.getShell();
            Point shellSize = shell.getSize();
            this.setShellSize(shellSize.x + delta.x, shellSize.y + delta.y);
            this.constrainShellSize();
        }
    }

    private void updateSizeForWizard(IWizard sizingWizard) {
        Point delta = new Point(0, 0);
        IWizardPage[] pages = sizingWizard.getPages();
        for (int i = 0; i < pages.length; ++i) {
            Point pageDelta = this.calculatePageSizeDelta(pages[i]);
            delta.x = Math.max(delta.x, pageDelta.x);
            delta.y = Math.max(delta.y, pageDelta.y);
        }
        if (delta.x > 0 || delta.y > 0) {
            Shell shell = this.getShell();
            Point shellSize = shell.getSize();
            this.setShellSize(shellSize.x + delta.x, shellSize.y + delta.y);
        }
    }

    @Override
    public void updateTitleBar() {
        String s = null;
        if (this.currentPage != null) {
            s = this.currentPage.getTitle();
        }
        if (s == null) {
            s = "";
        }
        this.setTitle(s);
        if (this.currentPage != null) {
            this.setTitleImage(this.currentPage.getImage());
        }
        this.updateDescriptionMessage();
        this.updateMessage();
        this.updateBannerImage();
    }

    @Override
    public void updateWindowTitle() {
        if (this.getShell() == null) {
            return;
        }
        String title = this.wizard.getWindowTitle();
        if (title == null) {
            title = "";
        }
        this.getShell().setText(title);
    }

    @Override
    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Shell shell;
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 0x800008);
        button.setText(label);
        button.setFont(JFaceResources.getDialogFont());
        button.setData(new Integer(id));
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                LoaderWizardDialog.this.buttonPressed((Integer)event.widget.getData());
            }
        });
        if (defaultButton && (shell = parent.getShell()) != null) {
            shell.setDefaultButton(button);
        }
        this.buttons.put(new Integer(id), button);
        this.setButtonLayoutData(button);
        return button;
    }

    protected class PageContainerFillLayout
    extends Layout {
        public int marginWidth = 5;
        public int marginHeight = 5;
        public int minimumWidth = 0;
        public int minimumHeight = 0;

        public PageContainerFillLayout(int mw, int mh, int minW, int minH) {
            this.marginWidth = mw;
            this.marginHeight = mh;
            this.minimumWidth = minW;
            this.minimumHeight = minH;
        }

        @Override
        public Point computeSize(Composite composite, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point result = null;
            Control[] children = composite.getChildren();
            if (children.length > 0) {
                result = new Point(0, 0);
                for (int i = 0; i < children.length; ++i) {
                    Point cp = children[i].computeSize(wHint, hHint, force);
                    result.x = Math.max(result.x, cp.x);
                    result.y = Math.max(result.y, cp.y);
                }
                result.x += 2 * this.marginWidth;
                result.y += 2 * this.marginHeight;
            } else {
                Rectangle rect = composite.getClientArea();
                result = new Point(rect.width, rect.height);
            }
            result.x = Math.max(result.x, this.minimumWidth);
            result.y = Math.max(result.y, this.minimumHeight);
            if (wHint != -1) {
                result.x = wHint;
            }
            if (hHint != -1) {
                result.y = hHint;
            }
            return result;
        }

        public Rectangle getClientArea(Composite c) {
            Rectangle rect = c.getClientArea();
            rect.x += this.marginWidth;
            rect.y += this.marginHeight;
            rect.width -= 2 * this.marginWidth;
            rect.height -= 2 * this.marginHeight;
            return rect;
        }

        @Override
        public void layout(Composite composite, boolean force) {
            Rectangle rect = this.getClientArea(composite);
            Control[] children = composite.getChildren();
            for (int i = 0; i < children.length; ++i) {
                children[i].setBounds(rect);
            }
        }

        public void layoutPage(Control w) {
            w.setBounds(this.getClientArea(w.getParent()));
        }

        public void setPageLocation(Control w) {
            w.setLocation(this.marginWidth, this.marginHeight);
        }
    }
}

