/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.ui;

import com.salesforce.dataloader.action.OperationInfo;
import com.salesforce.dataloader.config.Config;
import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.ui.Labels;
import com.salesforce.dataloader.ui.LoaderTitleDialog;
import com.salesforce.dataloader.ui.UIUtils;
import com.salesforce.dataloader.ui.uiActions.AdvancedSettingsUIAction;
import com.salesforce.dataloader.ui.uiActions.ExitUIAction;
import com.salesforce.dataloader.ui.uiActions.HelpUIAction;
import com.salesforce.dataloader.ui.uiActions.LogoutUIAction;
import com.salesforce.dataloader.ui.uiActions.OperationUIAction;
import com.salesforce.dataloader.ui.uiActions.ViewCSVFileAction;
import java.util.EnumMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class LoaderWindow
extends ApplicationWindow {
    private final TreeMap<Integer, OperationUIAction> operationActionsByIndex;
    private final EnumMap<OperationInfo, Button> operationButtonsByIndex = new EnumMap(OperationInfo.class);
    private final ExitUIAction uiActionExit;
    private final ViewCSVFileAction uiActionViewSuccess;
    private final HelpUIAction uiActionHelp;
    private final AdvancedSettingsUIAction uiActionSettings;
    private final LogoutUIAction uiActionLogout;
    private final Controller controller;
    private static LoaderWindow app;

    private TreeMap<Integer, OperationUIAction> createActionMap(Controller controller) {
        TreeMap<Integer, OperationUIAction> map = new TreeMap<Integer, OperationUIAction>();
        for (OperationInfo info : OperationInfo.values()) {
            map.put(info.getDialogIdx(), info.createUIAction(controller));
        }
        return map;
    }

    public LoaderWindow(Controller controller) {
        super((Shell)null);
        Display.getDefault();
        this.operationActionsByIndex = this.createActionMap(controller);
        this.uiActionExit = new ExitUIAction();
        this.uiActionViewSuccess = new ViewCSVFileAction(controller);
        this.uiActionSettings = new AdvancedSettingsUIAction(controller);
        this.uiActionHelp = new HelpUIAction(controller);
        this.uiActionLogout = new LogoutUIAction(controller);
        app = this;
        this.addMenuBar();
        this.addStatusLine();
        controller.getConfig().initLastRunFile();
        this.controller = controller;
        Config.ConfigListener listener = new Config.ConfigListener(){

            @Override
            public void configValueChanged(String key, String oldValue, String newValue) {
                if ("sfdc.useBulkApi".equals(key)) {
                    boolean boolVal = false;
                    if (newValue != null) {
                        boolVal = Boolean.valueOf(newValue);
                    }
                    LoaderWindow.this.operationButtonsByIndex.get((Object)OperationInfo.hard_delete).setEnabled(boolVal);
                    LoaderWindow.this.operationActionsByIndex.get(OperationInfo.hard_delete.getDialogIdx()).setEnabled(boolVal);
                    LoaderWindow.this.getShell().redraw();
                }
            }
        };
        this.controller.getConfig().addListener(listener);
    }

    public void dispose() {
        if (this.controller != null) {
            this.controller.saveConfig();
        }
    }

    public static LoaderWindow getApp() {
        return app;
    }

    public Controller getController() {
        return this.controller;
    }

    public void run() {
        this.setBlockOnOpen(true);
        this.open();
        Display.getCurrent().dispose();
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Labels.getString("LoaderWindow.title"));
        shell.setSize(600, 400);
        shell.setImage(UIUtils.getImageRegistry().get("sfdc_icon"));
    }

    private OperationUIAction getOperationAction(int i) {
        return this.operationActionsByIndex.get(i);
    }

    @Override
    protected Control createContents(Composite parent) {
        Composite comp = this.createContainer(parent);
        this.createButtons(comp);
        this.getStatusLineManager().setMessage(Labels.getString("LoaderWindow.chooseAction"));
        Config config = this.controller.getConfig();
        if (!config.getBoolean("loader.hideWelcome")) {
            this.displayTitleDialog(Display.getDefault(), this.operationActionsByIndex, this.controller.getConfig());
        }
        comp.pack();
        parent.pack();
        return parent;
    }

    private Composite createContainer(Composite parent) {
        Composite comp = new Composite(parent, 2048);
        this.setBackground(comp);
        comp.setLayout(new FillLayout(512));
        Label label = new Label(comp, 0x1000000);
        this.setBackground(label);
        label.setImage(UIUtils.getImageRegistry().get("title_logo"));
        comp.pack();
        return comp;
    }

    private void setBackground(Control comp) {
        comp.setBackground(new Color(Display.getCurrent(), 238, 241, 246));
    }

    private void createButtons(Composite parent) {
        Composite buttons = new Composite(parent, 0);
        this.setBackground(buttons);
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.wrap = true;
        rowLayout.pack = false;
        rowLayout.justify = false;
        rowLayout.marginLeft = 10;
        rowLayout.marginRight = 10;
        rowLayout.marginTop = 15;
        rowLayout.marginBottom = 15;
        rowLayout.spacing = 5;
        buttons.setLayout(rowLayout);
        for (OperationInfo info : OperationInfo.ALL_OPERATIONS_IN_ORDER) {
            this.createOperationButton(buttons, info);
        }
    }

    private void createOperationButton(Composite parent, OperationInfo info) {
        Button butt = new Button(parent, 0x800008);
        butt.setText(info.getLabel());
        butt.setEnabled(info.isOperationAllowed(this.controller.getConfig()));
        butt.setImage(info.getIconImage());
        butt.setBackground(Display.getCurrent().getSystemColor(1));
        butt.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                info.createUIAction(LoaderWindow.this.getController()).run();
            }
        });
        this.operationButtonsByIndex.put(info, butt);
    }

    private void displayTitleDialog(Display display, TreeMap<Integer, OperationUIAction> map, Config cfg) {
        display.asyncExec(new Thread(){

            @Override
            public void run() {
                LoaderTitleDialog dlg = new LoaderTitleDialog(display.getActiveShell(), cfg);
                int result = dlg.open();
                for (Map.Entry ent : map.entrySet()) {
                    if (result != (Integer)ent.getKey()) continue;
                    ((OperationUIAction)ent.getValue()).run();
                }
            }
        });
    }

    @Override
    protected MenuManager createMenuManager() {
        MenuManager mm = new MenuManager();
        MenuManager fileMenu = new MenuManager(Labels.getString("LoaderWindow.file"));
        mm.add(fileMenu);
        for (OperationInfo info : OperationInfo.ALL_OPERATIONS_IN_ORDER) {
            fileMenu.add(this.getOperationAction(info.getDialogIdx()));
        }
        fileMenu.add(this.uiActionLogout);
        fileMenu.add(new Separator());
        fileMenu.add(this.uiActionExit);
        MenuManager settingsMenu = new MenuManager(Labels.getString("LoaderWindow.settings"));
        settingsMenu.add(this.uiActionSettings);
        mm.add(settingsMenu);
        MenuManager viewMenu = new MenuManager(Labels.getString("LoaderWindow.view"));
        mm.add(viewMenu);
        viewMenu.add(this.uiActionViewSuccess);
        MenuManager helpMenu = new MenuManager(Labels.getString("LoaderWindow.help"));
        helpMenu.add(this.uiActionHelp);
        mm.add(helpMenu);
        return mm;
    }
}

