/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.ui;

import com.salesforce.dataloader.action.OperationInfo;
import com.salesforce.dataloader.config.Config;
import com.salesforce.dataloader.ui.Labels;
import com.salesforce.dataloader.ui.LoaderTitleAreaDialog;
import com.salesforce.dataloader.ui.UIUtils;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class LoaderTitleDialog
extends LoaderTitleAreaDialog {
    private final Config config;

    public LoaderTitleDialog(Shell activeShell, Config cfg) {
        super(activeShell);
        this.config = cfg;
    }

    @Override
    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(Labels.getString("TitleDialog.title"));
        this.setMessage(Labels.getString("TitleDialog.messageLineOne") + System.getProperty("line.separator") + Labels.getString("TitleDialog.messageLineTwo"));
        this.setTitleImage(UIUtils.getImageRegistry().get("splashscreens"));
        return contents;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        return composite;
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        for (OperationInfo info : OperationInfo.ALL_OPERATIONS_IN_ORDER) {
            Button butt = this.createButton(parent, info.getDialogIdx(), info.getLabel(), false);
            butt.setEnabled(info.isOperationAllowed(this.config));
            Image img = info.getIconImage();
            butt.setImage(img);
            GridData gd = (GridData)butt.getLayoutData();
            gd.grabExcessHorizontalSpace = true;
            gd.widthHint += img.getImageData().width;
            butt.setLayoutData(gd);
        }
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
    }

    @Override
    protected void buttonPressed(int buttonID) {
        this.setReturnCode(buttonID);
        this.close();
    }
}

