/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.ui;

import com.salesforce.dataloader.action.OperationInfo;
import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.exception.ProcessInitializationException;
import com.salesforce.dataloader.ui.BaseWizard;
import com.salesforce.dataloader.ui.DataSelectionPage;
import com.salesforce.dataloader.ui.ExternalIdPage;
import com.salesforce.dataloader.ui.FinishPage;
import com.salesforce.dataloader.ui.ForeignKeyExternalIdPage;
import com.salesforce.dataloader.ui.HardDeleteFinishPage;
import com.salesforce.dataloader.ui.Labels;
import com.salesforce.dataloader.ui.MappingPage;
import com.salesforce.dataloader.ui.SWTLoadRunable;
import com.salesforce.dataloader.ui.SettingsPage;
import com.salesforce.dataloader.ui.UIUtils;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;

public abstract class LoadWizard
extends BaseWizard {
    private static final Logger logger = Logger.getLogger(LoadWizard.class);

    public LoadWizard(Controller controller, OperationInfo operation) {
        super(controller, operation);
    }

    protected boolean wizardhook_validateFinish() {
        return true;
    }

    @Override
    public boolean canFinish() {
        return super.canFinish() && this.getFinishPage().finishAllowed();
    }

    @Override
    public boolean performFinish() {
        String outputDirName = this.getFinishPage().getOutputDir();
        File statusDir = new File(outputDirName);
        if (!statusDir.exists() || !statusDir.isDirectory()) {
            UIUtils.errorMessageBox(this.getShell(), Labels.getString("LoadWizard.errorValidDirectory"));
            return false;
        }
        try {
            this.getController().setStatusFiles(outputDirName, false, true);
            this.getController().saveConfig();
        }
        catch (ProcessInitializationException e) {
            UIUtils.errorMessageBox(this.getShell(), e);
            return false;
        }
        int val = UIUtils.warningConfMessageBox(this.getShell(), this.getConfirmationText());
        if (val != 64) {
            return false;
        }
        if (!this.wizardhook_validateFinish()) {
            return false;
        }
        try {
            ProgressMonitorDialog dlg = new ProgressMonitorDialog(this.getShell());
            dlg.run(true, true, new SWTLoadRunable(this.getController()));
        }
        catch (InvocationTargetException e) {
            logger.error(Labels.getString("LoadWizard.errorAction"), e);
            UIUtils.errorMessageBox(this.getShell(), e.getCause() != null ? e.getCause() : e);
            return false;
        }
        catch (InterruptedException e) {
            logger.error(Labels.getString("LoadWizard.errorAction"), e);
            UIUtils.errorMessageBox(this.getShell(), e.getCause() != null ? e.getCause() : e);
            return false;
        }
        return true;
    }

    @Override
    protected FinishPage setPages() {
        Controller controller = this.getController();
        this.addPage(new DataSelectionPage(controller));
        this.hook_additionalLoadWizardPages();
        this.addPage(new MappingPage(controller));
        FinishPage finishPage = this.createFinishPage();
        this.addPage(finishPage);
        return finishPage;
    }

    @Override
    protected SettingsPage createSettingsPage() {
        return new SettingsPage(this.getController());
    }

    protected FinishPage createFinishPage() {
        return new FinishPage(this.getController());
    }

    @Override
    protected FinishPage getFinishPage() {
        return (FinishPage)super.getFinishPage();
    }

    protected void hook_additionalLoadWizardPages() {
    }

    private String getConfirmationText() {
        return this.getLabel("confFirstLine") + System.getProperty("line.separator") + this.getLabel("confSecondLine");
    }

    public static final class InsertWizard
    extends LoadWizard {
        public InsertWizard(Controller controller) {
            super(controller, OperationInfo.insert);
        }
    }

    public static final class UpsertWizard
    extends LoadWizard {
        public UpsertWizard(Controller controller) {
            super(controller, OperationInfo.upsert);
        }

        @Override
        protected void hook_additionalLoadWizardPages() {
            super.hook_additionalLoadWizardPages();
            this.addPage(new ExternalIdPage(this.getController()));
            this.addPage(new ForeignKeyExternalIdPage(this.getController()));
        }
    }

    public static final class UpdateWizard
    extends LoadWizard {
        public UpdateWizard(Controller controller) {
            super(controller, OperationInfo.update);
        }
    }

    public static final class HardDeleteWizard
    extends LoadWizard {
        public HardDeleteWizard(Controller controller) {
            super(controller, OperationInfo.hard_delete);
        }

        @Override
        protected HardDeleteFinishPage createFinishPage() {
            return new HardDeleteFinishPage(this.getController());
        }
    }

    public static final class DeleteWizard
    extends LoadWizard {
        public DeleteWizard(Controller controller) {
            super(controller, OperationInfo.delete);
        }

        @Override
        public boolean wizardhook_validateFinish() {
            int button = UIUtils.warningConfMessageBox(this.getShell(), this.getLabel("validateFirstLine") + System.getProperty("line.separator") + this.getLabel("validateSecondLine"));
            return button == 64;
        }
    }
}

