/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.ui;

import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.exception.DataAccessObjectInitializationException;
import com.salesforce.dataloader.ui.CSVViewerDialog;
import com.salesforce.dataloader.ui.Labels;
import com.salesforce.dataloader.ui.UIUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class LoadFinishDialog
extends Dialog {
    private String message;
    private Label label;
    private Controller controller;
    private Button ok;

    public LoadFinishDialog(Shell parent, Controller controller) {
        this(parent, 67696);
        this.controller = controller;
    }

    public LoadFinishDialog(Shell parent, int style) {
        super(parent, style);
        this.setText(Labels.getString("LoadFinishDialog.title"));
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean open() {
        Shell shell = new Shell(this.getParent(), this.getStyle());
        shell.setText(this.getText());
        shell.setImage(UIUtils.getImageRegistry().get("sfdc_icon"));
        this.createContents(shell);
        shell.pack();
        shell.open();
        Display display = this.getParent().getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return true;
    }

    private void createContents(Shell shell) {
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 10;
        layout.marginHeight = 20;
        shell.setLayout(layout);
        Label labelInfo = new Label(shell, 0);
        labelInfo.setImage(UIUtils.getImageRegistry().get("info"));
        GridData data = new GridData();
        labelInfo.setLayoutData(data);
        this.label = new Label(shell, 0);
        this.label.setText(this.message);
        data = new GridData(34);
        this.label.setLayoutData(data);
        Label labelSeparatorBottom = new Label(shell, 258);
        data = new GridData(768);
        data.horizontalSpan = 2;
        data.widthHint = 350;
        labelSeparatorBottom.setLayoutData(data);
        Composite buttonComp = new Composite(shell, 0);
        data = new GridData(128);
        data.horizontalSpan = 2;
        buttonComp.setLayoutData(data);
        layout = new GridLayout(3, false);
        buttonComp.setLayout(layout);
        Button viewSuccess = new Button(buttonComp, 0x800008);
        viewSuccess.setText(Labels.getString("LoadFinishDialog.viewSuccess"));
        viewSuccess.setLayoutData(new GridData(128));
        viewSuccess.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                LoadFinishDialog.this.openViewer(LoadFinishDialog.this.controller.getConfig().getString("process.outputSuccess"));
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button viewErrors = new Button(buttonComp, 0x800008);
        viewErrors.setLayoutData(new GridData(128));
        viewErrors.setText(Labels.getString("LoadFinishDialog.viewErrors"));
        viewErrors.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                LoadFinishDialog.this.openViewer(LoadFinishDialog.this.controller.getConfig().getString("process.outputError"));
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.ok = new Button(buttonComp, 0x800008);
        this.ok.setText(Labels.getString("UI.ok"));
        this.ok.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                shell.close();
            }
        });
        data = new GridData(128);
        data.widthHint = 75;
        this.ok.setLayoutData(data);
        shell.setDefaultButton(this.ok);
    }

    private void openViewer(String filename) {
        CSVViewerDialog dlg = new CSVViewerDialog(this.getParent(), this.controller);
        dlg.setNumberOfRows(200000);
        dlg.setFileName(filename);
        dlg.setUseCustomSplitter(false);
        try {
            dlg.open();
        }
        catch (DataAccessObjectInitializationException e) {
            UIUtils.errorMessageBox(this.getParent(), e);
        }
    }
}

