/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.ui;

import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.ui.Hyperlink;
import com.salesforce.dataloader.ui.UIUtils;
import com.salesforce.dataloader.util.StreamGobbler;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class HyperlinkDialog
extends Dialog {
    private String boldMessage;
    private String message;
    private String linkText;
    private String linkURL;
    private Logger logger = Logger.getLogger(HyperlinkDialog.class);
    private Text messageLabel;
    private Label titleLabel;
    private Label titleImage;
    private Label titleBanner;
    private Hyperlink link;

    public String getLinkURL() {
        return this.linkURL;
    }

    public void setLinkURL(String linkURL) {
        this.linkURL = linkURL;
    }

    public HyperlinkDialog(Shell parent, Controller controller) {
        this(parent, 67696);
    }

    public HyperlinkDialog(Shell parent, int style) {
        super(parent, style);
    }

    public boolean open() {
        Shell shell = new Shell(this.getParent(), this.getStyle());
        shell.setText(this.getText());
        shell.setImage(UIUtils.getImageRegistry().get("sfdc_icon"));
        this.createContents(shell);
        shell.pack();
        shell.open();
        Display display = this.getParent().getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return true;
    }

    private void createContents(Shell shell) {
        FormLayout layout = new FormLayout();
        shell.setLayout(layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        shell.setLayoutData(data);
        Color background = JFaceColors.getBannerBackground(shell.getDisplay());
        Color foreground = JFaceColors.getBannerForeground(shell.getDisplay());
        shell.setBackground(background);
        this.titleImage = new Label(shell, 0x1000000);
        this.titleImage.setBackground(background);
        this.titleImage.setImage(UIUtils.getImageRegistry().get("splashscreens"));
        FormData imageData = new FormData();
        imageData.top = new FormAttachment(0, 10);
        imageData.right = new FormAttachment(100, 0);
        this.titleImage.setLayoutData(imageData);
        this.titleBanner = new Label(shell, 16384);
        this.titleBanner.setBackground(background);
        this.titleBanner.setImage(UIUtils.getImageRegistry().get("logo"));
        FormData bannerData = new FormData();
        bannerData.top = new FormAttachment(0, 10);
        bannerData.right = new FormAttachment(this.titleImage);
        bannerData.left = new FormAttachment(0, 10);
        this.titleBanner.setLayoutData(bannerData);
        this.titleLabel = new Label(shell, 16384);
        this.titleLabel.setForeground(foreground);
        this.titleLabel.setBackground(background);
        this.titleLabel.setFont(JFaceResources.getBannerFont());
        this.titleLabel.setText(this.boldMessage);
        FormData titleData = new FormData();
        titleData.top = new FormAttachment(this.titleBanner, 10);
        titleData.right = new FormAttachment(this.titleImage);
        titleData.left = new FormAttachment(0, 10);
        this.titleLabel.setLayoutData(titleData);
        this.messageLabel = new Text(shell, 72);
        this.messageLabel.setForeground(foreground);
        this.messageLabel.setBackground(background);
        this.messageLabel.setText(this.message);
        this.messageLabel.setFont(JFaceResources.getDialogFont());
        FormData messageLabelData = new FormData();
        messageLabelData.top = new FormAttachment(this.titleLabel, 10);
        messageLabelData.right = new FormAttachment(this.titleImage);
        messageLabelData.left = new FormAttachment(0, 10);
        this.messageLabel.setLayoutData(messageLabelData);
        this.link = new Hyperlink(shell, 0);
        this.link.setText(this.getLinkText());
        this.link.setBackground(background);
        this.link.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                Thread runner = new Thread(){

                    @Override
                    public void run() {
                        int exitVal = 0;
                        try {
                            Process proc = null;
                            if (System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0) {
                                proc = Runtime.getRuntime().exec("rundll32 url.dll, FileProtocolHandler " + HyperlinkDialog.this.getLinkURL());
                            } else if (System.getProperty("os.name").toLowerCase().indexOf("mac") >= 0) {
                                Desktop desktop = Desktop.getDesktop();
                                try {
                                    desktop.browse(new URI(HyperlinkDialog.this.getLinkURL()));
                                }
                                catch (URISyntaxException e) {
                                    HyperlinkDialog.this.logger.error("Browser Error");
                                }
                            } else {
                                HyperlinkDialog.this.logger.error("OS is not supported.");
                                return;
                            }
                            StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "ERROR");
                            StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "OUTPUT");
                            errorGobbler.start();
                            outputGobbler.start();
                            exitVal = proc.waitFor();
                        }
                        catch (IOException iox) {
                            HyperlinkDialog.this.logger.error("Browser Error", iox);
                        }
                        catch (InterruptedException ie) {
                            HyperlinkDialog.this.logger.error("Browser Error", ie);
                        }
                        if (exitVal != 0) {
                            HyperlinkDialog.this.logger.error("Process exited with error" + exitVal);
                        }
                    }
                };
                runner.setPriority(10);
                runner.start();
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        FormData linkData = new FormData();
        linkData.top = new FormAttachment(this.messageLabel);
        linkData.right = new FormAttachment(this.titleImage);
        linkData.left = new FormAttachment(0, 10);
        this.link.setLayoutData(linkData);
        Composite greyArea = new Composite(shell, 0);
        GridLayout childLayout = new GridLayout(1, false);
        childLayout.marginHeight = 0;
        childLayout.marginWidth = 0;
        childLayout.verticalSpacing = 0;
        childLayout.horizontalSpacing = 0;
        greyArea.setLayout(childLayout);
        FormData childData = new FormData();
        childData.top = new FormAttachment(this.link, 5);
        childData.right = new FormAttachment(100, 0);
        childData.left = new FormAttachment(0, 0);
        childData.bottom = new FormAttachment(100, 0);
        greyArea.setLayoutData(childData);
        Label titleBarSeparator = new Label(greyArea, 258);
        titleBarSeparator.setLayoutData(new GridData(768));
        Composite compositeX = new Composite(greyArea, 0);
        GridLayout layoutComp = new GridLayout();
        layoutComp.marginWidth = 10;
        layoutComp.marginHeight = 10;
        layoutComp.horizontalSpacing = 10;
        layoutComp.verticalSpacing = 10;
        compositeX.setLayout(layoutComp);
        GridData dataComp = new GridData(132);
        compositeX.setLayoutData(dataComp);
        Button ok = new Button(compositeX, 0x800008);
        ok.setText(IDialogConstants.OK_LABEL);
        GridData okData = new GridData();
        okData.widthHint = Math.max(75, ok.computeSize((int)-1, (int)-1, (boolean)true).x);
        ok.setLayoutData(okData);
        ok.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                shell.close();
            }
        });
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getBoldMessage() {
        return this.boldMessage;
    }

    public void setBoldMessage(String message) {
        this.boldMessage = message;
    }

    public String getLinkText() {
        return this.linkText;
    }

    public void setLinkText(String linkText) {
        this.linkText = linkText;
    }
}

