/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.ui;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;

public final class Hyperlink
extends Canvas {
    private String text = "";
    private Cursor handCursor = new Cursor(this.getDisplay(), 21);
    private Cursor arrowCursor = new Cursor(this.getDisplay(), 0);
    private Color normalForeground;
    private Color activeForeground;
    private Color hoverForeground;
    private Color normalUnderline;
    private Color activeUndeline;
    private Color hoverUnderline;
    private boolean isActive;
    private boolean cursorInControl;
    private Rectangle cachedClientArea;
    private Listener shellListener;
    private Shell shell;
    private int mnemonic = -1;

    public Hyperlink(Composite parent, int style) {
        super(parent, Hyperlink.checkStyle(style));
        Composite shellComp;
        this.setCursor(this.handCursor);
        this.hoverForeground = this.normalForeground = this.getDisplay().getSystemColor(9);
        this.activeForeground = this.getDisplay().getSystemColor(3);
        this.normalUnderline = null;
        this.hoverUnderline = this.normalForeground;
        this.activeUndeline = this.activeForeground;
        super.setForeground(this.normalForeground);
        this.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent event) {
                Hyperlink.this.onPaint(event);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent e) {
                if (Hyperlink.this.handCursor != null) {
                    Hyperlink.this.handCursor.dispose();
                    Hyperlink.this.handCursor = null;
                }
                if (Hyperlink.this.arrowCursor != null) {
                    Hyperlink.this.arrowCursor.dispose();
                    Hyperlink.this.arrowCursor = null;
                }
                if (Hyperlink.this.shellListener != null) {
                    Hyperlink.this.shell.removeListener(26, Hyperlink.this.shellListener);
                    Hyperlink.this.shell.removeListener(27, Hyperlink.this.shellListener);
                    Hyperlink.this.shellListener = null;
                }
                Hyperlink.this.text = null;
            }
        });
        this.addListener(3, new Listener(){

            @Override
            public void handleEvent(Event event) {
                Hyperlink.this.isActive = true;
                Hyperlink.this.cursorInControl = true;
                Hyperlink.this.redraw();
            }
        });
        this.addListener(4, new Listener(){

            @Override
            public void handleEvent(Event event) {
                Hyperlink.this.isActive = false;
                Hyperlink.this.redraw();
                if (Hyperlink.this.cursorInControl) {
                    Hyperlink.this.linkActivated();
                }
            }
        });
        this.addListener(11, new Listener(){

            @Override
            public void handleEvent(Event event) {
                Hyperlink.this.cachedClientArea = Hyperlink.this.getClientArea();
            }
        });
        Listener mouseListener = new Listener(){

            @Override
            public void handleEvent(Event event) {
                boolean newCursorInControl = Hyperlink.this.isInClientArea(event);
                if (Hyperlink.this.cursorInControl != newCursorInControl) {
                    Hyperlink.this.cursorInControl = newCursorInControl;
                    if (Hyperlink.this.cursorInControl) {
                        Hyperlink.this.setCursor(Hyperlink.this.handCursor);
                    } else if (Hyperlink.this.isActive) {
                        Hyperlink.this.setCursor(Hyperlink.this.arrowCursor);
                    }
                    if (Hyperlink.this.isActive || Hyperlink.this.normalForeground != Hyperlink.this.hoverForeground || Hyperlink.this.normalUnderline != Hyperlink.this.hoverUnderline) {
                        Hyperlink.this.redraw();
                    }
                }
            }
        };
        this.addListener(5, mouseListener);
        this.addListener(6, mouseListener);
        this.addListener(7, mouseListener);
        this.cachedClientArea = this.getClientArea();
        if ((style & 0x80000) == 0) {
            this.addListener(1, new Listener(){

                @Override
                public void handleEvent(Event event) {
                    if (event.character == ' ') {
                        Hyperlink.this.linkActivated();
                    }
                }
            });
            this.addListener(31, new Listener(){

                @Override
                public void handleEvent(Event event) {
                    if (event.detail == 4) {
                        Hyperlink.this.linkActivated();
                        event.doit = false;
                    } else if (event.detail == 128) {
                        if (Hyperlink.this.mnemonic != -1 && Character.toLowerCase(event.character) == Hyperlink.this.mnemonic) {
                            Hyperlink.this.setFocus();
                            Hyperlink.this.linkActivated();
                            event.doit = false;
                        } else {
                            event.doit = true;
                        }
                    } else {
                        event.doit = true;
                    }
                }
            });
            this.addListener(15, new Listener(){

                @Override
                public void handleEvent(Event event) {
                    Hyperlink.this.redraw();
                }
            });
            this.addListener(16, new Listener(){

                @Override
                public void handleEvent(Event event) {
                    Hyperlink.this.redraw();
                }
            });
        } else {
            this.addListener(31, new Listener(){

                @Override
                public void handleEvent(Event event) {
                    if (event.detail == 128 && Hyperlink.this.mnemonic != -1 && Character.toLowerCase(event.character) == Hyperlink.this.mnemonic) {
                        Hyperlink.this.linkActivated();
                        event.doit = false;
                    }
                }
            });
        }
        for (shellComp = this.getParent(); shellComp != null && !(shellComp instanceof Shell); shellComp = shellComp.getParent()) {
        }
        this.shell = (Shell)shellComp;
        if (this.shell != null) {
            this.shellListener = new Listener(){

                @Override
                public void handleEvent(Event event) {
                    boolean newCursorInControl;
                    boolean bl = newCursorInControl = Hyperlink.this.getDisplay().getCursorControl() == Hyperlink.this;
                    if (Hyperlink.this.cursorInControl != newCursorInControl) {
                        Hyperlink.this.cursorInControl = newCursorInControl;
                        if (Hyperlink.this.cursorInControl) {
                            Hyperlink.this.setCursor(Hyperlink.this.handCursor);
                        } else if (Hyperlink.this.isActive) {
                            Hyperlink.this.setCursor(Hyperlink.this.arrowCursor);
                        }
                        if (Hyperlink.this.isActive || Hyperlink.this.normalForeground != Hyperlink.this.hoverForeground || Hyperlink.this.normalUnderline != Hyperlink.this.hoverUnderline) {
                            Hyperlink.this.redraw();
                        }
                    }
                }
            };
            this.shell.addListener(26, this.shellListener);
            this.shell.addListener(27, this.shellListener);
        }
    }

    private void linkActivated() {
        Event e = new Event();
        e.widget = this;
        e.type = 13;
        this.notifyListeners(13, e);
    }

    private boolean isInClientArea(Event event) {
        return event.x >= this.cachedClientArea.x && event.x < this.cachedClientArea.x + this.cachedClientArea.width && event.y >= this.cachedClientArea.y && event.y < this.cachedClientArea.y + this.cachedClientArea.height;
    }

    @Override
    public boolean isReparentable() {
        this.checkWidget();
        return false;
    }

    private static int checkStyle(int style) {
        style &= 0x80000;
        String platform = SWT.getPlatform();
        if ("carbon".equals(platform) || "gtk".equals(platform)) {
            return style;
        }
        return style | 0x40000;
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point e = this.getTotalSize(this.text);
        if (wHint != -1) {
            e.x = wHint;
        }
        if (hHint != -1) {
            e.y = hHint;
        }
        return e;
    }

    private Point getTotalSize(String text) {
        Point size = new Point(0, 0);
        GC gc = new GC(this);
        if (text != null && text.length() > 0) {
            Point e = gc.textExtent(text, 8);
            size.x += e.x;
            size.y = Math.max(size.y, e.y);
        } else {
            size.y = Math.max(size.y, gc.getFontMetrics().getHeight());
        }
        gc.dispose();
        return size;
    }

    public String getText() {
        return this.text;
    }

    private void onPaint(PaintEvent event) {
        int lineWidth;
        Color lineFG;
        Color textFG;
        Rectangle rect = this.cachedClientArea;
        if (rect.width == 0 || rect.height == 0) {
            return;
        }
        Point extent = this.getTotalSize(this.text);
        GC gc = event.gc;
        if ((this.getStyle() & 0x40000) != 0) {
            gc.setBackground(this.getBackground());
            gc.fillRectangle(rect);
        }
        if (this.isFocusControl()) {
            gc.drawFocus(rect.x, rect.y, rect.width, rect.height);
        }
        if (this.cursorInControl) {
            textFG = this.isActive ? this.activeForeground : this.hoverForeground;
            lineFG = this.isActive ? this.activeUndeline : this.hoverUnderline;
        } else {
            textFG = this.normalForeground;
            lineFG = this.normalUnderline;
        }
        if (textFG == null) {
            textFG = this.normalForeground;
        }
        if (textFG == null) {
            textFG = this.getDisplay().getSystemColor(21);
        }
        int textHeight = gc.getFontMetrics().getHeight();
        gc.setForeground(textFG);
        gc.drawText(this.text, rect.x, rect.y + (rect.height - textHeight) / 2, 9);
        int uy = rect.y + (rect.height - textHeight) / 2 + gc.getFontMetrics().getAscent() + gc.getFontMetrics().getLeading() + 1;
        int n = lineWidth = extent.x > rect.width ? rect.width : extent.x;
        if (lineFG != null) {
            if (lineFG != textFG) {
                gc.setForeground(lineFG);
            }
            gc.drawLine(rect.x, uy, rect.x + lineWidth, uy);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.normalForeground = color;
        this.redraw();
    }

    public void setHoverForeground(Color color) {
        this.hoverForeground = color;
        this.redraw();
    }

    public void setActiveForeground(Color color) {
        this.activeForeground = color;
        this.redraw();
    }

    public void setUnderline(Color color) {
        this.normalUnderline = color;
        this.redraw();
    }

    public void setHoverUnderline(Color color) {
        this.hoverUnderline = color;
        this.redraw();
    }

    public void setActiveUnderline(Color color) {
        this.activeUndeline = color;
        this.redraw();
    }

    public Color getHoverForeground() {
        return this.hoverForeground;
    }

    public Color getActiveForeground() {
        return this.activeForeground;
    }

    public Color getUnderline() {
        return this.normalUnderline;
    }

    public Color getHoverUnderline() {
        return this.hoverUnderline;
    }

    public Color getActiveUnderline() {
        return this.activeUndeline;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.redraw();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.redraw();
    }

    public void setText(String text) {
        this.checkWidget();
        if (text == null) {
            text = "";
        }
        if (!text.equals(this.text)) {
            this.text = text;
            int i = text.indexOf(38);
            this.mnemonic = i == -1 || i == text.length() - 1 ? -1 : (int)Character.toLowerCase(text.charAt(i + 1));
            this.redraw();
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(13, listener);
        this.removeListener(14, listener);
    }
}

