/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.ui;

import com.salesforce.dataloader.action.OperationInfo;
import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.ui.BaseWizard;
import com.salesforce.dataloader.ui.FinishPage;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class HardDeleteFinishPage
extends FinishPage {
    private final AtomicBoolean canFinish = new AtomicBoolean(false);

    public HardDeleteFinishPage(Controller controller) {
        super(controller);
    }

    private void setCanFinish(boolean selection) {
        this.canFinish.set(selection);
        this.getContainer().updateButtons();
    }

    @Override
    protected void hook_createControl(Composite comp) {
        super.hook_createControl(comp);
        if (this.getController().getConfig().getOperationInfo() == OperationInfo.hard_delete) {
            Composite terms = new Composite(comp, 0);
            GridLayout layout = new GridLayout(1, false);
            terms.setLayout(layout);
            GridData gd = new GridData();
            gd.horizontalAlignment = 3;
            gd.grabExcessVerticalSpace = true;
            gd.grabExcessHorizontalSpace = true;
            gd.verticalAlignment = 3;
            terms.setLayoutData(gd);
            BaseWizard wiz = (BaseWizard)this.getWizard();
            Label label = new Label(terms, 131072);
            label.setForeground(new Color(label.getDisplay(), 255, 0, 0));
            label.setText(wiz.getLabel("finishMessage"));
            Button b = new Button(terms, 32);
            b.setText(wiz.getLabel("finishMessageConfirm"));
            b.setSelection(this.canFinish.get());
            b.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent se) {
                    HardDeleteFinishPage.this.setCanFinish(((Button)se.widget).getSelection());
                }
            });
        }
    }

    @Override
    public boolean finishAllowed() {
        return super.finishAllowed() && this.canFinish.get();
    }
}

