/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.ui;

import java.util.ArrayList;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class Grid12 {
    private Composite composite;
    private final int columnWidth;
    private final int cellHeight;
    private final GridLayout root;
    private boolean grabExcessHorizontalSpace;
    private boolean grabExcessVerticalSpace;

    public Grid12(Composite composite, int columnWidth) {
        this(composite, columnWidth, -1);
    }

    public Grid12(Composite composite, int columnWidth, int cellHeight) {
        this(composite, columnWidth, cellHeight, false, true);
    }

    public Grid12(Composite composite, int columnWidth, int cellHeight, boolean grabExcessVerticalSpace, boolean grabExcessHorizontalSpace) {
        this.composite = composite;
        this.columnWidth = columnWidth;
        this.cellHeight = cellHeight;
        this.root = new GridLayout(12, true);
        this.composite.setLayout(this.root);
        this.grabExcessVerticalSpace = grabExcessVerticalSpace;
        this.grabExcessHorizontalSpace = grabExcessHorizontalSpace;
    }

    public GridLayout getRoot() {
        return this.root;
    }

    public GridData createCell(int columnSpan) {
        return this.createCell(columnSpan, 4);
    }

    public GridData createCell(int columnSpan, int horizontalAlignment) {
        GridData data = new GridData();
        data.horizontalSpan = columnSpan;
        data.widthHint = columnSpan * this.columnWidth;
        data.horizontalAlignment = horizontalAlignment;
        data.heightHint = this.cellHeight;
        data.grabExcessHorizontalSpace = this.grabExcessHorizontalSpace;
        data.grabExcessVerticalSpace = this.grabExcessVerticalSpace;
        return data;
    }

    public int getColumnWidth() {
        return this.columnWidth;
    }

    public int getCellHeight() {
        return this.cellHeight;
    }

    public Label createLabel(int columns, String message) {
        return this.createLabel(columns, message, 131072);
    }

    public Label createLabel(int columns, String message, int style) {
        Label label = new Label(this.composite, style);
        label.setText(message);
        label.setLayoutData(this.createCell(columns));
        this.applyFormatting(label);
        return label;
    }

    public Label createImage(int columns, Image image) {
        return this.createImage(columns, image, 131072, 131072);
    }

    public Label createImage(int columns, Image image, int style, int alignment) {
        Label label = new Label(this.composite, style);
        label.setImage(image);
        label.setLayoutData(this.createCell(columns));
        label.setAlignment(alignment);
        this.applyFormatting(label);
        return label;
    }

    public Text createText(int columns) {
        return this.createText(columns, 2048, "");
    }

    public Text createText(int columns, int style, String content) {
        Text text = new Text(this.composite, style);
        text.setLayoutData(this.createCell(columns, 4));
        text.setText(content);
        this.applyFormatting(text);
        return text;
    }

    public void createPadding(int columns) {
        Composite composite = new Composite(this.composite, 0);
        this.applyFormatting(composite);
        composite.setLayoutData(this.createCell(columns));
    }

    public Button createButton(int columns, int style, String content) {
        Button button = new Button(this.composite, style);
        button.setText(content);
        button.setLayoutData(this.createCell(columns, 4));
        this.applyFormatting(button);
        return button;
    }

    public CCombo createCombo(int columns, int style, ArrayList<String> labels) {
        CCombo combo = new CCombo(this.composite, style);
        combo.setEditable(false);
        combo.setLayoutData(this.createCell(columns));
        for (String label : labels) {
            combo.add(label);
        }
        this.applyFormatting(combo);
        return combo;
    }

    public void hide(Control control) {
        control.setVisible(false);
        ((GridData)control.getLayoutData()).exclude = true;
    }

    public void show(Control control) {
        control.setVisible(true);
        ((GridData)control.getLayoutData()).exclude = false;
    }

    public void pack() {
        this.composite.pack();
    }

    private void applyFormatting(Control control) {
    }
}

