/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.ui;

import com.salesforce.dataloader.client.DescribeRefObject;
import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.dyna.ObjectField;
import com.salesforce.dataloader.ui.Labels;
import com.salesforce.dataloader.ui.LoadPage;
import com.salesforce.dataloader.ui.MappingPage;
import com.salesforce.dataloader.ui.UIUtils;
import com.sforce.soap.partner.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ScrollBar;

public class ForeignKeyExternalIdPage
extends LoadPage {
    private final Controller controller;
    private final Map<String, Combo> extIdSelections = new HashMap<String, Combo>();
    private Composite containerComp;
    private ScrolledComposite scrollComp;
    private Map<String, DescribeRefObject> referenceObjects;

    public ForeignKeyExternalIdPage(Controller controller) {
        super(Labels.getString("ForeignKeyExternalIdPage.title"), Labels.getString("ForeignKeyExternalIdPage.message"), UIUtils.getImageRegistry().getDescriptor("splashscreens"));
        this.controller = controller;
        this.setDescription(Labels.getString("ForeignKeyExternalIdPage.description"));
        this.setPageComplete(true);
    }

    @Override
    public void createControl(Composite parent) {
        this.containerComp = new Composite(parent, 0);
        this.containerComp.setLayout(new FillLayout());
        this.setControl(this.containerComp);
        this.setPageComplete(true);
    }

    private void createFkExtIdUi() {
        this.getShell().setImage(UIUtils.getImageRegistry().get("sfdc_icon"));
        if (this.scrollComp != null) {
            this.scrollComp.dispose();
        }
        this.scrollComp = new ScrolledComposite(this.containerComp, 512);
        this.scrollComp.setExpandHorizontal(true);
        this.scrollComp.setExpandVertical(true);
        Composite comp = new Composite(this.scrollComp, 0);
        this.scrollComp.setContent(comp);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 10;
        gridLayout.marginHeight = 20;
        gridLayout.verticalSpacing = 7;
        comp.setLayout(gridLayout);
        this.scrollComp.setMinSize(comp.computeSize(-1, -1));
        ScrollBar scrollBar = this.scrollComp.getVerticalBar();
        scrollBar.setIncrement(20);
        scrollBar.setPageIncrement(100);
        this.extIdSelections.clear();
        if (this.referenceObjects != null) {
            for (String relationshipName : this.referenceObjects.keySet()) {
                this.createObjectExtIdUi(comp, relationshipName);
            }
        }
        this.scrollComp.setMinSize(comp.computeSize(-1, -1));
        this.containerComp.layout();
        this.setPageComplete(true);
    }

    private void createObjectExtIdUi(Composite comp, String relationshipName) {
        Label labelExtId = new Label(comp, 131072);
        labelExtId.setText(relationshipName);
        labelExtId.setLayoutData(new GridData(128));
        Combo extIdCombo = new Combo(comp, 12);
        GridData extIdData = new GridData(32);
        extIdData.widthHint = 150;
        extIdCombo.setLayoutData(extIdData);
        DescribeRefObject extIdInfo = this.referenceObjects.get(relationshipName);
        ArrayList<String> fieldList = new ArrayList<String>(extIdInfo.getFieldInfoMap().keySet());
        fieldList.add(Labels.getString("ForeignKeyExternalIdPage.defaultComboText"));
        UIUtils.setComboItems(extIdCombo, fieldList, Labels.getString("ForeignKeyExternalIdPage.defaultComboText"));
        this.extIdSelections.put(relationshipName, extIdCombo);
    }

    @Override
    public MappingPage getNextPage() {
        Map<String, Field> relatedFields = this.saveExtIdData();
        MappingPage nextPage = (MappingPage)this.getWizard().getPage(Labels.getString("MappingPage.title"));
        nextPage.setRelatedFields(relatedFields);
        nextPage.setupPage();
        return nextPage;
    }

    private Map<String, Field> saveExtIdData() {
        HashMap<String, Field> relatedFields = new HashMap<String, Field>();
        HashMap<String, String> extIdReferences = new HashMap<String, String>();
        for (String relationshipName : this.extIdSelections.keySet()) {
            Combo combo = this.extIdSelections.get(relationshipName);
            String extIdFieldName = combo.getText();
            if (extIdFieldName == null || extIdFieldName.length() <= 0 || extIdFieldName.equals(Labels.getString("ForeignKeyExternalIdPage.defaultComboText"))) continue;
            DescribeRefObject refObjectInfo = this.referenceObjects.get(relationshipName);
            extIdReferences.put(relationshipName, ObjectField.formatAsString(refObjectInfo.getObjectName(), extIdFieldName));
            relatedFields.put(relationshipName, refObjectInfo.getFieldInfoMap().get(extIdFieldName));
        }
        return relatedFields;
    }

    @Override
    boolean setupPage() {
        this.setReferenceObjects();
        this.createFkExtIdUi();
        return true;
    }

    public void setReferenceObjects() {
        this.referenceObjects = this.controller.getReferenceDescribes();
    }
}

