/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.ui;

import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.exception.MappingInitializationException;
import com.salesforce.dataloader.mapping.LoadMapper;
import com.salesforce.dataloader.ui.Labels;
import com.salesforce.dataloader.ui.LoadPage;
import com.salesforce.dataloader.ui.UIUtils;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public class FinishPage
extends LoadPage {
    private final Controller controller;
    private DirectoryFieldEditor dirFE;

    public FinishPage(Controller controller) {
        super(Labels.getString("FinishPage.title"), Labels.getString("FinishPage.finishMsg"), UIUtils.getImageRegistry().getDescriptor("splashscreens"));
        this.controller = controller;
        this.setPageComplete(false);
        this.setDescription(Labels.getString("FinishPage.selectDir"));
    }

    @Override
    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 10;
        gridLayout.marginHeight = 20;
        comp.setLayout(gridLayout);
        Label label = new Label(comp, 0x1000000);
        label.setText(Labels.getString("FinishPage.overwritten"));
        Composite dirComp = new Composite(comp, 0);
        GridData data = new GridData();
        data.widthHint = 400;
        dirComp.setLayoutData(data);
        this.dirFE = new DirectoryFieldEditor(Labels.getString("FinishPage.output"), Labels.getString("FinishPage.chooseDir"), dirComp);
        this.dirFE.setStringValue(this.controller.getConfig().getString("process.statusOutputDirectory"));
        this.hook_createControl(comp);
        this.setControl(comp);
    }

    protected void hook_createControl(Composite comp) {
    }

    public String getOutputDir() {
        return this.dirFE.getStringValue();
    }

    @Override
    public boolean canFlipToNextPage() {
        return false;
    }

    @Override
    boolean setupPage() {
        try {
            this.verifySettings();
        }
        catch (MappingInitializationException e) {
            FinishPage page = this;
            Display.getDefault().syncExec(new Thread(){

                @Override
                public void run() {
                    UIUtils.errorMessageBox(page.getShell(), e.getMessage());
                }
            });
            return false;
        }
        if (!this.controller.saveConfig()) {
            return false;
        }
        this.setPageComplete(true);
        return true;
    }

    private void verifySettings() throws MappingInitializationException {
        if (!this.getController().getConfig().getOperationInfo().isExtraction()) {
            ((LoadMapper)this.getController().getMapper()).verifyMappingsAreValid();
        }
    }

    public boolean finishAllowed() {
        return true;
    }

    protected Controller getController() {
        return this.controller;
    }
}

