/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.ui;

import com.salesforce.dataloader.config.Config;
import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.ui.ForeignKeyExternalIdPage;
import com.salesforce.dataloader.ui.Labels;
import com.salesforce.dataloader.ui.LoadPage;
import com.salesforce.dataloader.ui.UIUtils;
import com.sforce.soap.partner.DescribeSObjectResult;
import com.sforce.soap.partner.Field;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;

public class ExternalIdPage
extends LoadPage {
    private final Controller controller;
    private Composite comp;
    private Combo extIdFieldCombo;
    private Label labelExtId;
    private Label labelExtIdInfo;

    public ExternalIdPage(Controller controller) {
        super(Labels.getString("ExternalIdPage.title"), Labels.getString("ExternalIdPage.message"), UIUtils.getImageRegistry().getDescriptor("splashscreens"));
        this.controller = controller;
        this.setDescription(Labels.getString("ExternalIdPage.description"));
        this.setPageComplete(false);
    }

    @Override
    public void createControl(Composite parent) {
        this.getShell().setImage(UIUtils.getImageRegistry().get("sfdc_icon"));
        this.comp = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 20;
        gridLayout.verticalSpacing = 7;
        this.comp.setLayout(gridLayout);
        this.createExtIdFieldUi();
        this.setControl(this.comp);
    }

    private void createExtIdFieldUi() {
        this.labelExtIdInfo = new Label(this.comp, 16448);
        GridData extIdInfoData = new GridData(768);
        this.labelExtIdInfo.setLayoutData(extIdInfoData);
        this.getShell().addListener(11, new Listener(){

            @Override
            public void handleEvent(Event e) {
                extIdInfoData.widthHint = ExternalIdPage.this.comp.getBounds().width;
            }
        });
        new Label(this.comp, 0);
        this.labelExtId = new Label(this.comp, 16384);
        this.extIdFieldCombo = new Combo(this.comp, 12);
        this.extIdFieldCombo.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                String fieldName = ExternalIdPage.this.extIdFieldCombo.getText();
                if (fieldName != null && !fieldName.equals("")) {
                    ExternalIdPage.this.setPageComplete(true);
                } else {
                    ExternalIdPage.this.setPageComplete(false);
                }
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        GridData extIdFieldData = new GridData(32);
        extIdFieldData.widthHint = 150;
        this.extIdFieldCombo.setLayoutData(extIdFieldData);
    }

    public boolean setExtIdCombo() {
        this.extIdFieldCombo.removeAll();
        this.extIdFieldCombo.setEnabled(true);
        this.labelExtId.setText(Labels.getFormattedString("ExternalIdPage.externalIdComboText", this.controller.getConfig().getString("sfdc.entity")));
        DescribeSObjectResult fieldTypes = this.controller.getFieldTypes();
        Field[] fields = fieldTypes.getFields();
        ArrayList<String> extIdFields = new ArrayList<String>();
        for (Field field : fields) {
            if ("id".equals(field.getName().toLowerCase())) {
                extIdFields.add(field.getName());
            }
            if (!field.isExternalId() || !field.isCreateable() && !field.isUpdateable()) continue;
            extIdFields.add(field.getName());
        }
        String[] extIdNames = UIUtils.setComboItems(this.extIdFieldCombo, extIdFields, null);
        if (this.extIdFieldCombo.getItemCount() == 1) {
            this.extIdFieldCombo.setEnabled(false);
            this.extIdFieldCombo.setText(extIdNames[0]);
            this.labelExtIdInfo.setText(Labels.getFormattedString("ExternalIdPage.externalIdInfoNoExtId", this.controller.getConfig().getString("sfdc.entity")));
            this.setPageComplete(true);
        } else {
            this.labelExtIdInfo.setText(Labels.getFormattedString("ExternalIdPage.externalIdInfoExtIdExists", this.controller.getConfig().getString("sfdc.entity")));
            this.setPageComplete(false);
        }
        this.comp.layout();
        return extIdNames.length > 0;
    }

    @Override
    public LoadPage getNextPage() {
        this.saveExtIdData();
        LoadPage nextPage = null;
        ForeignKeyExternalIdPage fkExtIdPage = (ForeignKeyExternalIdPage)this.getWizard().getPage(Labels.getString("ForeignKeyExternalIdPage.title"));
        if (this.controller.getReferenceDescribes().size() > 0) {
            fkExtIdPage.setPageComplete(true);
            nextPage = fkExtIdPage;
        } else {
            fkExtIdPage.setPageComplete(true);
            nextPage = (LoadPage)this.getWizard().getPage(Labels.getString("MappingPage.title"));
        }
        ((LoadPage)nextPage).setupPage();
        return nextPage;
    }

    private void saveExtIdData() {
        Config config = this.controller.getConfig();
        String extIdField = this.extIdFieldCombo.getText();
        config.setValue("sfdc.externalIdField", extIdField);
        this.controller.saveConfig();
    }

    @Override
    boolean setupPage() {
        if (!this.setExtIdCombo()) {
            MessageBox msg = new MessageBox(this.getShell(), 33);
            msg.setMessage(Labels.getString("ExternalIdPage.errorExternalIdRequired"));
            msg.setText(Labels.getString("ExternalIdPage.errorExternalIdRequiredTitle"));
            msg.open();
            return false;
        }
        return true;
    }
}

