/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.ui;

import com.salesforce.dataloader.action.OperationInfo;
import com.salesforce.dataloader.config.Config;
import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.ui.DataSelectionDialog;
import com.salesforce.dataloader.ui.Labels;
import com.salesforce.dataloader.ui.LoadPage;
import com.salesforce.dataloader.ui.UIUtils;
import com.salesforce.dataloader.ui.entitySelection.EntityContentProvider;
import com.salesforce.dataloader.ui.entitySelection.EntityFilter;
import com.salesforce.dataloader.ui.entitySelection.EntityLabelProvider;
import com.salesforce.dataloader.ui.entitySelection.EntityViewerSorter;
import com.sforce.soap.partner.DescribeGlobalSObjectResult;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class DataSelectionPage
extends LoadPage {
    private final Logger logger = Logger.getLogger(DataSelectionPage.class);
    private final Controller controller;
    private static final String[] FILTER_EXTS = new String[]{"*.csv"};
    private final EntityFilter filter = new EntityFilter();
    private ListViewer lv;
    private FileFieldEditor csvChooser;

    public DataSelectionPage(Controller controller) {
        super(Labels.getString("DataSelectionPage.data"), Labels.getString("DataSelectionPage.dataMsg"), UIUtils.getImageRegistry().getDescriptor("splashscreens"));
        this.controller = controller;
        this.setDescription(Labels.getString("DataSelectionPage.message"));
        this.setPageComplete(false);
    }

    @Override
    public void createControl(Composite parent) {
        this.getShell().setImage(UIUtils.getImageRegistry().get("sfdc_icon"));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 10;
        gridLayout.marginHeight = 15;
        gridLayout.verticalSpacing = 5;
        gridLayout.marginRight = 5;
        Composite comp = new Composite(parent, 0);
        comp.setLayout(gridLayout);
        Label label = new Label(comp, 131072);
        label.setText(Labels.getString("DataSelectionPage.selectObject"));
        GridData data = new GridData();
        label.setLayoutData(data);
        Button filterAll = new Button(comp, 32);
        filterAll.setText(Labels.getString("DataSelectionPage.showAll"));
        data = new GridData();
        filterAll.setLayoutData(data);
        this.lv = new ListViewer(comp, 2816);
        this.lv.setContentProvider(new EntityContentProvider());
        this.lv.setLabelProvider(new EntityLabelProvider());
        this.lv.setInput(null);
        data = new GridData(4, 4, true, true);
        data.heightHint = 140;
        data.widthHint = 140;
        this.lv.getControl().setLayoutData(data);
        this.lv.addFilter(this.filter);
        this.lv.setSorter(new EntityViewerSorter());
        this.lv.addSelectionChangedListener(new ISelectionChangedListener(){

            @Override
            public void selectionChanged(SelectionChangedEvent event) {
                DataSelectionPage.this.checkPageComplete();
            }
        });
        if (this.controller.isLoggedIn()) {
            this.setInput(this.controller.getEntityDescribes());
        }
        filterAll.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                if (((Button)event.widget).getSelection()) {
                    DataSelectionPage.this.lv.removeFilter(DataSelectionPage.this.filter);
                } else {
                    DataSelectionPage.this.lv.addFilter(DataSelectionPage.this.filter);
                }
            }
        });
        new Label(comp, 0);
        String infoMessage = this.controller.getConfig().getOperationInfo().getInfoMessageForDataSelectionPage();
        if (infoMessage != null) {
            Label l = new Label(comp, 131072);
            GridData gd = new GridData();
            gd.horizontalAlignment = 128;
            l.setLayoutData(gd);
            l.setText(infoMessage);
            l.setForeground(new Color(this.getShell().getDisplay(), 255, 0, 0));
        }
        new Label(comp, 0);
        Composite compChooser = new Composite(comp, 0);
        data = new GridData(776);
        data.widthHint = 400;
        compChooser.setLayoutData(data);
        this.csvChooser = new FileFieldEditor(Labels.getString("DataSelectionPage.csv"), Labels.getString("DataSelectionPage.csvMessage"), compChooser);
        this.csvChooser.setFileExtensions(FILTER_EXTS);
        this.csvChooser.setEmptyStringAllowed(false);
        this.csvChooser.setPropertyChangeListener(new IPropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if ("field_editor_is_valid".equals(event.getProperty())) {
                    try {
                        if (!((Boolean)event.getNewValue()).booleanValue()) {
                            DataSelectionPage.this.setErrorMessage(Labels.getString("DataSelectionPage.selectValid"));
                            DataSelectionPage.this.checkPageComplete();
                        } else {
                            DataSelectionPage.this.setErrorMessage(null);
                            DataSelectionPage.this.checkPageComplete();
                        }
                    }
                    catch (ClassCastException cle) {
                        DataSelectionPage.this.logger.error(Labels.getString("DataSelectionPage.errorClassCast"), cle);
                    }
                }
            }
        });
        this.setControl(comp);
    }

    private void setInput(Map<String, DescribeGlobalSObjectResult> entityDescribes) {
        OperationInfo operation = this.controller.getConfig().getOperationInfo();
        HashMap<String, DescribeGlobalSObjectResult> inputDescribes = new HashMap<String, DescribeGlobalSObjectResult>();
        if (entityDescribes != null) {
            for (Map.Entry<String, DescribeGlobalSObjectResult> entry : entityDescribes.entrySet()) {
                String objectName = entry.getKey();
                DescribeGlobalSObjectResult objectDesc = entry.getValue();
                if (operation.isDelete() && objectDesc.isDeletable()) {
                    inputDescribes.put(objectName, objectDesc);
                    continue;
                }
                if (operation == OperationInfo.insert && objectDesc.isCreateable()) {
                    inputDescribes.put(objectName, objectDesc);
                    continue;
                }
                if (operation == OperationInfo.update && objectDesc.isUpdateable()) {
                    inputDescribes.put(objectName, objectDesc);
                    continue;
                }
                if (operation != OperationInfo.upsert || !objectDesc.isUpdateable() && !objectDesc.isCreateable()) continue;
                inputDescribes.put(objectName, objectDesc);
            }
        }
        this.lv.setInput(inputDescribes);
        this.lv.refresh();
        this.lv.getControl().getParent().pack();
    }

    private boolean checkEntityStatus() {
        IStructuredSelection selection = (IStructuredSelection)this.lv.getSelection();
        DescribeGlobalSObjectResult entity = (DescribeGlobalSObjectResult)selection.getFirstElement();
        return entity != null;
    }

    private void checkPageComplete() {
        if (this.csvChooser.isValid() && this.checkEntityStatus()) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    @Override
    public LoadPage getNextPage() {
        Config config = this.controller.getConfig();
        IStructuredSelection selection = (IStructuredSelection)this.lv.getSelection();
        DescribeGlobalSObjectResult entity = (DescribeGlobalSObjectResult)selection.getFirstElement();
        config.setValue("sfdc.entity", entity.getName());
        config.setValue("dataAccess.name", this.csvChooser.getStringValue());
        config.setValue("dataAccess.type", "csvRead");
        this.controller.saveConfig();
        DataSelectionDialog dlg = new DataSelectionDialog(this.getShell(), this.controller);
        if (dlg.open()) {
            return super.getNextPage();
        }
        return this;
    }

    @Override
    boolean setupPage() {
        Map<String, DescribeGlobalSObjectResult> describes = this.controller.getEntityDescribes();
        if (describes != null) {
            this.setInput(describes);
            return true;
        }
        return false;
    }
}

