/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.ui;

import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.dao.DataReader;
import com.salesforce.dataloader.exception.DataAccessObjectException;
import com.salesforce.dataloader.exception.DataAccessObjectInitializationException;
import com.salesforce.dataloader.ui.Labels;
import com.salesforce.dataloader.ui.UIUtils;
import com.salesforce.dataloader.util.DAORowUtil;
import com.sforce.ws.ConnectionException;
import java.io.File;
import java.util.List;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class DataSelectionDialog
extends Dialog {
    private String message;
    private boolean success;
    private Controller controller;
    private Button ok;
    private Label label;

    public DataSelectionDialog(Shell parent, Controller controller) {
        this(parent, 67696);
        this.controller = controller;
    }

    public DataSelectionDialog(Shell parent, int style) {
        super(parent, style);
        this.setText(Labels.getString("DataSelectionDialog.title"));
        this.setMessage(Labels.getString("DataSelectionDialog.message"));
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean open() {
        Shell shell = new Shell(this.getParent(), this.getStyle());
        shell.setText(this.getText());
        shell.setImage(UIUtils.getImageRegistry().get("sfdc_icon"));
        this.createContents(shell);
        shell.pack();
        shell.open();
        Display display = this.getParent().getDisplay();
        BusyIndicator.showWhile(display, new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    DataSelectionDialog.this.controller.setFieldTypes();
                    DataSelectionDialog.this.controller.setReferenceDescribes();
                    String daoPath = DataSelectionDialog.this.controller.getConfig().getString("dataAccess.name");
                    File file = new File(daoPath);
                    if (!file.exists() || !file.canRead()) {
                        DataSelectionDialog.this.success = false;
                        DataSelectionDialog.this.ok.setEnabled(true);
                        DataSelectionDialog.this.label.setText(Labels.getString("DataSelectionDialog.errorRead"));
                        shell.setText(Labels.getString("DataSelectionDialog.titleError"));
                        return;
                    }
                    try {
                        DataSelectionDialog.this.controller.createDao();
                    }
                    catch (DataAccessObjectInitializationException e) {
                        DataSelectionDialog.this.success = false;
                        DataSelectionDialog.this.ok.setEnabled(true);
                        DataSelectionDialog.this.label.setText(Labels.getString("DataSelectionDialog.errorRead"));
                        shell.setText(Labels.getString("DataSelectionDialog.titleError"));
                        return;
                    }
                    DataReader dataReader = (DataReader)DataSelectionDialog.this.controller.getDao();
                    List<String> header = null;
                    int totalRows = 0;
                    try {
                        int response;
                        dataReader.checkConnection();
                        dataReader.open();
                        String warning = DAORowUtil.validateColumns(dataReader);
                        if (warning != null && warning.length() != 0 && (response = UIUtils.warningConfMessageBox(shell, warning + "\n" + Labels.getString("DataSelectionDialog.warningConf"))) != 64) {
                            DataSelectionDialog.this.success = false;
                            DataSelectionDialog.this.ok.setEnabled(true);
                            DataSelectionDialog.this.label.setText(Labels.getString("DataSelectionDialog.errorCSVFormat"));
                            shell.setText(Labels.getString("DataSelectionDialog.titleError"));
                            return;
                        }
                        totalRows = dataReader.getTotalRows();
                        header = dataReader.getColumnNames();
                        if (header == null || header.size() == 0) {
                            DataSelectionDialog.this.success = false;
                            DataSelectionDialog.this.ok.setEnabled(true);
                            DataSelectionDialog.this.label.setText(Labels.getString("DataSelectionDialog.errorCSVFormat"));
                            shell.setText(Labels.getString("DataSelectionDialog.titleError"));
                            return;
                        }
                    }
                    catch (DataAccessObjectException e) {
                        DataSelectionDialog.this.success = false;
                        DataSelectionDialog.this.ok.setEnabled(true);
                        DataSelectionDialog.this.label.setText(Labels.getString("DataSelectionDialog.errorCSVFormat") + "  " + e.getMessage());
                        Point size = DataSelectionDialog.this.label.computeSize(-1, -1);
                        DataSelectionDialog.this.label.setSize(shell.getClientArea().width, size.y);
                        shell.setText(Labels.getString("DataSelectionDialog.titleError"));
                        shell.pack();
                        shell.redraw();
                        return;
                    }
                    finally {
                        dataReader.close();
                    }
                    DataSelectionDialog.this.success = true;
                    DataSelectionDialog.this.ok.setEnabled(true);
                    DataSelectionDialog.this.label.setText(Labels.getFormattedString("DataSelectionDialog.initSuccess", String.valueOf(totalRows)));
                    DataSelectionDialog.this.label.getParent().pack();
                }
                catch (ConnectionException ex) {
                    DataSelectionDialog.this.success = false;
                    DataSelectionDialog.this.ok.setEnabled(true);
                    DataSelectionDialog.this.label.setText(Labels.getString("DataSelectionDialog.errorEntity"));
                    shell.setText(Labels.getString("DataSelectionDialog.titleError"));
                    return;
                }
            }
        });
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.success;
    }

    private void createContents(Shell shell) {
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 10;
        shell.setLayout(layout);
        this.label = new Label(shell, 64);
        this.label.setText(this.message);
        GridData labelData = new GridData();
        labelData.horizontalSpan = 2;
        labelData.widthHint = 400;
        this.label.setLayoutData(labelData);
        Label labelSeparatorBottom = new Label(shell, 258);
        GridData sepData = new GridData(768);
        sepData.horizontalSpan = 2;
        labelSeparatorBottom.setLayoutData(sepData);
        new Label(shell, 0);
        this.ok = new Button(shell, 0x800008);
        this.ok.setText(Labels.getString("UI.ok"));
        this.ok.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                shell.close();
            }
        });
        GridData buttonData = new GridData(128);
        buttonData.widthHint = 75;
        this.ok.setLayoutData(buttonData);
        this.ok.setEnabled(false);
        shell.setDefaultButton(this.ok);
    }
}

