/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.ui;

import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.dao.csv.CSVFileReader;
import com.salesforce.dataloader.exception.DataAccessObjectException;
import com.salesforce.dataloader.exception.DataAccessObjectInitializationException;
import com.salesforce.dataloader.model.Row;
import com.salesforce.dataloader.ui.Labels;
import com.salesforce.dataloader.ui.UIUtils;
import com.salesforce.dataloader.ui.csvviewer.CSVContentProvider;
import com.salesforce.dataloader.ui.csvviewer.CSVLabelProvider;
import com.salesforce.dataloader.util.DAORowUtil;
import com.salesforce.dataloader.util.StreamGobbler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class CSVViewerDialog
extends Dialog {
    private String input;
    private Logger logger = Logger.getLogger(CSVViewerDialog.class);
    private String filename;
    private boolean useCustomSplitter = false;
    private int numberOfRows;
    private TableViewer csvTblViewer;
    private final Controller controller;

    public void setUseCustomSplitter(boolean useCustomSplitter) {
        this.useCustomSplitter = useCustomSplitter;
    }

    public void setFileName(String filename) {
        this.filename = filename;
    }

    public void setNumberOfRows(int rows) {
        this.numberOfRows = rows;
    }

    public CSVViewerDialog(Shell parent, Controller controller) {
        this(parent, 68832, controller);
    }

    public CSVViewerDialog(Shell parent, int style, Controller controller) {
        super(parent, style);
        this.setText(Labels.getString("CSVViewer.title"));
        this.controller = controller;
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public String open() throws DataAccessObjectInitializationException {
        this.logger.info(Labels.getString("CSVViewer.message"));
        Shell shell = new Shell(this.getParent(), this.getStyle() | 0x10);
        shell.setText(this.getText());
        shell.setImage(UIUtils.getImageRegistry().get("sfdc_icon"));
        shell.setSize(600, 600);
        this.createContents(shell);
        shell.open();
        Display display = this.getParent().getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.input;
    }

    private void createContents(Shell shell) throws DataAccessObjectInitializationException {
        shell.setLayout(new GridLayout(1, false));
        this.initializeCSVViewer(shell);
        Label sep3 = new Label(shell, 258);
        sep3.setLayoutData(new GridData(768));
        boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
        if (isWindows) {
            Label externalLabel = new Label(shell, 0);
            externalLabel.setText(Labels.getString("CSVViewerDialog.externalMsg"));
            externalLabel.setLayoutData(new GridData(128));
        }
        Composite comp2 = new Composite(shell, 0);
        comp2.setLayout(new GridLayout(2, false));
        comp2.setLayoutData(new GridData(128));
        if (isWindows) {
            Button external = new Button(comp2, 0x800008);
            external.setText(Labels.getString("CSVViewerDialog.externalButton"));
            external.setLayoutData(new GridData(128));
            external.addSelectionListener(new SelectionListener(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    Thread runner = new Thread(){

                        @Override
                        public void run() {
                            int exitVal = 0;
                            try {
                                String[] cmd = new String[]{"cmd.exe", "/c", "\"" + CSVViewerDialog.this.filename + "\""};
                                Process proc = Runtime.getRuntime().exec(cmd);
                                StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "ERROR");
                                StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "OUTPUT");
                                errorGobbler.start();
                                outputGobbler.start();
                                exitVal = proc.waitFor();
                            }
                            catch (IOException iox) {
                                CSVViewerDialog.this.logger.error(Labels.getString("CSVViewerDialog.errorExternal"), iox);
                            }
                            catch (InterruptedException ie) {
                                CSVViewerDialog.this.logger.error(Labels.getString("CSVViewerDialog.errorExternal"), ie);
                            }
                            if (exitVal != 0) {
                                CSVViewerDialog.this.logger.error(Labels.getString("CSVViewerDialog.errorProcessExit") + exitVal);
                            }
                        }
                    };
                    runner.setPriority(10);
                    runner.start();
                }

                @Override
                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        Button ok = new Button(comp2, 0x800008);
        ok.setText(Labels.getString("UI.close"));
        GridData data = new GridData(128);
        data.widthHint = 75;
        ok.setLayoutData(data);
        ok.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                shell.close();
            }
        });
        shell.setDefaultButton(ok);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeCSVViewer(Shell shell) throws DataAccessObjectInitializationException {
        try (CSVFileReader csvReader = new CSVFileReader(this.filename, this.controller, this.useCustomSplitter);){
            csvReader.open();
            List<String> header = csvReader.getColumnNames();
            this.csvTblViewer = new TableViewer(shell, 65536);
            this.csvTblViewer.setContentProvider(new CSVContentProvider());
            this.csvTblViewer.setLabelProvider(new CSVLabelProvider());
            Table csvTable = this.csvTblViewer.getTable();
            GridData data = new GridData(1808);
            data.heightHint = 300;
            csvTable.setLayoutData(data);
            Iterator<String> iter = header.iterator();
            new TableColumn(csvTable, 16384).setText(Labels.getString("CSVViewerDialog.rowNumber"));
            while (iter.hasNext()) {
                TableColumn tc = new TableColumn(csvTable, 16384);
                tc.setText(iter.next().toString());
            }
            this.updateCSVTable(csvReader);
            this.packSforceColumns();
            csvTable.setHeaderVisible(true);
            csvTable.setLinesVisible(true);
            if (csvTable.getItemCount() > 0) {
                csvTable.showItem(csvTable.getItem(0));
            }
        }
    }

    private void updateCSVTable(CSVFileReader csvReader) {
        LinkedList rowList = new LinkedList();
        for (int i = 0; i < this.numberOfRows; ++i) {
            Row rowMap;
            try {
                rowMap = csvReader.readRow();
            }
            catch (DataAccessObjectException e) {
                break;
            }
            if (!DAORowUtil.isValidRow(rowMap)) break;
            List<String> columns = csvReader.getColumnNames();
            ArrayList<Object> row = new ArrayList<Object>();
            row.add(0, String.valueOf(i + 1));
            for (String column : columns) {
                row.add(rowMap.get(column));
            }
            rowList.add(row);
        }
        csvReader.close();
        this.csvTblViewer.setInput(rowList);
    }

    private void packSforceColumns() {
        Table sforceTable = this.csvTblViewer.getTable();
        int n = sforceTable.getColumnCount();
        for (int i = 0; i < n; ++i) {
            sforceTable.getColumn(i).pack();
        }
    }
}

