/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.ui;

import com.salesforce.dataloader.config.Messages;
import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.exception.DataAccessObjectInitializationException;
import com.salesforce.dataloader.ui.CSVViewerDialog;
import com.salesforce.dataloader.ui.Labels;
import com.salesforce.dataloader.ui.UIUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.springframework.util.StringUtils;

public class CSVChooserDialog
extends Dialog {
    private String message;
    private String input;
    private Controller controller;
    private Text textRows;
    private Button buttonSelect;
    private Button buttonSuccess;
    private Button buttonError;

    public CSVChooserDialog(Shell parent, Controller controller) {
        this(parent, 67696);
        this.controller = controller;
    }

    public CSVChooserDialog(Shell parent, int style) {
        super(parent, style);
        this.setText(Labels.getString("CSVChooser.title"));
        this.setMessage(Labels.getString("CSVChooser.message"));
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public String open() {
        Shell shell = new Shell(this.getParent(), this.getStyle());
        shell.setText(this.getText());
        shell.setImage(UIUtils.getImageRegistry().get("sfdc_icon"));
        this.createContents(shell);
        shell.pack();
        shell.open();
        Display display = this.getParent().getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.input;
    }

    private void createContents(Shell shell) {
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 10;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        shell.setLayout(layout);
        GridData data = new GridData(768);
        data.heightHint = 50;
        data.widthHint = 400;
        Composite topComp = new Composite(shell, 0);
        layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        topComp.setLayout(layout);
        topComp.setLayoutData(data);
        Label blank = new Label(topComp, 0);
        data = new GridData(768);
        data.heightHint = 10;
        blank.setLayoutData(data);
        blank.setBackground(Display.getCurrent().getSystemColor(1));
        Label label = new Label(topComp, 0);
        label.setText(this.message);
        data = new GridData(768);
        data.heightHint = 30;
        data.widthHint = 370;
        Font f = label.getFont();
        FontData[] farr = f.getFontData();
        FontData fd = farr[0];
        fd.setStyle(1);
        label.setFont(new Font((Device)Display.getCurrent(), fd));
        label.setLayoutData(data);
        label.setBackground(Display.getCurrent().getSystemColor(1));
        Label labelSeparator = new Label(topComp, 258);
        data = new GridData(768);
        labelSeparator.setLayoutData(data);
        Composite restComp = new Composite(shell, 0);
        data = new GridData(1808);
        restComp.setLayoutData(data);
        layout = new GridLayout(2, false);
        layout.verticalSpacing = 15;
        restComp.setLayout(layout);
        Label labelRows = new Label(restComp, 131072);
        labelRows.setText(Labels.getString("CSVChooser.numberRows"));
        data = new GridData(128);
        labelRows.setLayoutData(data);
        this.textRows = new Text(restComp, 2048);
        this.textRows.setText("1000");
        this.textRows.addVerifyListener(new VerifyListener(){

            @Override
            public void verifyText(VerifyEvent event) {
                event.doit = Character.isISOControl(event.character) || Character.isDigit(event.character);
            }
        });
        data = new GridData();
        data.widthHint = 90;
        this.textRows.setLayoutData(data);
        Label labelSelect = new Label(restComp, 131072);
        labelSelect.setText(Labels.getString("CSVChooser.selectOpen"));
        data = new GridData(128);
        labelSelect.setLayoutData(data);
        this.buttonSelect = new Button(restComp, 0x800008);
        this.buttonSelect.setText(Labels.getString("CSVChooser.openCsv"));
        this.buttonSelect.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                FileDialog dlg = new FileDialog(shell, 4096);
                String fn = dlg.open();
                if (fn != null) {
                    CSVChooserDialog.this.openViewer(fn, true);
                }
            }
        });
        Label labelSuccess = new Label(restComp, 131072);
        labelSuccess.setText(Labels.getString("CSVChooser.lastSuccess"));
        data = new GridData(128);
        labelSuccess.setLayoutData(data);
        this.buttonSuccess = new Button(restComp, 0x800008);
        this.buttonSuccess.setText(Labels.getString("CSVChooser.openSuccess"));
        this.buttonSuccess.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                String successFilePath = CSVChooserDialog.this.controller.getConfig().getString("process.outputSuccess");
                if (StringUtils.hasText(successFilePath)) {
                    CSVChooserDialog.this.openViewer(successFilePath, false);
                } else {
                    UIUtils.infoMessageBox(shell, Messages.getString("CSVChooser.noSucessOrErrorFile", new Object[0]));
                }
            }
        });
        Label labelError = new Label(restComp, 131072);
        labelError.setText(Labels.getString("CSVChooser.lastError"));
        data = new GridData(128);
        labelError.setLayoutData(data);
        this.buttonError = new Button(restComp, 0x800008);
        this.buttonError.setText(Labels.getString("CSVChooser.openError"));
        this.buttonError.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                String errorFilePath = CSVChooserDialog.this.controller.getConfig().getString("process.outputError");
                if (StringUtils.hasText(errorFilePath)) {
                    CSVChooserDialog.this.openViewer(errorFilePath, false);
                } else {
                    UIUtils.infoMessageBox(shell, Messages.getString("CSVChooser.noSucessOrErrorFile", new Object[0]));
                }
            }
        });
        Label labelSeparatorBottom = new Label(restComp, 258);
        data = new GridData(768);
        data.horizontalSpan = 2;
        labelSeparatorBottom.setLayoutData(data);
        new Label(restComp, 0);
        Composite buttonComp = new Composite(restComp, 0);
        data = new GridData(128);
        buttonComp.setLayoutData(data);
        buttonComp.setLayout(new GridLayout(2, false));
        Button ok = new Button(buttonComp, 0x800008);
        ok.setText(Labels.getString("UI.close"));
        ok.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                CSVChooserDialog.this.input = "OK";
                shell.close();
            }
        });
        data = new GridData();
        data.widthHint = 75;
        ok.setLayoutData(data);
        shell.setDefaultButton(ok);
    }

    private void openViewer(String filename, boolean useCustomSplitter) {
        CSVViewerDialog dlg = new CSVViewerDialog(this.getParent(), this.controller);
        dlg.setNumberOfRows(Integer.parseInt(this.textRows.getText()));
        dlg.setFileName(filename);
        dlg.setUseCustomSplitter(useCustomSplitter);
        try {
            dlg.open();
        }
        catch (DataAccessObjectInitializationException e) {
            UIUtils.errorMessageBox(this.getParent(), e);
        }
    }
}

