/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.ui;

import com.salesforce.dataloader.action.OperationInfo;
import com.salesforce.dataloader.config.Config;
import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.ui.Labels;
import com.salesforce.dataloader.ui.SettingsPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;

public abstract class BaseWizard
extends Wizard {
    private final Controller controller;
    private final WizardPage finishPage;

    protected BaseWizard(Controller ctl, OperationInfo info) {
        this.controller = ctl;
        this.getConfig().setValue("process.operation", info.name());
        this.finishPage = this.setupPages();
        this.setWindowTitle(this.getLabel("title"));
    }

    protected abstract SettingsPage createSettingsPage();

    protected abstract WizardPage setPages();

    private WizardPage setupPages() {
        if (SettingsPage.isNeeded(this.getController())) {
            this.addPage(this.createSettingsPage());
        }
        return this.setPages();
    }

    protected Controller getController() {
        return this.controller;
    }

    protected Config getConfig() {
        return this.getController().getConfig();
    }

    protected String getLabel(String name) {
        return Labels.getString(this.getLabelSection() + "." + name);
    }

    protected String getLabelSection() {
        return this.getClass().getSimpleName();
    }

    protected WizardPage getFinishPage() {
        return this.finishPage;
    }
}

