/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.ui;

import com.salesforce.dataloader.config.Config;
import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.model.LoginCriteria;
import com.salesforce.dataloader.ui.Labels;
import com.salesforce.dataloader.ui.OAuthFlow;
import com.salesforce.dataloader.ui.OAuthSecretFlow;
import com.salesforce.dataloader.ui.OAuthTokenFlow;
import com.salesforce.dataloader.util.ExceptionUtil;
import com.sforce.soap.partner.fault.LoginFault;
import com.sforce.soap.partner.fault.UnexpectedErrorFault;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class AuthenticationRunner {
    private static Logger logger = Logger.getLogger(AuthenticationRunner.class);
    private final Config config;
    private final Controller controller;
    private final Consumer<Boolean> complete;
    private final String nestedException = "nested exception is:";
    private final Shell shell;
    private Consumer<String> messenger;
    private LoginCriteria criteria;

    public AuthenticationRunner(Shell shell, Config config, Controller controller, Consumer<Boolean> complete) {
        this.shell = shell;
        this.config = config;
        this.controller = controller;
        this.complete = complete;
    }

    public Config getConfig() {
        return this.config;
    }

    public void login(LoginCriteria criteria, Consumer<String> messenger) {
        this.messenger = messenger;
        this.criteria = criteria;
        criteria.updateConfig(this.config);
        BusyIndicator.showWhile(Display.getDefault(), new Thread(this::loginAsync));
    }

    private void loginAsync() {
        try {
            this.messenger.accept(Labels.getString("SettingsPage.verifyingLogin"));
            if (this.criteria.getMode() == 0) {
                OAuthFlow flow;
                boolean hasSecret = !this.config.getString("sfdc.oauth.clientsecret").trim().equals("");
                OAuthFlow oAuthFlow = flow = hasSecret ? new OAuthSecretFlow(this.shell, this.config) : new OAuthTokenFlow(this.shell, this.config);
                if (!flow.open()) {
                    String message = Labels.getString("SettingsPage.invalidLogin");
                    if (flow.getStatusCode() == 407) {
                        message = Labels.getFormattedString("SettingsPage.proxyError", flow.getReasonPhrase());
                    }
                    logger.info("Login failed:" + flow.getReasonPhrase());
                    this.messenger.accept(message);
                    this.complete.accept(false);
                    return;
                }
            }
            if (this.controller.login() && this.controller.setEntityDescribes()) {
                this.messenger.accept(Labels.getString("SettingsPage.loginSuccessful"));
                this.controller.saveConfig();
                this.complete.accept(true);
            } else {
                this.messenger.accept(Labels.getString("SettingsPage.invalidLogin"));
                this.complete.accept(false);
            }
        }
        catch (LoginFault lf) {
            this.messenger.accept(Labels.getString("SettingsPage.invalidLogin"));
            this.complete.accept(false);
        }
        catch (UnexpectedErrorFault e) {
            this.handleError(e, e.getExceptionMessage());
        }
        catch (Throwable e) {
            this.handleError(e, e.getMessage());
        }
    }

    private void handleError(Throwable e, String message) {
        if (message == null || message.length() < 1) {
            this.messenger.accept(Labels.getString("SettingsPage.invalidLogin"));
        } else {
            int x = message.indexOf("nested exception is:");
            if (x >= 0) {
                message = message.substring(x += "nested exception is:".length());
            }
            this.messenger.accept(message.replace('\n', ' ').trim());
        }
        this.complete.accept(false);
        logger.error(message);
        logger.error("\n" + ExceptionUtil.getStackTraceString(e));
    }
}

