/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.ui;

import com.salesforce.dataloader.config.Config;
import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.ui.Labels;
import com.salesforce.dataloader.ui.UIUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AdvancedSettingsDialog
extends Dialog {
    private String message;
    private String input;
    private Controller controller;
    private Text textBatch;
    private Text textQueryBatch;
    private Text textSplitterValue;
    private Button buttonNulls;
    private Text textRule;
    private Text textEndpoint;
    private Button buttonCompression;
    private Button buttonResetUrl;
    private Text textTimeout;
    private Text textRowToStart;
    private Text textProxyHost;
    private Text textProxyPort;
    private Text textProxyNtlmDomain;
    private Text textProxyUsername;
    private Text textProxyPassword;
    private Text textTimezone;
    private final String defaultServer;
    private final Logger logger = Logger.getLogger(AdvancedSettingsDialog.class);
    private Button buttonHideWelcomeScreen;
    private Button buttonOutputExtractStatus;
    private Button buttonReadUtf8;
    private Button buttonWriteUtf8;
    private Button buttonEuroDates;
    private Button buttonTruncateFields;
    private Button buttonUseBulkApi;
    private Button buttonBulkApiSerialMode;
    private Button buttonBulkApiZipContent;
    private Button buttonCsvComma;
    private Button buttonCsvTab;
    private Button buttonCsvOther;
    private final Map<Button, Boolean> oldBulkAPIDependencies = new HashMap<Button, Boolean>();

    public AdvancedSettingsDialog(Shell parent, Controller controller) {
        super(parent, 67696);
        this.setText(Labels.getString("AdvancedSettingsDialog.title"));
        this.setMessage(Labels.getString("AdvancedSettingsDialog.message"));
        this.controller = controller;
        Object server = "";
        try {
            URI uri = new URI("http://rpolk-ltm3.internal.salesforce.com:6109/services/Soap/u/45.0");
            server = uri.getScheme() + "://" + uri.getHost();
        }
        catch (URISyntaxException e) {
            this.logger.error(e);
        }
        this.defaultServer = server;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public String open() {
        Shell shell = new Shell(this.getParent(), this.getStyle());
        shell.setText(this.getText());
        shell.setImage(UIUtils.getImageRegistry().get("sfdc_icon"));
        this.createContents(shell);
        shell.pack();
        shell.open();
        Display display = this.getParent().getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.input;
    }

    private void initBulkApiSetting(boolean enabled) {
        this.setButtonEnabled("sfdc.bulkApiSerialMode", this.buttonBulkApiSerialMode, enabled);
        this.setButtonEnabled("sfdc.bulkApiZipContent", this.buttonBulkApiZipContent, enabled);
        this.setButtonEnabled("sfdc.insertNulls", this.buttonNulls, !enabled);
        this.setButtonEnabled("sfdc.truncateFields", this.buttonTruncateFields, !enabled);
    }

    private void setButtonEnabled(String configKey, Button b, boolean enabled) {
        Boolean previousValue = this.oldBulkAPIDependencies.put(b, b.getSelection());
        b.setSelection(enabled ? (previousValue != null ? previousValue.booleanValue() : this.controller.getConfig().getBoolean(configKey)) : false);
        b.setEnabled(enabled);
    }

    private void createContents(Shell shell) {
        Config config = this.controller.getConfig();
        ScrolledComposite sc = new ScrolledComposite(shell, 768);
        Composite container = new Composite(sc, 0);
        GridLayout containerLayout = new GridLayout(1, false);
        container.setLayout(containerLayout);
        shell.setLayout(new FillLayout());
        GridData data = new GridData(768);
        data.heightHint = 50;
        data.widthHint = 400;
        Composite topComp = new Composite(container, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        topComp.setLayout(layout);
        topComp.setLayoutData(data);
        Label blank = new Label(topComp, 0);
        data = new GridData(768);
        data.heightHint = 10;
        blank.setLayoutData(data);
        blank.setBackground(Display.getCurrent().getSystemColor(1));
        Label label = new Label(topComp, 0);
        label.setText(this.message);
        data = new GridData(768);
        data.heightHint = 30;
        data.widthHint = 370;
        Font f = label.getFont();
        FontData[] farr = f.getFontData();
        FontData fd = farr[0];
        fd.setStyle(1);
        label.setFont(new Font((Device)Display.getCurrent(), fd));
        label.setLayoutData(data);
        label.setBackground(Display.getCurrent().getSystemColor(1));
        Label labelSeparator = new Label(topComp, 258);
        data = new GridData(768);
        labelSeparator.setLayoutData(data);
        Composite restComp = new Composite(container, 0);
        data = new GridData(1808);
        restComp.setLayoutData(data);
        layout = new GridLayout(2, false);
        layout.verticalSpacing = 10;
        restComp.setLayout(layout);
        Label labelHideWelcomeScreen = new Label(restComp, 131072);
        labelHideWelcomeScreen.setText(Labels.getString("AdvancedSettingsDialog.hideWelcomeScreen"));
        labelHideWelcomeScreen.setLayoutData(new GridData(128));
        this.buttonHideWelcomeScreen = new Button(restComp, 32);
        this.buttonHideWelcomeScreen.setSelection(config.getBoolean("loader.hideWelcome"));
        Label labelBatch = new Label(restComp, 131072);
        labelBatch.setText(Labels.getString("AdvancedSettingsDialog.batchSize"));
        data = new GridData(128);
        labelBatch.setLayoutData(data);
        this.textBatch = new Text(restComp, 2048);
        this.textBatch.setText(config.getString("sfdc.loadBatchSize"));
        this.textBatch.setTextLimit(8);
        this.textBatch.addVerifyListener(new VerifyListener(){

            @Override
            public void verifyText(VerifyEvent event) {
                event.doit = Character.isISOControl(event.character) || Character.isDigit(event.character);
            }
        });
        data = new GridData();
        data.widthHint = 50;
        this.textBatch.setLayoutData(data);
        Label labelNulls = new Label(restComp, 131072);
        labelNulls.setText(Labels.getString("AdvancedSettingsDialog.insertNulls"));
        data = new GridData(128);
        labelNulls.setLayoutData(data);
        this.buttonNulls = new Button(restComp, 32);
        this.buttonNulls.setSelection(config.getBoolean("sfdc.insertNulls"));
        Label labelRule = new Label(restComp, 131072);
        labelRule.setText(Labels.getString("AdvancedSettingsDialog.assignmentRule"));
        data = new GridData(128);
        labelRule.setLayoutData(data);
        this.textRule = new Text(restComp, 2048);
        this.textRule.setTextLimit(18);
        data = new GridData();
        data.widthHint = 115;
        this.textRule.setLayoutData(data);
        this.textRule.setText(config.getString("sfdc.assignmentRule"));
        Label labelEndpoint = new Label(restComp, 131072);
        labelEndpoint.setText(Labels.getString("AdvancedSettingsDialog.serverURL"));
        data = new GridData(128);
        labelEndpoint.setLayoutData(data);
        this.textEndpoint = new Text(restComp, 2048);
        data = new GridData();
        data.widthHint = 250;
        this.textEndpoint.setLayoutData(data);
        String endpoint = config.getString("sfdc.endpoint");
        if ("".equals(endpoint)) {
            endpoint = this.defaultServer;
        }
        this.textEndpoint.setText(endpoint);
        Label labelResetUrl = new Label(restComp, 131072);
        labelResetUrl.setText(Labels.getString("AdvancedSettingsDialog.resetUrlOnLogin"));
        data = new GridData(128);
        labelResetUrl.setLayoutData(data);
        this.buttonResetUrl = new Button(restComp, 32);
        this.buttonResetUrl.setSelection(config.getBoolean("sfdc.resetUrlOnLogin"));
        Label labelCompression = new Label(restComp, 131072);
        labelCompression.setText(Labels.getString("AdvancedSettingsDialog.compression"));
        data = new GridData(128);
        labelCompression.setLayoutData(data);
        this.buttonCompression = new Button(restComp, 32);
        this.buttonCompression.setSelection(config.getBoolean("sfdc.noCompression"));
        Label labelTimeout = new Label(restComp, 131072);
        labelTimeout.setText(Labels.getString("AdvancedSettingsDialog.timeout"));
        data = new GridData(128);
        labelTimeout.setLayoutData(data);
        this.textTimeout = new Text(restComp, 2048);
        this.textTimeout.setTextLimit(4);
        this.textTimeout.setText(config.getString("sfdc.timeoutSecs"));
        this.textTimeout.addVerifyListener(new VerifyListener(){

            @Override
            public void verifyText(VerifyEvent event) {
                event.doit = Character.isISOControl(event.character) || Character.isDigit(event.character);
            }
        });
        data = new GridData();
        data.widthHint = 30;
        this.textTimeout.setLayoutData(data);
        Label labelQueryBatch = new Label(restComp, 131072);
        labelQueryBatch.setText(Labels.getString("ExtractionInputDialog.querySize"));
        data = new GridData(128);
        labelQueryBatch.setLayoutData(data);
        this.textQueryBatch = new Text(restComp, 2048);
        this.textQueryBatch.setText(config.getString("sfdc.extractionRequestSize"));
        this.textQueryBatch.setTextLimit(4);
        this.textQueryBatch.addVerifyListener(new VerifyListener(){

            @Override
            public void verifyText(VerifyEvent event) {
                event.doit = Character.isISOControl(event.character) || Character.isDigit(event.character);
            }
        });
        data = new GridData();
        data.widthHint = 30;
        this.textQueryBatch.setLayoutData(data);
        Label labelOutputExtractStatus = new Label(restComp, 131072);
        labelOutputExtractStatus.setText(Labels.getString("AdvancedSettingsDialog.outputExtractStatus"));
        data = new GridData(128);
        labelOutputExtractStatus.setLayoutData(data);
        this.buttonOutputExtractStatus = new Button(restComp, 32);
        this.buttonOutputExtractStatus.setSelection(config.getBoolean("process.enableExtractStatusOutput"));
        Label labelReadUTF8 = new Label(restComp, 131072);
        labelReadUTF8.setText(Labels.getString("AdvancedSettingsDialog.readUTF8"));
        data = new GridData(128);
        labelReadUTF8.setLayoutData(data);
        this.buttonReadUtf8 = new Button(restComp, 32);
        this.buttonReadUtf8.setSelection(config.getBoolean("dataAccess.readUTF8"));
        Label labelWriteUTF8 = new Label(restComp, 131072);
        labelWriteUTF8.setText(Labels.getString("AdvancedSettingsDialog.writeUTF8"));
        data = new GridData(128);
        labelWriteUTF8.setLayoutData(data);
        this.buttonWriteUtf8 = new Button(restComp, 32);
        this.buttonWriteUtf8.setSelection(config.getBoolean("dataAccess.writeUTF8"));
        Label labelEuropeanDates = new Label(restComp, 131072);
        labelEuropeanDates.setText(Labels.getString("AdvancedSettingsDialog.useEuropeanDateFormat"));
        data = new GridData(128);
        labelEuropeanDates.setLayoutData(data);
        this.buttonEuroDates = new Button(restComp, 32);
        this.buttonEuroDates.setSelection(config.getBoolean("process.useEuropeanDates"));
        Label labelTruncateFields = new Label(restComp, 131072);
        labelTruncateFields.setText(Labels.getString("AdvancedSettingsDialog.allowFieldTruncation"));
        data = new GridData(128);
        labelTruncateFields.setLayoutData(data);
        this.buttonTruncateFields = new Button(restComp, 32);
        this.buttonTruncateFields.setSelection(config.getBoolean("sfdc.truncateFields"));
        Label labelCsvCommand = new Label(restComp, 131072);
        labelCsvCommand.setText(Labels.getString("AdvancedSettingsDialog.useCommaAsCsvDelimiter"));
        data = new GridData(128);
        labelCsvCommand.setLayoutData(data);
        this.buttonCsvComma = new Button(restComp, 32);
        this.buttonCsvComma.setSelection(config.getBoolean("loader.csvComma"));
        Label labelTabCommand = new Label(restComp, 131072);
        labelTabCommand.setText(Labels.getString("AdvancedSettingsDialog.useTabAsCsvDelimiter"));
        data = new GridData(128);
        labelTabCommand.setLayoutData(data);
        this.buttonCsvTab = new Button(restComp, 32);
        this.buttonCsvTab.setSelection(config.getBoolean("loader.csvTab"));
        Label labelOtherCommand = new Label(restComp, 131072);
        labelOtherCommand.setText(Labels.getString("AdvancedSettingsDialog.useOtherAsCsvDelimiter"));
        data = new GridData(128);
        labelOtherCommand.setLayoutData(data);
        this.buttonCsvOther = new Button(restComp, 32);
        this.buttonCsvOther.setSelection(config.getBoolean("loader.csvOther"));
        Label labelOtherDelimiterValue = new Label(restComp, 131072);
        labelOtherDelimiterValue.setText(Labels.getString("AdvancedSettingsDialog.csvOtherDelimiterValue"));
        data = new GridData(128);
        labelOtherDelimiterValue.setLayoutData(data);
        this.textSplitterValue = new Text(restComp, 2048);
        this.textSplitterValue.setText(config.getString("loader.csvOtherValue"));
        data = new GridData();
        data.widthHint = 25;
        this.textSplitterValue.setLayoutData(data);
        Label labelUseBulkApi = new Label(restComp, 131072);
        labelUseBulkApi.setText(Labels.getString("AdvancedSettingsDialog.useBulkApi"));
        data = new GridData(128);
        labelUseBulkApi.setLayoutData(data);
        boolean useBulkAPI = config.getBoolean("sfdc.useBulkApi");
        this.buttonUseBulkApi = new Button(restComp, 32);
        this.buttonUseBulkApi.setSelection(useBulkAPI);
        this.buttonUseBulkApi.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                boolean enabled = AdvancedSettingsDialog.this.buttonUseBulkApi.getSelection();
                int newDefaultBatchSize = AdvancedSettingsDialog.this.controller.getConfig().getDefaultBatchSize(enabled);
                AdvancedSettingsDialog.this.logger.info("Setting batch size to " + newDefaultBatchSize);
                AdvancedSettingsDialog.this.textBatch.setText(String.valueOf(newDefaultBatchSize));
                AdvancedSettingsDialog.this.initBulkApiSetting(enabled);
            }
        });
        Label labelBulkApiSerialMode = new Label(restComp, 131072);
        labelBulkApiSerialMode.setText(Labels.getString("AdvancedSettingsDialog.bulkApiSerialMode"));
        labelBulkApiSerialMode.setLayoutData(new GridData(128));
        this.buttonBulkApiSerialMode = new Button(restComp, 32);
        this.buttonBulkApiSerialMode.setSelection(config.getBoolean("sfdc.bulkApiSerialMode"));
        this.buttonBulkApiSerialMode.setEnabled(useBulkAPI);
        Label labelBulkApiZipContent = new Label(restComp, 131072);
        labelBulkApiZipContent.setText(Labels.getString("AdvancedSettingsDialog.bulkApiZipContent"));
        labelBulkApiZipContent.setLayoutData(new GridData(128));
        this.buttonBulkApiZipContent = new Button(restComp, 32);
        this.buttonBulkApiZipContent.setSelection(config.getBoolean("sfdc.bulkApiSerialMode"));
        this.buttonBulkApiZipContent.setEnabled(useBulkAPI);
        this.textTimezone = this.createTextInput(restComp, "AdvancedSettingsDialog.timezone", "sfdc.timezone", TimeZone.getDefault().getID(), 200);
        Label labelProxyHost = new Label(restComp, 131072);
        labelProxyHost.setText(Labels.getString("AdvancedSettingsDialog.proxyHost"));
        data = new GridData(128);
        labelProxyHost.setLayoutData(data);
        this.textProxyHost = new Text(restComp, 2048);
        this.textProxyHost.setText(config.getString("sfdc.proxyHost"));
        data = new GridData();
        data.widthHint = 250;
        this.textProxyHost.setLayoutData(data);
        Label labelProxyPort = new Label(restComp, 131072);
        labelProxyPort.setText(Labels.getString("AdvancedSettingsDialog.proxyPort"));
        data = new GridData(128);
        labelProxyPort.setLayoutData(data);
        this.textProxyPort = new Text(restComp, 2048);
        this.textProxyPort.setText(config.getString("sfdc.proxyPort"));
        this.textProxyPort.setTextLimit(4);
        this.textProxyPort.addVerifyListener(new VerifyListener(){

            @Override
            public void verifyText(VerifyEvent event) {
                event.doit = Character.isISOControl(event.character) || Character.isDigit(event.character);
            }
        });
        data = new GridData();
        data.widthHint = 25;
        this.textProxyPort.setLayoutData(data);
        Label labelProxyUsername = new Label(restComp, 131072);
        labelProxyUsername.setText(Labels.getString("AdvancedSettingsDialog.proxyUser"));
        data = new GridData(128);
        labelProxyUsername.setLayoutData(data);
        this.textProxyUsername = new Text(restComp, 2048);
        this.textProxyUsername.setText(config.getString("sfdc.proxyUsername"));
        data = new GridData();
        data.widthHint = 120;
        this.textProxyUsername.setLayoutData(data);
        Label labelProxyPassword = new Label(restComp, 131072);
        labelProxyPassword.setText(Labels.getString("AdvancedSettingsDialog.proxyPassword"));
        data = new GridData(128);
        labelProxyPassword.setLayoutData(data);
        this.textProxyPassword = new Text(restComp, 0x400800);
        this.textProxyPassword.setText(config.getString("sfdc.proxyPassword"));
        data = new GridData();
        data.widthHint = 120;
        this.textProxyPassword.setLayoutData(data);
        Label labelProxyNtlmDomain = new Label(restComp, 131072);
        labelProxyNtlmDomain.setText(Labels.getString("AdvancedSettingsDialog.proxyNtlmDomain"));
        data = new GridData(128);
        labelProxyNtlmDomain.setLayoutData(data);
        this.textProxyNtlmDomain = new Text(restComp, 2048);
        this.textProxyNtlmDomain.setText(config.getString("sfdc.proxyNtlmDomain"));
        data = new GridData();
        data.widthHint = 250;
        this.textProxyNtlmDomain.setLayoutData(data);
        Label blankAgain = new Label(restComp, 0);
        data = new GridData();
        data.horizontalSpan = 2;
        blankAgain.setLayoutData(data);
        Label labelLastRow = new Label(restComp, 0);
        String lastBatch = this.controller.getConfig().getString("process.lastLoadBatchRow");
        if (lastBatch.equals("")) {
            lastBatch = "0";
        }
        labelLastRow.setText(Labels.getFormattedString("AdvancedSettingsDialog.lastBatch", lastBatch));
        data = new GridData();
        data.horizontalSpan = 2;
        labelLastRow.setLayoutData(data);
        Label labelRowToStart = new Label(restComp, 131072);
        labelRowToStart.setText(Labels.getString("AdvancedSettingsDialog.startRow"));
        data = new GridData(128);
        labelRowToStart.setLayoutData(data);
        this.textRowToStart = new Text(restComp, 2048);
        this.textRowToStart.setText(config.getString("process.loadRowToStartAt"));
        data = new GridData();
        data.widthHint = 75;
        this.textRowToStart.setLayoutData(data);
        this.textRowToStart.addVerifyListener(new VerifyListener(){

            @Override
            public void verifyText(VerifyEvent event) {
                event.doit = Character.isISOControl(event.character) || Character.isDigit(event.character);
            }
        });
        this.initBulkApiSetting(useBulkAPI);
        Label labelSeparatorBottom = new Label(restComp, 258);
        data = new GridData(768);
        data.horizontalSpan = 2;
        labelSeparatorBottom.setLayoutData(data);
        new Label(restComp, 0);
        Composite buttonComp = new Composite(restComp, 0);
        data = new GridData(128);
        buttonComp.setLayoutData(data);
        buttonComp.setLayout(new GridLayout(2, false));
        Button ok = new Button(buttonComp, 0x800008);
        ok.setText(Labels.getString("UI.ok"));
        ok.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                Config config = AdvancedSettingsDialog.this.controller.getConfig();
                String currentTextEndpoint = AdvancedSettingsDialog.this.textEndpoint.getText();
                if (currentTextEndpoint != null && !currentTextEndpoint.isEmpty() && !UIUtils.isValidHttpsUrl(currentTextEndpoint)) {
                    MessageDialog alert = new MessageDialog(AdvancedSettingsDialog.this.getParent().getShell(), "Warning", null, Labels.getFormattedString("AdvancedSettingsDialog.serverURLInfo", currentTextEndpoint), 1, new String[]{"OK"}, 0);
                    alert.open();
                    return;
                }
                config.setValue("loader.hideWelcome", AdvancedSettingsDialog.this.buttonHideWelcomeScreen.getSelection());
                config.setValue("sfdc.insertNulls", AdvancedSettingsDialog.this.buttonNulls.getSelection());
                config.setValue("sfdc.loadBatchSize", AdvancedSettingsDialog.this.textBatch.getText());
                if (!(AdvancedSettingsDialog.this.buttonCsvComma.getSelection() || AdvancedSettingsDialog.this.buttonCsvTab.getSelection() || AdvancedSettingsDialog.this.buttonCsvOther.getSelection() && AdvancedSettingsDialog.this.textSplitterValue.getText() != null && AdvancedSettingsDialog.this.textSplitterValue.getText().length() != 0)) {
                    return;
                }
                config.setValue("loader.csvOtherValue", AdvancedSettingsDialog.this.textSplitterValue.getText());
                config.setValue("loader.csvComma", AdvancedSettingsDialog.this.buttonCsvComma.getSelection());
                config.setValue("loader.csvTab", AdvancedSettingsDialog.this.buttonCsvTab.getSelection());
                config.setValue("loader.csvOther", AdvancedSettingsDialog.this.buttonCsvOther.getSelection());
                config.setValue("sfdc.extractionRequestSize", AdvancedSettingsDialog.this.textQueryBatch.getText());
                config.setValue("sfdc.endpoint", currentTextEndpoint);
                config.setValue("sfdc.assignmentRule", AdvancedSettingsDialog.this.textRule.getText());
                config.setValue("process.loadRowToStartAt", AdvancedSettingsDialog.this.textRowToStart.getText());
                config.setValue("sfdc.resetUrlOnLogin", AdvancedSettingsDialog.this.buttonResetUrl.getSelection());
                config.setValue("sfdc.noCompression", AdvancedSettingsDialog.this.buttonCompression.getSelection());
                config.setValue("sfdc.truncateFields", AdvancedSettingsDialog.this.buttonTruncateFields.getSelection());
                config.setValue("sfdc.timeoutSecs", AdvancedSettingsDialog.this.textTimeout.getText());
                config.setValue("process.enableExtractStatusOutput", AdvancedSettingsDialog.this.buttonOutputExtractStatus.getSelection());
                config.setValue("dataAccess.readUTF8", AdvancedSettingsDialog.this.buttonReadUtf8.getSelection());
                config.setValue("dataAccess.writeUTF8", AdvancedSettingsDialog.this.buttonWriteUtf8.getSelection());
                config.setValue("process.useEuropeanDates", AdvancedSettingsDialog.this.buttonEuroDates.getSelection());
                config.setValue("sfdc.timezone", AdvancedSettingsDialog.this.textTimezone.getText());
                config.setValue("sfdc.proxyHost", AdvancedSettingsDialog.this.textProxyHost.getText());
                config.setValue("sfdc.proxyPassword", AdvancedSettingsDialog.this.textProxyPassword.getText());
                config.setValue("sfdc.proxyPort", AdvancedSettingsDialog.this.textProxyPort.getText());
                config.setValue("sfdc.proxyUsername", AdvancedSettingsDialog.this.textProxyUsername.getText());
                config.setValue("sfdc.proxyNtlmDomain", AdvancedSettingsDialog.this.textProxyNtlmDomain.getText());
                config.setValue("sfdc.useBulkApi", AdvancedSettingsDialog.this.buttonUseBulkApi.getSelection());
                config.setValue("sfdc.bulkApiSerialMode", AdvancedSettingsDialog.this.buttonBulkApiSerialMode.getSelection());
                config.setValue("sfdc.bulkApiZipContent", AdvancedSettingsDialog.this.buttonBulkApiZipContent.getSelection());
                AdvancedSettingsDialog.this.controller.saveConfig();
                AdvancedSettingsDialog.this.controller.logout();
                AdvancedSettingsDialog.this.input = Labels.getString("UI.ok");
                shell.close();
            }
        });
        data = new GridData();
        data.widthHint = 75;
        ok.setLayoutData(data);
        Button cancel = new Button(buttonComp, 0x800008);
        cancel.setText(Labels.getString("UI.cancel"));
        cancel.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                AdvancedSettingsDialog.this.input = null;
                shell.close();
            }
        });
        data = new GridData();
        data.widthHint = 75;
        cancel.setLayoutData(data);
        shell.setDefaultButton(ok);
        sc.setContent(container);
        sc.setMinSize(768, 1024);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
    }

    private Text createTextInput(Composite parent, String labelKey, String configKey, String defaultValue, int widthHint) {
        this.createLabel(parent, labelKey);
        Text t = new Text(parent, 2048);
        GridData gd = new GridData();
        if (widthHint > 0) {
            gd.widthHint = widthHint;
        }
        t.setLayoutData(gd);
        String val = this.controller.getConfig().getString(configKey);
        if ("".equals(val) && defaultValue != null) {
            val = defaultValue;
        }
        t.setText(String.valueOf(val));
        return t;
    }

    private void createLabel(Composite parent, String labelKey) {
        Label l = new Label(parent, 131072);
        l.setLayoutData(new GridData(128));
        l.setText(Labels.getString(labelKey));
    }
}

