/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.security;

import com.salesforce.dataloader.security.EncryptionAesUtil;
import java.security.GeneralSecurityException;

public class EncryptionUtil {
    public static byte[] textToBytes(String text) {
        byte[] baBytes = new byte[text.length() / 2];
        for (int j = 0; j < text.length() / 2; ++j) {
            Integer tmpInteger = Integer.decode(new String("0x" + text.substring(j * 2, j * 2 + 2)));
            int tmpValue = tmpInteger;
            if (tmpValue > 127) {
                tmpValue = (tmpValue - 127) * -1;
            }
            tmpInteger = new Integer(tmpValue);
            baBytes[j] = tmpInteger.byteValue();
        }
        return baBytes;
    }

    public static String bytesToText(byte[] bytes) {
        StringBuffer sb = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            Object hex;
            int num = bytes[i];
            if (num < 0) {
                num = 127 + num * -1;
            }
            if (((String)(hex = Integer.toHexString(num))).length() == 1) {
                hex = "0" + (String)hex;
            }
            sb.append((String)hex);
        }
        return sb.toString();
    }

    private static void printUsage() {
        String usage = "\nUtility to encrypt a string based on a static or a provided key\nOptions (mutually exclusive - use one at a time): \n\t-e <plain text> <Path to keyfile>                Encrypt a plain text value, keyfile path\n\t-d <encryptText> <Path to keyfile>               Decrypt an encrypted text back to plain text value using keyfile\n\t-k [Path to Keyfile]                             Generate keyfile with optional keyfile path\n";
        System.out.println(usage);
    }

    public static void main(String[] args) {
        int i;
        String option;
        if (args.length < 1) {
            EncryptionUtil.printUsage();
            System.exit(-1);
        }
        if ((option = args[i = 0]).length() < 2 || option.charAt(0) != '-') {
            System.out.println("Invalid option format: " + args[i]);
            System.exit(-1);
        }
        if (EncryptionUtil.arrayTooSmall(args, i) && option.charAt(1) != 'k') {
            System.out.println("Option '" + option + "' requires at least one parameter.  Please check usage.\n");
            EncryptionUtil.printUsage();
            System.exit(-1);
        }
        String param = null;
        switch (option.charAt(1)) {
            case 'e': {
                EncryptionAesUtil enc = new EncryptionAesUtil();
                param = args[++i];
                if (!EncryptionUtil.arrayTooSmall(args, i)) {
                    String keyFilename = args[++i];
                    try {
                        enc.setCipherKeyFromFilePath(keyFilename);
                        String encrypted = enc.encryptMsg(param);
                        System.out.println("The output string of encryption is: \n" + encrypted);
                    }
                    catch (Exception e) {
                        System.out.println("Error setting the key from file: " + keyFilename + ", error: " + e.getMessage());
                        System.exit(-1);
                    }
                    break;
                }
                System.out.println("Please provide correct parameters!");
                EncryptionUtil.printUsage();
                System.exit(-1);
                break;
            }
            case 'k': {
                try {
                    EncryptionAesUtil encAes = new EncryptionAesUtil();
                    if (i == args.length - 2 || i == args.length - 1) {
                        String filePath = encAes.createKeyFileIfNotExisting(i == args.length - 1 ? null : args[i + 1]);
                        System.out.println("Keyfile \"" + filePath + "\" was created! ");
                        break;
                    }
                    System.out.println("Please provide correct parameters!");
                    EncryptionUtil.printUsage();
                    System.exit(-1);
                }
                catch (Exception e) {
                    System.out.println("Error occurred:  " + e.getMessage());
                }
                break;
            }
            case 'd': {
                EncryptionAesUtil encAes = new EncryptionAesUtil();
                String encryptMsg = args[++i];
                if (!EncryptionUtil.arrayTooSmall(args, i)) {
                    String keyFilename = args[++i];
                    try {
                        encAes.setCipherKeyFromFilePath(keyFilename);
                        String plainText = encAes.decryptMsg(encryptMsg);
                        System.out.println("The output string of decryption is: \n" + plainText);
                    }
                    catch (GeneralSecurityException e) {
                        System.out.println("Failed in decryption: " + e.getMessage() + "\n Make sure using the same keyfile to decrypt.");
                        System.exit(-1);
                    }
                    break;
                }
                System.out.println("Please provide correct parameters!");
                EncryptionUtil.printUsage();
                System.exit(-1);
                break;
            }
            default: {
                System.out.println("Unsupported option: " + option);
                EncryptionUtil.printUsage();
                System.exit(-1);
            }
        }
    }

    private static boolean arrayTooSmall(String[] array, int index) {
        return index + 1 > array.length - 1;
    }
}

