/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.security;

import com.salesforce.dataloader.security.EncryptionUtil;
import com.salesforce.dataloader.util.AppUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;

public class EncryptionAesUtil {
    private static final Logger LOGGER = Logger.getLogger(EncryptionAesUtil.class);
    private static AppUtil.OSType detectedOS;
    private static Cipher cipher;
    private static byte[] cipherKey;
    public static final int ENCRYPTION_KEY_LENGTH_IN_BYTES = 16;
    public static final int IV_LENGTH_IN_BYTES = 16;
    public static final String DEFAULT_KEYFILE_NAME = "dataLoader.key";

    private byte[] extractIvBytes(byte[] cipheredText) {
        byte[] iv = new byte[16];
        System.arraycopy(cipheredText, 0, iv, 0, 16);
        return iv;
    }

    private byte[] extractCipherContent(byte[] cipheredText) {
        byte[] cipheredPassword = new byte[cipheredText.length - 16];
        System.arraycopy(cipheredText, 16, cipheredPassword, 0, cipheredText.length - 16);
        return cipheredPassword;
    }

    private byte[] concatenateByteArray(byte[] a, byte[] b) {
        byte[] c = new byte[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public byte[] generateEncryptionKey() {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[16];
        random.nextBytes(bytes);
        return bytes;
    }

    public byte[] generateIv() {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[16];
        random.nextBytes(bytes);
        return bytes;
    }

    public String createUserProfileKeyName() {
        String path = Paths.get(System.getProperty("user.home"), ".dataloader").toString();
        File customDir = new File(path);
        if (customDir.exists()) {
            LOGGER.debug(customDir + " exists");
        } else if (customDir.mkdirs()) {
            if (detectedOS == AppUtil.OSType.MACOSX || detectedOS == AppUtil.OSType.LINUX) {
                customDir.setReadable(false, false);
                customDir.setReadable(true, true);
                customDir.setExecutable(false, false);
                customDir.setExecutable(true, true);
            }
            LOGGER.info(customDir + " was created");
        } else {
            LOGGER.error(customDir + " was not created");
            throw new RuntimeException("Cannot create directory:" + path);
        }
        return Paths.get(path, DEFAULT_KEYFILE_NAME).toString();
    }

    public String createKeyFileIfNotExisting(String filePath) throws GeneralSecurityException {
        if (filePath == null || filePath.isEmpty() || !Files.exists(Paths.get(filePath, new String[0]), new LinkOption[0])) {
            if (filePath == null || filePath.isEmpty()) {
                filePath = this.createUserProfileKeyName();
            }
            if (!Files.exists(Paths.get(filePath, new String[0]), new LinkOption[0])) {
                byte[] key = this.generateEncryptionKey();
                try (FileOutputStream fos = new FileOutputStream(filePath);){
                    fos.write(key);
                }
                catch (IOException io) {
                    throw new GeneralSecurityException("Failed to open file:" + filePath, io);
                }
                if (detectedOS == AppUtil.OSType.MACOSX || detectedOS == AppUtil.OSType.LINUX) {
                    File file = new File(filePath);
                    file.setReadable(false, false);
                    file.setReadable(true, true);
                }
            }
        }
        this.setCipherKeyFromFilePath(filePath);
        return filePath;
    }

    public void resetCipherKey() {
        cipherKey = null;
    }

    public void setCipherKeyFromFilePath(String filePath) throws GeneralSecurityException {
        byte[] data = new byte[1024];
        try (FileInputStream fis = new FileInputStream(filePath);){
            int size = fis.read(data);
            if (size < 16) {
                throw new GeneralSecurityException("Keyfile content is too short:" + filePath);
            }
            cipherKey = new byte[16];
            System.arraycopy(data, 0, cipherKey, 0, 16);
        }
        catch (IOException io) {
            throw new GeneralSecurityException("Failed to open file: " + filePath, io);
        }
    }

    private void ensureKeyIsSet() throws GeneralSecurityException {
        if (cipherKey != null) {
            return;
        }
        this.createKeyFileIfNotExisting(null);
    }

    public String encryptMsg(String msg) throws GeneralSecurityException {
        try {
            this.ensureKeyIsSet();
            return EncryptionUtil.bytesToText(this.encryptMsg(msg, cipherKey));
        }
        catch (Exception e) {
            LOGGER.error("Fail to encrypt message: " + e.getMessage());
            throw new GeneralSecurityException("Error to encrypt message: ", e);
        }
    }

    public String decryptMsg(String cipherMsgString) throws GeneralSecurityException {
        try {
            this.ensureKeyIsSet();
            byte[] cipherMsg = EncryptionUtil.textToBytes(cipherMsgString);
            return this.decryptMsg(cipherMsg, cipherKey);
        }
        catch (Exception e) {
            LOGGER.error("Fail to decrypt message: " + e.getMessage());
            throw new GeneralSecurityException("Error to decrypt message: ", e);
        }
    }

    public byte[] encryptMsg(String msg, byte[] encryptionKey) throws GeneralSecurityException {
        if (encryptionKey == null || encryptionKey.length != 16) {
            throw new GeneralSecurityException("Encryption key is null or has invalid length");
        }
        SecretKeySpec key = new SecretKeySpec(encryptionKey, "AES");
        byte[] ivBytes = this.generateIv();
        IvParameterSpec iv = new IvParameterSpec(ivBytes);
        cipher.init(1, (Key)key, iv);
        byte[] cipherText = cipher.doFinal(msg.getBytes());
        return this.concatenateByteArray(ivBytes, cipherText);
    }

    public String decryptMsg(byte[] cipherMsg, byte[] encryptionKey) throws GeneralSecurityException {
        if (encryptionKey == null || encryptionKey.length != 16) {
            throw new GeneralSecurityException("Encryption key is null or has invalid length");
        }
        SecretKeySpec key = new SecretKeySpec(encryptionKey, "AES");
        byte[] iv = this.extractIvBytes(cipherMsg);
        cipher.init(2, (Key)key, new IvParameterSpec(iv));
        byte[] cipherContent = this.extractCipherContent(cipherMsg);
        return new String(cipher.doFinal(cipherContent));
    }

    static {
        try {
            cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            detectedOS = AppUtil.getOSType();
        }
        catch (Exception e) {
            LOGGER.error("Fail to initialize encryption: " + e.getMessage());
            throw new RuntimeException("Fail to initialize encryption:  ", e);
        }
    }
}

