/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.process;

import com.salesforce.dataloader.action.progress.ILoaderProgress;
import com.salesforce.dataloader.action.progress.NihilistProgressAdapter;
import com.salesforce.dataloader.config.Config;
import com.salesforce.dataloader.config.Messages;
import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.exception.ControllerInitializationException;
import com.salesforce.dataloader.exception.ParameterLoadException;
import com.salesforce.dataloader.exception.ProcessInitializationException;
import com.salesforce.dataloader.process.ProcessConfig;
import com.sforce.soap.partner.fault.ApiFault;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.InitializingBean;

public class ProcessRunner
implements InitializingBean,
Job,
Runnable {
    public static final String PROCESS_NAME = "process.name";
    private static final Logger logger = Logger.getLogger(ProcessRunner.class);
    String name;
    private final Map<String, String> configOverrideMap = new HashMap<String, String>();
    private Controller controller;

    protected ProcessRunner() {
    }

    @Override
    public synchronized void run() {
        this.run(NihilistProgressAdapter.get());
    }

    public synchronized void run(ILoaderProgress monitor) {
        String oldName = Thread.currentThread().getName();
        String name = this.getName();
        this.setThreadName(name);
        try {
            this.controller = Controller.getInstance(name, true, null);
        }
        catch (ControllerInitializationException e) {
            throw new RuntimeException(e);
        }
        try {
            logger.info(Messages.getString("Process.initializingEngine", new Object[0]));
            Config config = this.controller.getConfig();
            logger.info(Messages.getString("Process.loadingParameters", new Object[0]));
            config.loadParameterOverrides(this.getConfigOverrideMap());
            if (!config.getOperationInfo().isExtraction() || config.getBoolean("process.enableExtractStatusOutput")) {
                this.controller.setStatusFiles(config.getString("process.statusOutputDirectory"), true, false);
            }
            logger.info(Messages.getFormattedString("Process.loggingIn", config.getString("sfdc.endpoint")));
            if (this.controller.login()) {
                this.controller.createDao();
                logger.info(Messages.getString("Process.checkingDao", new Object[0]));
                this.controller.getDao().checkConnection();
                logger.info(Messages.getString("Process.settingFieldTypes", new Object[0]));
                this.controller.setFieldTypes();
                logger.info(Messages.getString("Process.settingReferenceTypes", new Object[0]));
                this.controller.setReferenceDescribes();
                logger.info(Messages.getString("Process.creatingMap", new Object[0]));
                this.controller.createMapper();
                this.controller.executeAction(monitor);
                config.setValue("process.lastRunDate", Calendar.getInstance().getTime());
                config.saveLastRun();
            } else {
                logger.fatal(Messages.getString("Process.loginError", new Object[0]));
            }
        }
        catch (ApiFault e) {
            throw new RuntimeException(e.getExceptionMessage(), e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (this.controller.getDao() != null) {
                this.controller.getDao().close();
            }
            this.setThreadName(oldName);
        }
    }

    private static void ensureLogging() throws FactoryConfigurationError {
        try {
            Controller.initStaticVariable();
        }
        catch (ControllerInitializationException e) {
            logger.error("ensureLogging(): Control not initialized", e);
            throw new RuntimeException(e.getMessage());
        }
        Controller.initLog();
    }

    private void setThreadName(String name) {
        if (name != null && name.length() > 0) {
            try {
                Thread.currentThread().setName(name);
            }
            catch (Exception e) {
                logger.warn("Error setting thread name", e);
            }
        }
    }

    public synchronized Map<String, String> getConfigOverrideMap() {
        return this.configOverrideMap;
    }

    public synchronized void setConfigOverrideMap(Map<String, String> configOverrideMap) {
        if (!this.configOverrideMap.isEmpty()) {
            throw new IllegalStateException("Attempting to set configOverrideMap but there are already " + this.configOverrideMap.size() + " entries");
        }
        this.configOverrideMap.putAll(configOverrideMap);
    }

    public synchronized String getName() {
        return this.name;
    }

    public synchronized void setName(String name) {
        this.name = name;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        String name = this.getName();
        if (name == null || name.length() == 0) {
            logger.fatal(Messages.getFormattedString("Process.missingRequiredArg", "name"));
            throw new ParameterLoadException(Messages.getFormattedString("Process.missingRequiredArg", "name"));
        }
    }

    private static boolean validateCmdLineArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!"-help".equals(arg)) continue;
            System.out.println(Messages.getString("Process.help1", new Object[0]));
            System.out.println(Messages.getString("Process.help2", new Object[0]));
            System.out.println(Messages.getString("Process.help3", new Object[0]));
            System.out.println(Messages.getString("Process.help4", new Object[0]));
            System.out.println(Messages.getString("Process.help5", new Object[0]));
            System.out.println(Messages.getString("Process.help6", new Object[0]));
            return false;
        }
        return true;
    }

    private static void topLevelError(String message, Throwable err) {
        ProcessRunner.ensureLogging();
        logger.fatal(message, err);
        System.exit(-1);
    }

    public static void main(String[] args) {
        ProcessRunner runner = null;
        try {
            runner = ProcessRunner.getInstance(args);
            if (runner == null) {
                ProcessRunner.topLevelError("Process runner is null", new NullPointerException());
            }
        }
        catch (Throwable t) {
            ProcessRunner.topLevelError("Failed to create process", t);
        }
        try {
            runner.run();
        }
        catch (Throwable e) {
            ProcessRunner.topLevelError("Unable to run process " + runner.getName(), e);
        }
    }

    private static ProcessRunner getInstance(String[] args) throws ProcessInitializationException {
        ProcessRunner.ensureLogging();
        if (!ProcessRunner.validateCmdLineArgs(args)) {
            return null;
        }
        Map<String, String> argMap = ProcessRunner.getArgMap(args);
        ProcessRunner runner = ProcessRunner.getInstance(argMap);
        return runner;
    }

    public static ProcessRunner getInstance(Map<String, String> argMap) throws ProcessInitializationException {
        ProcessRunner runner;
        if (argMap != null && argMap.containsKey(PROCESS_NAME)) {
            String processName = argMap.get(PROCESS_NAME);
            runner = ProcessConfig.getProcessInstance(processName);
            runner.getConfigOverrideMap().putAll(argMap);
        } else {
            runner = new ProcessRunner();
            runner.setConfigOverrideMap(argMap);
        }
        return runner;
    }

    private static Map<String, String> getArgMap(String[] args) {
        HashMap<String, String> argMap = new HashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            String[] argArray = args[i].split("=");
            if (argArray.length != 2) continue;
            argMap.put(argArray[0], argArray[1]);
        }
        return argMap;
    }

    public static ProcessRunner getInstance(String processName) throws ProcessInitializationException {
        return ProcessConfig.getProcessInstance(processName);
    }

    @Override
    public void execute(JobExecutionContext arg0) throws JobExecutionException {
        this.run();
    }

    public Controller getController() {
        return this.controller;
    }
}

