/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.process;

import com.salesforce.dataloader.config.Messages;
import com.salesforce.dataloader.controller.Controller;
import com.salesforce.dataloader.exception.ProcessInitializationException;
import com.salesforce.dataloader.process.ProcessRunner;
import java.io.File;
import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class ProcessConfig {
    private static Logger logger = Logger.getLogger(ProcessConfig.class);
    public static final String DEFAULT_CONFIG_FILENAME = "process-conf.xml";
    private static final String DEFAULT_SCHEDULER_FACTORY_NAME = "schedulerFactory";
    private static ApplicationContext configFactory;

    private static String getConfigFileLocation() {
        File confFile = new File(Controller.getConfigDir(), DEFAULT_CONFIG_FILENAME);
        return confFile.getAbsolutePath();
    }

    public static Object getSchedulerInstance() {
        return ProcessConfig.getBeanFactory().getBean(DEFAULT_SCHEDULER_FACTORY_NAME);
    }

    public static ProcessRunner getProcessInstance(String processName) throws ProcessInitializationException {
        try {
            return (ProcessRunner)ProcessConfig.getBeanFactory().getBean(processName);
        }
        catch (Exception e) {
            String errMsg = Messages.getFormattedString("ProcessConfig.errorNoProcess", new String[]{processName, ProcessConfig.getConfigFileLocation()});
            logger.error(errMsg, e);
            throw new ProcessInitializationException(errMsg, e);
        }
    }

    public static synchronized ApplicationContext getBeanFactory() {
        if (configFactory == null) {
            String configFileLocation = ProcessConfig.getConfigFileLocation();
            logger.info(Messages.getFormattedString("ProcessConfig.loadingConfig", configFileLocation));
            if (!configFileLocation.contains(":")) {
                configFileLocation = "file://".concat(configFileLocation);
            }
            configFactory = new FileSystemXmlApplicationContext(configFileLocation);
        }
        return configFactory;
    }
}

