/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.model;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class Row
implements Map<String, Object> {
    private static final int DEFAULT_COLUMN_COUNT = 16;
    private final Map<String, Object> internalMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);

    public Row() {
        this(16);
    }

    public Row(int columnCount) {
    }

    public Row(Map<String, Object> internalMap) {
        this(internalMap.size());
        this.internalMap.putAll(internalMap);
    }

    public static Row emptyRow() {
        return new Row(Collections.emptyMap());
    }

    public static Row singleEntryImmutableRow(String key, Object value) {
        return new Row(Collections.singletonMap(key, value));
    }

    @Override
    public int size() {
        return this.internalMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.internalMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.internalMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.internalMap.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.internalMap.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.internalMap.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.internalMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        this.internalMap.putAll(m);
    }

    @Override
    public void clear() {
        this.internalMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.internalMap.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.internalMap.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.internalMap.entrySet();
    }

    public String toString() {
        return "Row{ size=" + this.internalMap.size() + " columns=" + this.internalMap + "}";
    }
}

