/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.mapping;

import com.salesforce.dataloader.client.PartnerClient;
import com.salesforce.dataloader.exception.MappingInitializationException;
import com.salesforce.dataloader.mapping.Mapper;
import com.salesforce.dataloader.mapping.SOQLInfo;
import com.salesforce.dataloader.model.Row;
import com.sforce.soap.partner.DescribeSObjectResult;
import com.sforce.soap.partner.Field;
import com.sforce.soap.partner.FieldType;
import com.sforce.soap.partner.sobject.SObject;
import com.sforce.ws.ConnectionException;
import com.sforce.ws.bind.XmlObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;

public class SOQLMapper
extends Mapper {
    private static final Logger logger = Logger.getLogger(SOQLMapper.class);
    private SOQLInfo soqlInfo;

    public SOQLMapper(PartnerClient client, Collection<String> columnNames, Field[] fields, String mappingFileName) throws MappingInitializationException {
        super(client, columnNames, fields, mappingFileName);
    }

    public List<String> getDaoColumnsForSoql() {
        ArrayList<String> daoColumns = new ArrayList<String>();
        for (SOQLInfo.SOQLFieldInfo fieldInfo : this.soqlInfo.getSelectedFields()) {
            String daoColumn = this.getMapping(this.normalizeSoql(fieldInfo));
            if (daoColumn == null) continue;
            daoColumns.add(daoColumn);
        }
        return daoColumns;
    }

    public Row mapPartnerSObjectSfdcToLocal(SObject sobj) {
        Row map = new Row();
        this.mapPartnerSObject(map, "", sobj);
        this.mapConstants(map);
        return map;
    }

    private void mapPartnerSObject(Row map, String prefix, XmlObject sobj) {
        Iterator<XmlObject> fields = sobj.getChildren();
        if (fields == null) {
            return;
        }
        while (fields.hasNext()) {
            XmlObject field = fields.next();
            String fieldName = prefix + field.getName().getLocalPart();
            String localName = this.getMapping(fieldName);
            if (localName != null) {
                Object value = field.getValue();
                QName xmlType = field.getXmlType();
                if (xmlType != null && xmlType.getLocalPart().equals("date") && value instanceof Date) {
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                    value = formatter.format(value);
                }
                map.put(localName, value);
            }
            this.mapPartnerSObject(map, fieldName + ".", field);
        }
    }

    @Override
    protected void putPropertyEntry(Map.Entry<Object, Object> entry) {
        String dao = (String)entry.getValue();
        String sfdc = (String)entry.getKey();
        if (SOQLMapper.isConstant(sfdc)) {
            this.putConstant(dao, sfdc);
        } else if (!this.hasDaoColumns() || this.hasDaoColumn(dao)) {
            try {
                this.addSoqlFieldMapping((String)entry.getValue(), new SOQLInfo.SOQLFieldInfo(sfdc));
            }
            catch (SOQLInfo.SOQLParserException e) {
                throw new Mapper.InvalidMappingException(e.getMessage(), e);
            }
        }
    }

    public Row mapCsvRowSfdcToLocal(List<String> headers, List<String> values, StringBuilder id) {
        Row resultRow = new Row();
        ListIterator<String> headerIter = headers.listIterator();
        for (String val : values) {
            String localName;
            String sfdcName = (String)headerIter.next();
            if ("Id".equalsIgnoreCase(sfdcName)) {
                id.append(val);
            }
            if ((localName = this.getMapping(sfdcName)) == null) {
                logger.warn("sfdc returned row that cannot be mapped: " + sfdcName);
                continue;
            }
            resultRow.put(localName, (Object)val);
        }
        this.mapConstants(resultRow);
        return resultRow;
    }

    public void initSoqlMapping(String soql) {
        if (this.soqlInfo == null) {
            try {
                this.soqlInfo = new SOQLInfo(soql);
            }
            catch (SOQLInfo.SOQLParserException e) {
                throw new Mapper.InvalidMappingException(e.getMessage(), e);
            }
        }
        if (this.hasMappings()) {
            return;
        }
        for (SOQLInfo.SOQLFieldInfo fieldInfo : this.soqlInfo.getSelectedFields()) {
            this.addSoqlFieldMapping(fieldInfo.toString(), fieldInfo);
        }
        if (this.hasDaoColumns()) {
            LinkedList<Map.Entry<String, String>> entries = new LinkedList<Map.Entry<String, String>>(this.getMap().entrySet());
            this.clearMap();
            LinkedList<String> daoColumns = new LinkedList<String>(this.getDaoColumns());
            ListIterator daoIter = daoColumns.listIterator();
            block3: while (daoIter.hasNext()) {
                String daoColName = (String)daoIter.next();
                ListIterator entryIter = entries.listIterator();
                while (entryIter.hasNext()) {
                    Map.Entry ent = (Map.Entry)entryIter.next();
                    String sfdcName = (String)ent.getKey();
                    String autoDaoName = (String)ent.getValue();
                    if (!sfdcName.equalsIgnoreCase(daoColName) && !autoDaoName.equalsIgnoreCase(daoColName)) continue;
                    this.putMapping(sfdcName, daoColName);
                    entryIter.remove();
                    daoIter.remove();
                    continue block3;
                }
            }
            if (!daoColumns.isEmpty()) {
                throw new Mapper.InvalidMappingException("The following dao columns could not be mapped: " + daoColumns);
            }
            if (!entries.isEmpty()) {
                logger.warn("The following select fields were not mapped: " + entries);
            }
        }
    }

    private void addSoqlFieldMapping(String daoName, SOQLInfo.SOQLFieldInfo fieldInfo) {
        this.putMapping(this.normalizeSoql(fieldInfo), daoName);
    }

    private String normalizeSoql(SOQLInfo.SOQLFieldInfo fieldInfo) {
        String normalizedFieldName = this.evalSfdcField(fieldInfo.getFieldName());
        return fieldInfo.isAggregate() ? fieldInfo.getAlias() : normalizedFieldName;
    }

    private String evalSfdcField(String fieldExpr) {
        fieldExpr = fieldExpr.toLowerCase();
        if (this.soqlInfo != null) {
            String typePrefix = this.soqlInfo.getTableName().toLowerCase() + ".";
            String aliasPrefix = this.soqlInfo.getTableAlias().toLowerCase() + ".";
            if (fieldExpr.startsWith(typePrefix)) {
                fieldExpr = fieldExpr.substring(typePrefix.length());
            } else if (fieldExpr.startsWith(aliasPrefix)) {
                fieldExpr = fieldExpr.substring(aliasPrefix.length());
            }
        }
        DescribeSObjectResult describeResult = this.getClient().getFieldTypes();
        return this.evalSfdcField(describeResult, fieldExpr);
    }

    private String evalSfdcField(DescribeSObjectResult describeResult, String fieldExpr) {
        int splitIdx = fieldExpr.indexOf(46);
        if (splitIdx >= 0) {
            Field field = this.getReferenceField(describeResult, fieldExpr.substring(0, splitIdx));
            try {
                fieldExpr = fieldExpr.substring(splitIdx + 1);
            }
            catch (IndexOutOfBoundsException e) {
                throw new Mapper.InvalidMappingException("Failed to parse field expression " + fieldExpr);
            }
            assert (field.getReferenceTo() != null && field.getReferenceTo().length > 0);
            try {
                String relEntityName = field.isNamePointing() ? "Name" : field.getReferenceTo()[0];
                describeResult = this.getClient().describeSObject(relEntityName);
                return field.getRelationshipName() + "." + this.evalSfdcField(describeResult, fieldExpr);
            }
            catch (ConnectionException e) {
                throw new Mapper.InvalidMappingException("Connection error while parsing field expression " + fieldExpr, e);
            }
        }
        return this.getSfdcField(describeResult, fieldExpr).getName();
    }

    private Field getSfdcField(DescribeSObjectResult describeResult, String fieldName) {
        for (Field f : describeResult.getFields()) {
            if (!f.getName().equalsIgnoreCase(fieldName)) continue;
            return f;
        }
        throw new Mapper.InvalidMappingException("No such field " + fieldName + " on entity " + describeResult.getName());
    }

    private Field getReferenceField(DescribeSObjectResult describeResult, String relName) {
        for (Field f : describeResult.getFields()) {
            if (FieldType.reference != f.getType() || !relName.equalsIgnoreCase(f.getRelationshipName())) continue;
            return f;
        }
        throw new Mapper.InvalidMappingException("No reference field " + relName + " on entity " + describeResult.getName());
    }
}

