/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.mapping;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;

class SOQLInfo {
    private final List<SOQLFieldInfo> selectedFields;
    private final String tableName;
    private final String tableAlias;
    private static final String SELECT_KEYWORD = "select ";
    private static final String FROM_KEYWORD_WITHOUT_SPACE = "from";
    private static final String FROM_KEYWORD = "from ";
    private static final String WHERE_KEYWORD = "where";

    SOQLInfo(String soql) throws SOQLParserException {
        soql = SOQLInfo.getTrimmed(soql);
        this.selectedFields = new ArrayList<SOQLFieldInfo>();
        String soqlLower = soql.toLowerCase();
        if (!soqlLower.startsWith(SELECT_KEYWORD)) {
            throw SOQLInfo.invalidSoql("No 'SELECT' keyword");
        }
        int fromIdx = soqlLower.indexOf(FROM_KEYWORD);
        if (fromIdx < 0) {
            if (soqlLower.indexOf(FROM_KEYWORD_WITHOUT_SPACE) >= 0) {
                throw SOQLInfo.invalidSoql("No sobject specified after 'FROM' keyword");
            }
            throw SOQLInfo.invalidSoql("No 'FROM' keyword");
        }
        String rawFields = soql.substring(SELECT_KEYWORD.length(), fromIdx).trim();
        AtomicInteger aggIdx = new AtomicInteger();
        for (String fieldString : rawFields.split(",")) {
            SOQLFieldInfo soqlFieldInfo = new SOQLFieldInfo(fieldString, aggIdx);
            this.selectedFields.add(soqlFieldInfo);
        }
        String remainder = SOQLInfo.getTrimmed(soql.substring(fromIdx + FROM_KEYWORD.length()).trim());
        StringTokenizer stok = new StringTokenizer(remainder);
        String tableName = null;
        if (stok.hasMoreTokens()) {
            tableName = stok.nextToken();
        }
        if (WHERE_KEYWORD.equalsIgnoreCase(tableName)) {
            throw SOQLInfo.invalidSoql("Failed to parse table name");
        }
        this.tableName = tableName;
        String alias = null;
        if (stok.hasMoreTokens() && WHERE_KEYWORD.equalsIgnoreCase(alias = stok.nextToken())) {
            alias = "";
        }
        this.tableAlias = alias;
    }

    private static String getTrimmed(String s) {
        if (s == null) {
            throw new NullPointerException();
        }
        if ((s = s.trim()).length() == 0) {
            throw new IllegalArgumentException("Cannot parse empty string");
        }
        return s;
    }

    private static SOQLParserException invalidSoql(String msg) {
        return new SOQLParserException("Invalid soql: " + msg);
    }

    List<SOQLFieldInfo> getSelectedFields() {
        return this.selectedFields;
    }

    String getTableName() {
        return this.tableName;
    }

    String getTableAlias() {
        return this.tableAlias == null ? "" : this.tableAlias;
    }

    static class SOQLFieldInfo {
        private final String alias;
        private final String aggregateFunction;
        private final String fieldName;

        SOQLFieldInfo(String fieldString, AtomicInteger aggregateFieldIdx) throws SOQLParserException {
            fieldString = SOQLInfo.getTrimmed(fieldString);
            int lparenIdx = fieldString.indexOf(40);
            if (lparenIdx == 0) {
                throw SOQLInfo.invalidSoql("Nested queries are not supported");
            }
            if (lparenIdx < 0) {
                this.fieldName = fieldString;
                this.aggregateFunction = null;
                this.alias = null;
            } else {
                int rparenIdx = fieldString.indexOf(41, lparenIdx + 1);
                if (rparenIdx < 0) {
                    throw SOQLInfo.invalidSoql("Could not find closing paren");
                }
                this.aggregateFunction = fieldString.substring(0, lparenIdx);
                this.fieldName = SOQLInfo.getTrimmed(fieldString.substring(lparenIdx + 1, rparenIdx));
                this.alias = this.determineAggregateAlias(aggregateFieldIdx, fieldString.substring(rparenIdx + 1));
            }
        }

        SOQLFieldInfo(String fieldString) throws SOQLParserException {
            this(fieldString, null);
        }

        private String determineAggregateAlias(AtomicInteger aggregateFieldIdx, String aliasString) {
            String alias = aliasString.trim();
            if (alias.length() == 0) {
                alias = aggregateFieldIdx == null ? null : "expr" + aggregateFieldIdx.getAndIncrement();
            }
            return alias;
        }

        String getAlias() {
            return this.alias;
        }

        String getAggregateFunction() {
            return this.aggregateFunction;
        }

        String getFieldName() {
            return this.fieldName;
        }

        boolean isAggregate() {
            return this.aggregateFunction != null;
        }

        boolean hasAlias() {
            return this.alias != null;
        }

        public String toString() {
            if (this.isAggregate()) {
                return this.getAggregateFunction() + "(" + this.getFieldName() + ")";
            }
            return this.getFieldName();
        }
    }

    static class SOQLParserException
    extends Exception {
        public SOQLParserException(String msg) {
            super(msg);
        }
    }
}

