/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.mapping;

import com.salesforce.dataloader.client.PartnerClient;
import com.salesforce.dataloader.config.Messages;
import com.salesforce.dataloader.exception.MappingInitializationException;
import com.salesforce.dataloader.mapping.CaseInsensitiveSet;
import com.salesforce.dataloader.model.Row;
import com.sforce.soap.partner.Field;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public abstract class Mapper {
    private static final Logger logger = Logger.getLogger(Mapper.class);
    private final CaseInsensitiveSet daoColumns;
    private final Map<String, String> constants = this.caseInsensitiveMap();
    private final Map<String, String> map = this.caseInsensitiveMap();
    private final PartnerClient client;
    private final CaseInsensitiveSet fields;

    private <V> Map<String, V> caseInsensitiveMap() {
        return new TreeMap(String.CASE_INSENSITIVE_ORDER);
    }

    protected Mapper(PartnerClient client, Collection<String> columnNames, Field[] fields, String mappingFileName) throws MappingInitializationException {
        this.client = client;
        this.fields = new CaseInsensitiveSet();
        TreeSet<String> daoColumns = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        if (columnNames != null) {
            daoColumns.addAll(columnNames);
        }
        this.daoColumns = new CaseInsensitiveSet(Collections.unmodifiableSet(daoColumns));
        this.putPropertyFileMappings(mappingFileName);
        if (fields != null) {
            for (Field field : fields) {
                this.fields.add(field.getName());
            }
        }
    }

    public final void putMapping(String src, String dest) {
        this.map.put(this.daoColumns.getOriginal(src), this.fields.getOriginal(dest));
    }

    protected void putConstant(String name, String value) {
        this.handleMultipleValuesFromConstant(name, Mapper.extractConstant(value));
    }

    private void handleMultipleValuesFromConstant(String name, String value) {
        StringTokenizer st = new StringTokenizer(name, ",");
        while (st.hasMoreElements()) {
            String v = st.nextToken();
            v = v.trim();
            this.constants.put(v, value);
        }
    }

    private static String extractConstant(String constantVal) {
        return constantVal.substring(1, constantVal.length() - 1);
    }

    protected void mapConstants(Row rowMap) {
        rowMap.putAll((Map<? extends String, ?>)this.constants);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(String fileName) throws MappingInitializationException {
        Properties props = new Properties();
        if (fileName != null && fileName.length() > 0) {
            try (FileInputStream in = new FileInputStream(fileName);){
                props.load(in);
            }
            catch (IOException e) {
                String errMsg = Messages.getMessage(this.getClass(), "errorLoad", e.getMessage());
                logger.error(errMsg, e);
                throw new MappingInitializationException(errMsg, e);
            }
        }
        return props;
    }

    public void putPropertyFileMappings(String fileName) throws MappingInitializationException {
        this.putPropertyFileMappings(this.loadProperties(fileName));
    }

    public void putPropertyFileMappings(Properties props) {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            this.putPropertyEntry(entry);
        }
    }

    protected abstract void putPropertyEntry(Map.Entry<Object, Object> var1);

    protected boolean hasDaoColumns() {
        return !this.daoColumns.isEmpty();
    }

    protected static boolean isConstant(String name) {
        if (name == null) {
            return false;
        }
        int len = name.length();
        if (len < 2) {
            return false;
        }
        return name.charAt(0) == '\"' && name.charAt(len - 1) == '\"';
    }

    protected boolean hasMappings() {
        return !this.map.isEmpty();
    }

    public Collection<String> getDestColumns() {
        return this.map.values();
    }

    public String getMapping(String srcName) {
        return this.getMapping(srcName, false);
    }

    public String getMapping(String srcName, boolean strictMatching) {
        if (this.map.containsKey(srcName)) {
            return this.map.get(srcName);
        }
        if (!strictMatching) {
            for (Map.Entry<String, String> entry : this.map.entrySet()) {
                if (!entry.getKey().endsWith("." + srcName)) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    public void clearMap() {
        this.map.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String filename) throws IOException {
        if (filename == null) {
            throw new IOException(Messages.getMessage(this.getClass(), "errorFileName", new Object[0]));
        }
        Properties props = new Properties();
        props.putAll(this.map);
        try (FileOutputStream out = new FileOutputStream(filename);){
            props.store(out, "Mapping values");
        }
    }

    public boolean hasDaoColumn(String localName) {
        return this.daoColumns.contains(localName);
    }

    public void removeMapping(String srcName) {
        this.map.remove(srcName);
    }

    protected Map<String, String> getMap() {
        return Collections.unmodifiableMap(this.map);
    }

    public Map<String, String> getConstantsMap() {
        return Collections.unmodifiableMap(this.constants);
    }

    protected Set<String> getDaoColumns() {
        return this.daoColumns.getOriginalValues();
    }

    public PartnerClient getClient() {
        return this.client;
    }

    public static class InvalidMappingException
    extends RuntimeException {
        public InvalidMappingException(String msg, Throwable e) {
            super(msg, e);
        }

        public InvalidMappingException(String msg) {
            super(msg);
        }
    }
}

