/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.mapping;

import com.salesforce.dataloader.client.PartnerClient;
import com.salesforce.dataloader.exception.MappingInitializationException;
import com.salesforce.dataloader.mapping.Mapper;
import com.salesforce.dataloader.model.Row;
import com.sforce.soap.partner.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;

public class LoadMapper
extends Mapper {
    private static final Logger logger = Logger.getLogger(Mapper.class);

    public LoadMapper(PartnerClient client, Collection<String> columnNames, Field[] fields, String mappingFileName) throws MappingInitializationException {
        super(client, columnNames, fields, mappingFileName);
    }

    @Override
    protected void putPropertyEntry(Map.Entry<Object, Object> entry) {
        String dao = (String)entry.getKey();
        String sfdc = (String)entry.getValue();
        if (LoadMapper.isConstant(dao)) {
            this.putConstant(sfdc, dao);
        } else if (!this.hasDaoColumns() || this.hasDaoColumn(dao)) {
            this.putMapping(dao, sfdc);
        }
    }

    public Map<String, String> getMappingWithUnmappedColumns(boolean includeUnmapped) {
        HashMap<String, String> result = new HashMap<String, String>(this.getMap());
        if (includeUnmapped) {
            for (String daoColumn : this.getDaoColumns()) {
                if (this.getMapping(daoColumn, true) != null) continue;
                result.put(daoColumn, null);
            }
        }
        return result;
    }

    public Row mapData(Row localRow) {
        Row mappedData = new Row();
        for (Map.Entry<String, Object> entry : localRow.entrySet()) {
            String sfdcName = this.getMapping(entry.getKey(), true);
            if (StringUtils.hasText(sfdcName)) {
                mappedData.put(sfdcName, entry.getValue());
                continue;
            }
            logger.info("Mapping for field " + entry.getKey() + " will be ignored since destination column is empty");
        }
        this.mapConstants(mappedData);
        return mappedData;
    }

    public void verifyMappingsAreValid() throws MappingInitializationException {
        for (Map.Entry<String, String> entry : this.getMappingWithUnmappedColumns(false).entrySet()) {
            Field f;
            String sfdcName = entry.getValue();
            if (!StringUtils.hasText(sfdcName) || (f = this.getClient().getField(sfdcName)) != null) continue;
            throw new MappingInitializationException("Field mapping is invalid: " + entry.getKey() + " => " + sfdcName);
        }
    }
}

