/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.dataloader.mapping;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class CaseInsensitiveSet {
    private final HashMap<String, String> originalMap = new HashMap();

    public CaseInsensitiveSet() {
    }

    public CaseInsensitiveSet(Set<String> values) {
        this();
        for (String value : values) {
            this.add(value);
        }
    }

    public void add(String value) {
        String lowerCase = value.toLowerCase();
        this.originalMap.put(lowerCase, value);
    }

    public boolean contains(String value) {
        return value != null ? this.originalMap.containsKey(value.toLowerCase()) : false;
    }

    public String getOriginal(String value) {
        return this.contains(value) ? this.originalMap.get(value.toLowerCase()) : value;
    }

    public boolean isEmpty() {
        return this.originalMap.isEmpty();
    }

    public Set<String> getOriginalValues() {
        return new HashSet<String>(this.originalMap.values());
    }
}

